********************************************************************************
* Program:  Creates education shares by group for productivity growth term
********************************************************************************

foreach g in "racegender" {
	foreach r in "M" "F" {
	foreach s in "White" "Black" "Hispanic" "Other" {

		use "./Data_cleaning/Data/cps_earnings.dta", clear
		drop _*
		drop if missing(`g'group)
		*keep if agegroup == 1
		
		decode(`g'group), gen(group_str)
		gen gender_dummy = . 
		replace gender_dummy = 1 if strpos(group_str, `"`r'"')
		gen race_dummy = . 
		replace race_dummy = 1 if strpos(group_str, `"`s'"')
		keep if gender_dummy == 1 & race_dummy == 1

		
		sort date_ym `g'group
		egen newid = group(`g'group)
			
	
		gen wgt_HS = ernwgt if educgroup == 1
		gen wgt_AC = ernwgt if educgroup == 2
		gen wgt_BA = ernwgt if educgroup == 3
		gen wgt_MA = ernwgt if educgroup == 4
		
		
		foreach i in "HS" "AC" "BA" "MA" {
			replace wgt_`i' = 0 if missing(wgt_`i') 
		}
		
		preserve
			collapse (sum) wgt_HS wgt_AC wgt_BA wgt_MA, by(date_ym newid)
			xtset newid date_ym
			tsfill
			
			rename wgt_HS wgt_hs
			rename wgt_AC wgt_ac
			rename wgt_BA wgt_ba
			rename wgt_MA wgt_ma  
			
			gen tmp = wgt_hs + wgt_ac + wgt_ba + wgt_ma
			gen share_hs = wgt_hs / tmp
			gen share_ac = wgt_ac / tmp 
			gen share_ba = wgt_ba / tmp
			gen share_ma = wgt_ma / tmp 
			
			drop tmp 
		
			save "./Data_cleaning/Data/`g'_educ_`r'_`s'.dta", replace
		restore
		
		gen ahe_HS = ahe_all if educgroup == 1
		gen ahe_AC = ahe_all if educgroup == 2 
		gen ahe_BA = ahe_all if educgroup == 3
		gen ahe_MA = ahe_all if educgroup == 4
		
		collapse (mean) ahe_HS ahe_AC ahe_BA ahe_MA [aweight = ernwgt], by(date_ym newid)
		
		rename ahe_HS ahe_hs
		rename ahe_AC ahe_ac
		rename ahe_BA ahe_ba
		rename ahe_MA ahe_ma 
	
		
		save "./Data_cleaning/Data/`g'_educAHE_`r'_`s'.dta", replace
		
		}

	}

}
