** DEMOGRAPHICALLY ADJUSTED EDUCATION RATES FOR GROUPS


foreach r in "Black" "White" "Other" "Hispanic" {
local title = strproper("`r'")

	foreach g in "$RaceCategories" {
		*Get share_base counterfactuals

		use "./Data_cleaning/Data/`g'_util_White.dta", clear
		drop if missing(newid)
		
		gen base_share_hs = share_hs
		gen base_share_ac = share_ac
		gen base_share_ba = share_ba
		gen base_share_ma = share_ma 
		
		gen base_share_ba_underutil = share_ba_underutil
		gen base_share_ma_underutil = share_ma_underutil 
		gen base_share_ba_util = share_ba_util
		gen base_share_ma_util = share_ma_util
		
		keep date_ym base* newid
		
		tempfile counter_educutil
		save `counter_educutil'
		
		*Set counterfactuals as new education / utilization 
		use "./Data_cleaning/Data/`g'_util_`r'.dta", clear
		drop if missing(newid)
		
		merge 1:1 date_ym newid using `counter_educutil', nogen
		
		* If group's bachelor + master > baseline bachelor + master use group's share
		gen educ_dummy = base_share_ac + base_share_ba + base_share_ma
		replace base_share_hs = share_hs if (share_ac + share_ba + share_ma) > educ_dummy 
		replace base_share_ac = share_ac if (share_ac + share_ba + share_ma) > educ_dummy 
		replace base_share_ba = share_ba if (share_ac + share_ba + share_ma) > educ_dummy 
		replace base_share_ma = share_ma if (share_ac + share_ba + share_ma) > educ_dummy 
		
		* If group's underutlization < baseline for a given education level then use the group's underutlization
		* (less underutilization is better)
		replace base_share_ba_util = share_ba_util if share_ba_underutil < base_share_ba_underutil 
		replace base_share_ma_util = share_ma_util if share_ma_underutil < base_share_ma_underutil 
	
		replace base_share_ba_underutil = share_ba_underutil if share_ba_underutil < base_share_ba_underutil 
		replace base_share_ma_underutil = share_ma_underutil if share_ma_underutil < base_share_ma_underutil 

		* Merge in earnings for each group
		merge 1:1 date_ym newid using "./Data_cleaning/Data/`g'_utilAHE_`r'.dta"
		xtset newid date_ym
		
		* adjusted earnings from education and utilization
		qui gen double ahe_adj_`g'  = ahe_hs*base_share_hs + ahe_ac*base_share_ac + (ahe_ba_underutil * base_share_ba_underutil + ahe_ba_util * base_share_ba_util)*base_share_ba + (ahe_ma_underutil * base_share_ma_underutil + ahe_ma_util * base_share_ma_util)*base_share_ma

		rename ahe_adj_`g' ahe_adj_ue_`g'
		keep date_ym newid ahe_adj_ue_`g'
		save "./Shift_share/AGR_race_dta/`g'adj_ue_`r'", replace
	
		
	}
}	

	