********************************************************************************
* Program:  Calculates utilization shares by education group and corresponding ahe
********************************************************************************

foreach g in "$RaceCategories" {
	foreach r in "White" "Black" "Hispanic" "Other" {
	
		use "./Data_cleaning/Data/cps_earnings.dta", clear
		drop if missing(`g'group)
		drop _* 
		

		decode(`g'group), gen(group_str)
		gen race_dummy = . 
		replace race_dummy = 1 if strpos(group_str, `"`r'"')
		keep if race_dummy == 1
		
		sort date_ym `g'group
		egen newid = group(`g'group)

		gen wgt_HS = ernwgt if educgroup == 1
		gen wgt_AC = ernwgt if educgroup == 2
		gen wgt_BA = ernwgt if educgroup == 3
		gen wgt_MA = ernwgt if educgroup == 4
			
		gen wgt_BA_underutil = ernwgt if utilgroup == 1 & educgroup == 3
		gen wgt_MA_underutil = ernwgt if utilgroup == 1 & educgroup == 4

		gen wgt_BA_util = ernwgt if utilgroup == 2 & educgroup == 3 
		gen wgt_MA_util = ernwgt if utilgroup == 2 & educgroup == 4
		
		
		foreach i in "HS" "AC" "BA_util" "BA_underutil" "MA_util" "MA_underutil" "BA" "MA"{
			replace wgt_`i' = 0 if missing(wgt_`i') 
		}
		
		preserve
			collapse (sum) wgt_HS wgt_AC wgt_BA wgt_MA wgt_BA_underutil wgt_BA_util wgt_MA_underutil wgt_MA_util, by(date_ym newid)
			xtset newid date_ym
			tsfill
			
			rename wgt_HS wgt_hs
			rename wgt_AC wgt_ac
			rename wgt_BA wgt_ba
			rename wgt_MA wgt_ma 
			rename wgt_BA_underutil wgt_ba_underutil
			rename wgt_MA_underutil wgt_ma_underutil
			rename wgt_BA_util wgt_ba_util
			rename wgt_MA_util wgt_ma_util 
			
			gen tmp = wgt_hs + wgt_ac + wgt_ba + wgt_ma
			gen share_hs = wgt_hs / tmp
			gen share_ac = wgt_ac / tmp 
			gen share_ba = wgt_ba / tmp
			gen share_ma = wgt_ma / tmp 
			drop tmp

			gen share_ba_underutil = wgt_ba_underutil / (wgt_ba_underutil + wgt_ba_util)
			gen share_ma_underutil = wgt_ma_underutil / (wgt_ma_underutil + wgt_ma_util)
			gen share_ba_util = wgt_ba_util / (wgt_ba_underutil + wgt_ba_util)
			gen share_ma_util = wgt_ma_util / (wgt_ma_underutil + wgt_ma_util)
		
			save "./Data_cleaning/Data/`g'_util_`r'.dta", replace
		restore
		
		gen ern_HS = real_ern_all if educgroup == 1
		gen ern_AC = real_ern_all if educgroup == 2 
		gen ern_BA = real_ern_all if educgroup == 3
		gen ern_MA = real_ern_all if educgroup == 4
		
		gen hr_HS = hr_all if educgroup == 1
		gen hr_AC = hr_all if educgroup == 2
		gen hr_BA = hr_all if educgroup == 3
		gen hr_MA = hr_all if educgroup == 4
		
		gen ern_BA_underutil = real_ern_all if educgroup == 3 & utilgroup == 1
		gen ern_MA_underutil = real_ern_all if educgroup == 4 & utilgroup == 1
		gen ern_BA_util = real_ern_all if educgroup == 3 & utilgroup == 2
		gen ern_MA_util = real_ern_all if educgroup == 4 & utilgroup == 2
		gen ern_BA_MA_util = real_ern_all if (educgroup == 3 | educgroup == 4) & utilgroup == 2
		gen ern_BA_MA_underutil = real_ern_all if (educgroup == 3 | educgroup == 4) & utilgroup == 1
		
		gen hr_BA_underutil = hr_all if educgroup == 3 & utilgroup == 1
		gen hr_MA_underutil = hr_all if educgroup == 4 & utilgroup == 1
		gen hr_BA_util = hr_all if educgroup == 3 & utilgroup == 2
		gen hr_MA_util = hr_all if educgroup == 4 & utilgroup == 2
		gen hr_BA_MA_util = hr_all if (educgroup == 3 | educgroup == 4) & utilgroup == 2
		gen hr_BA_MA_underutil = hr_all if (educgroup == 3 | educgroup == 4) & utilgroup == 1
		
		collapse ern_HS ern_AC ern_BA* ern_MA* hr_HS hr_AC hr_BA* hr_MA* [aweight = ernwgt], by(date_ym newid)
		
		
		gen ahe_hs = ern_HS / hr_HS
		gen ahe_ac = ern_AC / hr_AC
		gen ahe_ba = ern_BA / hr_BA
		gen ahe_ma = ern_MA / hr_MA
		gen ahe_ba_underutil = ern_BA_underutil / hr_BA_underutil
		gen ahe_ma_underutil = ern_MA_underutil / hr_MA_underutil
		gen ahe_ba_util = ern_BA_util / hr_BA_util
		gen ahe_ma_util = ern_MA_util / hr_MA_util
		gen ahe_ba_ma_util = ern_BA_MA_util / hr_BA_MA_util
		gen ahe_ba_ma_underutil = ern_BA_MA_underutil / hr_BA_MA_underutil
		

		save "./Data_cleaning/Data/`g'_utilAHE_`r'.dta", replace
		
		preserve
				
		keep ahe* date_ym newid
		rename ahe_hs ahe_hs_`g'
		rename ahe_ac ahe_ac_`g'
		rename ahe_ba_util ahe_ba_util_`g'
		rename ahe_ma_util ahe_ma_util_`g'
		rename ahe_ba_underutil ahe_ba_u_util_`g'
		rename ahe_ma_underutil ahe_ma_u_util_`g'
		
		reshape wide ahe*, i(date_ym) j(newid)
	
		export excel using "./Data_cleaning/Output/ahe_util.xlsx", sheet("`r'") sheetreplace firstrow(varlab)
		restore
		
	}

}
