********************************************************************************
* Program:  Calculates average AHE by different granularities
********************************************************************************

use "./Data_cleaning/Data/cps_earnings.dta", clear
		drop _*
		drop if missing(agegroup)
		drop if missing(gendergroup)
		
		sort date_ym agegroup gendergroup
		
		gen ern_HS = real_ern_all if educgroup == 1
		gen ern_AC = real_ern_all if educgroup == 2 
		gen ern_BA = real_ern_all if educgroup == 3
		gen ern_MA = real_ern_all if educgroup == 4
		
		gen hr_HS = hr_all if educgroup == 1
		gen hr_AC = hr_all if educgroup == 2
		gen hr_BA = hr_all if educgroup == 3
		gen hr_MA = hr_all if educgroup == 4
		
		gen ern_BA_underutil = real_ern_all if educgroup == 3 & utilgroup == 1
		gen ern_MA_underutil = real_ern_all if educgroup == 4 & utilgroup == 1
		gen ern_BA_util = real_ern_all if educgroup == 3 & utilgroup == 2
		gen ern_MA_util = real_ern_all if educgroup == 4 & utilgroup == 2
		gen ern_BA_MA_util = real_ern_all if (educgroup == 3 | educgroup == 4) & utilgroup == 2
		gen ern_BA_MA_underutil = real_ern_all if (educgroup == 3 | educgroup == 4) & utilgroup == 1
		
		gen hr_BA_underutil = hr_all if educgroup == 3 & utilgroup == 1
		gen hr_MA_underutil = hr_all if educgroup == 4 & utilgroup == 1
		gen hr_BA_util = hr_all if educgroup == 3 & utilgroup == 2
		gen hr_MA_util = hr_all if educgroup == 4 & utilgroup == 2
		gen hr_BA_MA_util = hr_all if (educgroup == 3 | educgroup == 4) & utilgroup == 2
		gen hr_BA_MA_underutil = hr_all if (educgroup == 3 | educgroup == 4) & utilgroup == 1
		
		
		
		collapse (mean) ern_* hr* [pweight = ernwgt], by(date_ym agegroup gendergroup)
		
		gen ahe_hs = ern_HS / hr_HS
		gen ahe_ac = ern_AC / hr_AC
		gen ahe_ba = ern_BA / hr_BA
		gen ahe_ma = ern_MA / hr_MA
		gen ahe_ba_underutil = ern_BA_underutil / hr_BA_underutil
		gen ahe_ma_underutil = ern_MA_underutil / hr_MA_underutil
		gen ahe_ba_util = ern_BA_util / hr_BA_util
		gen ahe_ma_util = ern_MA_util / hr_MA_util
		gen ahe_ba_ma_util = ern_BA_MA_util / hr_BA_MA_util
		gen ahe_ba_ma_underutil = ern_BA_MA_underutil / hr_BA_MA_underutil
		
		gen newid = 1
		replace newid = 2 if agegroup == 2 & gendergroup == 1
		replace newid = 3 if agegroup == 3 & gendergroup == 1
		replace newid = 4 if agegroup == 4 & gendergroup == 1
		replace newid = 5 if agegroup == 1 & gendergroup == 2
		replace newid = 6 if agegroup == 2 & gendergroup == 2
		replace newid = 7 if agegroup == 3 & gendergroup == 2
		replace newid = 8 if agegroup == 4 & gendergroup == 2
		
		*foreach i of varlist ahe_occ* {
		*	replace `i' = 0 if missing(`i') // | ernwgt < 0
		*}
		
		save "./Data_cleaning/Data/agegender_AHE_ave.dta", replace
		
	
