********************************************************************************
* Program:  Collect CPS Data for Economic Gains from Equity
* Authors:  Shelby Buckman, Mary Daly, Laura Choi, Lily Seitelman
* Contact:  If you have any questions contact Shelby Buckman at shelby.buckman@gmail.com 
*           or Lily Seitelman at lilyseitelman@gmail.com

* Notes:    We only provide the cps_extract.dta that is created at the end of 0_CPS_clean_v3.do.
*			If you are running the replication files start in 1_labor_shares.do.
*			This set of replication files is set up to run for 25-64 year olds. 
*			If you wish to see results for 25-34 year olds, keep agegroup 1 only and proceed to run files. 
********************************************************************************
clear
set more off
set max_memory 50g
cap log close

* Set demographic groups - ALL GROUPS MUST CONTAIN RACE 
# delimit ;
global categories
"race"
"racegender"
"agerace"
"agegenderrace"
"gender"
"agegender"
;

global RaceCategories
"race"
"racegender"
"agerace"
"agegenderrace"
;


# delimit cr

********************************************************************************
* Set global directories 
cd "/home/buckman/Labor_Disparities/Replication_files/"
global programs_data "/home/buckman/Labor_Disparities/Replication_files/Data_cleaning/Programs/"
global programs_ss "/home/buckman/Labor_Disparities/Replication_files/Shift_share/Programs/"
global programs_growth "/home/buckman/Labor_Disparities/Replication_files/Adjusted_growth/"
global programs_proj "/home/buckman/Labor_Disparities/Replication_files/Misc/Projections/Programs/"
global programs_elast "/home/buckman/Labor_Disparities/Replication_files/Misc/Elasticities/Programs/"

global numrace = 4
global numeduc = 4
global numgender = 2
global numage = 4
global nummet = 2
global numutil = 2
********************************************************************************
* Pull in CPS match data 
use "/home/buckman/CPS_files/CPS_Match.dta", clear

* Keep 1990 - present (ernwgt starts in 1982)
keep if ym >= tm(1990m1)

* Simple Counterfactual ********************************************************
do "${programs_data}/simple_counterfactual.do"

* Main Analysis ****************************************************************
* Data_cleaning 
do "${programs_data}/0_CPS_clean_v3.do" 			// Main CPS cleaning - defines demographic groups
do "${programs_data}/1_labor_shares.do" 			// Creates epop, lfpr wgts and shares (not by educ)
do "${programs_data}/1_earnings_overall.do" 		// Creates earnings, hours wgts and shares (not by educ)
do "${programs_data}/2_earnings_shares.do"			// Creates actual earnings by age, gender, race group
do "${programs_data}/2_avg_earnings.do"				// Creates actual earnings by age, gender, race group
do "${programs_data}/2_educ_shares.do" 				// Creates earnings, hours wgts and shares (earnings by educ)
do "${programs_data}/2_util_shares.do" 				// Creates utilization wgts and shares (by educ)

* Shift_share
do "${programs_ss}/epop_shift_share.do"				// Epop
do "${programs_ss}/hours_shift_share.do"			// Hours
do "${programs_ss}/education_shift_share.do"		// Education
do "${programs_ss}/utilization_shift_share.do"		// Utilization
do "${programs_ss}/util_educ_shift_share.do"		// Education and Utilization
do "${programs_ss}/utileducAHE_shift_share.do" 	 	// Education and Utilization shift share and AHE with white earnings 
do "${programs_ss}/utileducAHE_shift_share.do" 	 	// Education and Utilization shift share and AHE with average earnings
 
* Adjusted_growth
do "${programs_growth}/adj_growth_sum.do"			// Pulls in combinations of shift-shares to calculate growth accounting

* Scaling up to NIPA
do "${programs_growth}/NIPA_pc.do"


* Run projections
do "${programs_proj}/Projections.do"
do "${programs_proj}/Adjusted_Growth_pop_Proj_byrace.do"


* Calculate percentage change in Employment and multiply by elasticities
do "${programs_elast}/epop_shift_share_Elevelcalc.do"			// Elevel
do "${programs_elast}/adj_growth_sum_elasticity.do"			// Pulls in combinations of shift-shares to calculate growth accounting

