********** Calculate urate, lfrate, and erate by for each group ****************

foreach g in "racegender" {	
		
		foreach r in u e lf {
			*local r u
			*local g agegenderrace
			use "./Data_cleaning/Data/`g'share.dta", clear
			drop if missing(`g'group)
			
			*keep if agegroup >= 25 | agegroup <= 34
			
			foreach e in "M" "F" {
			foreach s in "White" "Black" "Hispanic" "Other" {
			*local e F
				preserve
				decode(`g'group), gen(group_str)
				gen gender_dummy = . 
				replace gender_dummy = 1 if strpos(group_str, `"`e'"')
				gen race_dummy = . 
				replace race_dummy = 1 if strpos(group_str, `"`s'"')
				keep if gender_dummy == 1 & race_dummy == 1
				
				sort date_ym `g'group
				egen newid = group(`g'group)
				drop group_str gender_dummy race_dummy `g'group
				save "./Data_cleaning/Data/`g'share_`e'_`s'.dta", replace
				
			}
		}
		
	}
}
