********************************************************************************
* Program:  Creates output counterfactuals
********************************************************************************


foreach r in "White" "Black" "Hispanic" "Other" {
	local g "agegenderrace"

	* Merge in actual earnings and hours
	use "./Data_cleaning/Data/`g'ahe_`r'.dta", clear
	keep date_ym newid hr_group ahe_group
	* Merge in actual epop & population level
	merge 1:1 date_ym newid using "./Data_cleaning/Data/`g'share_`r'.dta", nogen
	* Merge in a,g,r employment to popoulation ratio
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_epop_`r'.dta", nogen 
	* Merge in adjusted hours
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_hr_`r'.dta", nogen 
	* Merge in adjusted ahe from education
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_educ_`r'.dta", nogen
	* Merge in adjusted ahe from educ & utilization & occupation
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ue_`r'.dta", nogen
	
	gen group_pop = tot_pop * (share_pop / 100)

	* Merge in adjusted ahe from baseline ahe and baseline group utilization and education shares with white earnings
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ueAHE_`r'.dta", nogen
	* Merge in adjusted ahe from baseline ahe and baseline group utilization and education shares with average earnings
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ueAHE_`r'_avg.dta", nogen

	* Make erate from 0-1
	replace erate = erate / 100 
	replace erate_adj_`g' = base_erate / 100

	* To back out overall adjusted erate, hours, etc. after full counterfactual 
	gen test_hours = hr_group * group_pop * erate
	gen test_ahe = ahe_group * group_pop * erate
	gen test_elevel = erate * group_pop
	gen test_ba_ma = (share_ba + share_ma) * group_pop * erate
	gen test_ba_util = (share_ba_util * share_ba) *group_pop * erate
	gen test_ma_util = (share_ma_util * share_ma) *group_pop * erate
	
	gen test_adj_elevel = erate_adj_`g' * group_pop
	gen test_adj_hours = hrs_all_adj_`g' * group_pop * erate
	gen test_adj_ba_ma = (base_share_ba + base_share_ma) * group_pop * erate
	gen test_adj_ba_util = (base_share_ba_util * share_ba) *group_pop * erate
	gen test_adj_ma_util = (base_share_ma_util * share_ma) *group_pop * erate
			
	/*
	* Adjusted sequential counterfactual output:
	Output 0 = (actual epop * actual population * actual hours * actual ahe) * 52
	Output 1 = (adj epop * actual population * actual hours * actual ahe) * 52
	Output 2 = (adj epop * actual population * adj hours * actual ahe) * 52
	Output 3 = (adj epop * actual population * adj hours * adj educ_ahe) * 52
	Output 4 = (adj epop * actual population * adj hours * adj util_ahe) * 52
	Output 5 = (adj epop * actual population * adj hours * adj utileduc_ahe) * 52
	*/
	
	* Observed output
	gen output0_`g' = (erate * group_pop * hr_group * ahe_group) * 52
	
	* Just shifting shares - keep group observed wage
	gen output1_seq_`g' = (erate_adj_`g' * group_pop * hr_group * ahe_group) * 52
	gen output2_seq_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_group) * 52
	gen output3_seq_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_e_`g') * 52
	gen output4_seq_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_ue_`g') * 52
	
	* With white wages
	gen output5_seq_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_all_ueAHE_`g') * 52
	
	* With average wages
	gen output6_seq_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_all_ueAHE_`g'_avg) * 52


	keep date_ym output* test_* tot_pop group_pop erate_cps newid agegenderracegroup
	
	save "./Adjusted_growth/Output/output_counter_`r'.dta", replace 
	export excel using "./Adjusted_growth/Output/output_counter_race_agr.xlsx", sheet(`"`r'"') sheetreplace firstrow(varlab)
	

}


* Merge AGR together and collapse to aggregate output
use "./Adjusted_growth/Output/output_counter_White.dta", clear 
append using "./Adjusted_growth/Output/output_counter_Black.dta"
append using "./Adjusted_growth/Output/output_counter_Hispanic.dta"
append using "./Adjusted_growth/Output/output_counter_Other.dta"

collapse (sum) output* group_pop test_* (mean) tot_pop erate_cps, by(date_ym)

gen aggr_erate = (test_elevel / tot_pop) * 100
gen aggr_hrs = test_hours / (tot_pop * (erate_cps / 100))
gen aggr_ahe = test_ahe / (tot_pop * (erate_cps / 100))
gen aggr_ba_ma = test_ba_ma / (tot_pop * (erate_cps / 100))
gen aggr_util = (test_ba_util + test_ma_util) / test_ba_ma

gen aggr_adj_erate = (test_adj_elevel / tot_pop) 
gen aggr_adj_hrs = test_adj_hours / (tot_pop * (erate_cps / 100))
gen aggr_adj_ba_ma = test_adj_ba_ma / (tot_pop * (erate_cps / 100))
gen aggr_adj_util = (test_adj_ba_util + test_adj_ma_util) / test_ba_ma

export excel using "./Adjusted_growth/Output/output_counterfactual_summed.xlsx", sheet("Overall") sheetreplace firstrow(varlab)
