********************************************************************************
* Program:  Calculates the percent change and scales up to NIPA 
********************************************************************************

* Pull in PCE Index to change NIPA to real $2019
use "./Data_cleaning/Data/Stata_dta/pce_index.dta", clear
	collapse (first) pce*, by(ym)
	gen y = year(dofm(ym))
	bys y: egen tmp_pce = sum(pce_price_index) 
	gen tmp_pce2 = tmp_pce if y == 2019 
	egen tmp_pce3 = max(tmp_pce2)
	gen pce_price_index_2019 = (tmp_pce / (tmp_pce3)) * 100 
	rename y date_ym
collapse pce_price_index_2019, by(date_ym)
keep if date_ym >=1990 & date_ym <= 2019

tempfile pce_dta
save `pce_dta' 

********************************************************************************
* Main code - agegenderrace

use "./Adjusted_growth/Output/output_counter_White.dta", clear 
append using "./Adjusted_growth/Output/output_counter_Black.dta"
append using "./Adjusted_growth/Output/output_counter_Hispanic.dta"
append using "./Adjusted_growth/Output/output_counter_Other.dta"

gen racegendergroup = 2
replace racegendergroup = 1 if newid < 5

* Pull in single race file and collapse by date_ym to get Table 5
* Pull in single race file and collapse by date_ym, racegendergroup to get group specific percent contributions - Table 6
* Otherwise, you get Table 4
collapse (sum) output*, by(date_ym)

gen output1_seq_pc = (output1_seq_agegenderrace - output0_agegenderrace)/output0_agegenderrace
gen output2_seq_pc = (output2_seq_agegenderrace - output1_seq_agegenderrace)/output0_agegenderrace
gen output3_seq_pc = (output3_seq_agegenderrace - output2_seq_agegenderrace)/output0_agegenderrace
gen output4_seq_pc = (output4_seq_agegenderrace - output3_seq_agegenderrace)/output0_agegenderrace
gen output5_seq_pc = (output5_seq_agegenderrace - output4_seq_agegenderrace)/output0_agegenderrace // With white wage
gen output6_seq_pc = (output6_seq_agegenderrace - output4_seq_agegenderrace)/output0_agegenderrace // With avg wage

gen output_quant_pc = (output4_seq_agegenderrace - output0_agegenderrace)/output0_agegenderrace
gen output_q_e_pc = (output5_seq_agegenderrace - output0_agegenderrace)/output0_agegenderrace


gen output1_pc_contr = ((output1_seq_agegenderrace - output0_agegenderrace)/(output5_seq_agegenderrace - output0_agegenderrace)) * 100
gen output2_pc_contr = ((output2_seq_agegenderrace - output1_seq_agegenderrace)/(output5_seq_agegenderrace - output0_agegenderrace)) * 100
gen output3_pc_contr = ((output3_seq_agegenderrace - output2_seq_agegenderrace)/(output5_seq_agegenderrace - output0_agegenderrace)) * 100
gen output4_pc_contr = ((output4_seq_agegenderrace - output3_seq_agegenderrace)/(output5_seq_agegenderrace - output0_agegenderrace)) * 100
gen output5_pc_contr = ((output5_seq_agegenderrace - output4_seq_agegenderrace)/(output5_seq_agegenderrace - output0_agegenderrace)) * 100

br date_ym output*_pc_contr if date_ym == 1990 | date_ym == 2019

keep *pc date_ym output0_agegenderrace
save "./Adjusted_growth/Output/output_counterfactual_pc.dta", replace
export excel using "./Adjusted_growth/Output/output_counterfactual_pc.xlsx", sheet("Overall") sheetreplace firstrow(varlab)


merge 1:1 date_ym using "../Baseline/Adjusted_growth/Output/nipa_labor_share.dta", nogen
merge 1:1 date_ym using `pce_dta', nogen 


* Scale up to NIPA labor share values 
gen output1_seq_nipa = output1_seq_pc * NIPA_labor_share_T
gen output2_seq_nipa = output2_seq_pc * NIPA_labor_share_T
gen output3_seq_nipa = output3_seq_pc * NIPA_labor_share_T
gen output4_seq_nipa = output4_seq_pc * NIPA_labor_share_T
gen output5_seq_nipa = output5_seq_pc * NIPA_labor_share_T

gen output_quant_nipa = output_quant_pc * NIPA_labor_share_T
gen output_q_e_nipa = output_q_e_pc * NIPA_labor_share_T

* real in 2019 dollars
gen real_NIPA = NIPA_labor_share_T / (pce_price_index_2019/ 100)
gen real_output1_seq_nipa = (output1_seq_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100)
gen real_output2_seq_nipa = (output2_seq_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100) 
gen real_output3_seq_nipa = (output3_seq_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100)
gen real_output4_seq_nipa = (output4_seq_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100)
gen real_output5_seq_nipa = (output5_seq_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100)

gen real_output_quant_nipa = (output_quant_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100)
gen real_output_q_e_nipa = (output_q_e_pc * NIPA_labor_share_T) / (pce_price_index_2019/ 100)


export excel using "./Adjusted_growth/Output/NIPA_counterfactual.xlsx", sheet("Overall") sheetreplace firstrow(varlab)


/*
* Simple counterfactual table to NIPA 

use "./Data_cleaning/Data/Stata_dta/simple_counterfactual.dta", clear 

bys date_ym: egen gdp_all = sum(gdp_group)
gen group_contr = gdp_group_counter - gdp_group
bys date_ym: egen gdp_change_all = sum(group_contr)


gen gdp_pc = (gdp_group_counter - gdp_group)/gdp_group // by group
gen gdp_pc_overall = (gdp_change_all / gdp_all) * 100 
gen gdp_pc_contr = ((gdp_group_counter - gdp_group)/gdp_change_all) * gdp_pc_overall

gen cps_labor_share = gdp_group / gdp_all 

merge m:1 date_ym using "./Adjusted_growth/Output/nipa_labor_share.dta", nogen
merge m:1 date_ym using `pce_dta', nogen

gen nipa_by_race = NIPA_labor_share_T * cps_labor_share
gen gdp_counter_nipa = gdp_pc * nipa_by_race


gen real_nipa_by_race = (NIPA_labor_share_T * cps_labor_share) / (pce_price_index_2019/ 100)
gen real_gdp_counter_nipa = (gdp_pc * nipa_by_race) / (pce_price_index_2019/ 100)
*/