** DEMOGRAPHIC COUNTERFACTUAL EPOP RATES FOR GROUPS

foreach r in "Black" "White" "Other" "Hispanic" {
local title = strproper("`r'")

	foreach g in "$RaceCategories" {
			
		*Get share_base counterfactuals
		use "./Data_cleaning/Data/`g'ahe_White", clear
		drop if missing(`g'group)
		gen base_hrs_all = hr_group
		keep date_ym base_hrs_all newid
		tempfile counter_hrs_all
		save `counter_hrs_all'
		
		*Set counterfactuals as new hrs_all
		use "./Data_cleaning/Data/`g'ahe_`r'", clear
		drop if missing(`g'group)
		
		merge 1:1 date_ym newid using `counter_hrs_all', nogen
		xtset `g'group date_ym
		
		* If group's hrs > white default use group's hrs
		replace base_hrs_all = hr_group if hr_group > base_hrs_all 
		
		gen hrs_all_adj_`g' = base_hrs_all
			
		qui gen year = yofd(dofm(date_ym))

		save "./Shift_share/AGR_race_dta/`g'adj_hr_`r'", replace
	
	}
	
}

