********** Calculate urate, lfrate, and erate by for each group ****************

foreach g in "$categories" {
*foreach g in "agegenderrace" {	
	use "./Data_cleaning/Data/cps_extract_groups.dta", clear
	
	* Keep agegroup 1 if only want to look at 25-34 y/o
	*keep if agegroup == 1
	drop if missing(`g'group) 
	collapse (sum) wgtE wgtU wgtN, by(date_ym `g'group)
	merge m:1 date_ym using "./Data_cleaning/Data/actual_cps.dta", nogen
	xtset `g'group date_ym
	tsfill
	save "./Data_cleaning/Data/`g'wgt.dta", replace
}



foreach g in "$categories" {
*foreach g in "agegenderrace" {	
		use "./Data_cleaning/Data/`g'wgt.dta", clear
		
		rename wgtE wgte
		rename wgtU wgtu
		rename wgtN wgtn
		
		* Total Labor Force for Each Period
		gen lf = wgte + wgtu
		gen lfrate = lf / (wgte + wgtu + wgtn)
		gen double urate = 100 * wgtu / lf
		
		bys date_ym: egen lf_tot = sum(lf)
		gen double share_lf = 100 * lf / lf_tot
		bys date_ym: egen pop_tot = sum(wgte + wgtu + wgtn)
		gen double share_pop = 100 * (wgte + wgtu + wgtn) / pop_tot
		
		gen erate = 100 * wgte / (wgte + wgtu + wgtn)
		xtset `g'group date_ym
		gen year = yofd(dofm(date_ym))
		gen month = month(dofm(date_ym))

		
		gen double tmp 	= (urate*share_lf)/100
		bys date_ym: egen double urate_tot = sum(tmp)
		gen double tmp_lf = (lfrate*share_pop)/ 100
		bys date_ym: egen double lfrate_tot = sum(tmp_lf)
		gen double tmp_epop = (erate*share_pop)/ 100
		bys date_ym: egen double erate_tot = sum(tmp_epop)
		drop tmp*
		
		sort date_ym `g'group
			
		save "./Data_cleaning/Data/`g'share.dta", replace
}		
		
	foreach g in "$RaceCategories" {
		foreach r in u e lf {
			*local r u
			*local g agegenderrace
			use "./Data_cleaning/Data/`g'share.dta", clear
			drop if missing(`g'group)
			
		
			foreach e in "White" "Black" "Hispanic" "Other" {
			*local e White
				preserve
				decode(`g'group), gen(group_str)
				gen race_dummy = . 
				replace race_dummy = 1 if strpos(group_str, `"`e'"')
				
				keep if race_dummy == 1
				
				sort date_ym `g'group
				egen newid = group(`g'group)
				drop group_str race_dummy `g'group
				save "./Data_cleaning/Data/`g'share_`e'.dta", replace
				
				keep date_ym `r'rate newid
				rename `r'rate `r'rate_`g'
			
				reshape wide `r'rate_`g', i(date_ym) j(newid)
	
				tempfile `r'_`g'_`e'
				save ``r'_`g'_`e''
				restore
			
		}
		
	}
}


foreach e in "White" "Black" "Hispanic" "Other" {
	*local e "White"
	use `e_race_`e'', clear
	foreach g in "$RaceCategories" {
	merge 1:1 date_ym using `e_`g'_`e'', nogen
	tsset date_ym
	label var date_ym "Date (Monthly)"
	save "./Data_cleaning/Data/erates_actual_`e'.dta", replace 

	}

	merge 1:1 date_ym using "./Data_cleaning/Data/actual_cps.dta", nogen
	drop urate_cps lfrate_cps

	foreach var of varlist _all {
		label var `var' ""
	}
	save "./Data_cleaning/Data/erates_actual_`e'.dta", replace 

	* Export Employment Population rates by group
	export excel using "./Data_cleaning/Output/erates_actual.xlsx", sheet("`e'") sheetreplace firstrow(varlab)

}

