********************************************************************************
* Program:  Calculates education shares by group and corresponding ahe 
********************************************************************************

foreach g in "$RaceCategories" {
	foreach r in "White" "Black" "Hispanic" "Other" {

		use "./Data_cleaning/Data/cps_earnings.dta", clear
		drop _*
		drop if missing(`g'group)
		
		rename ahe_all ahe_all_og 
	
		
		decode(`g'group), gen(group_str)
		gen race_dummy = . 
		replace race_dummy = 1 if strpos(group_str, `"`r'"')
		keep if race_dummy == 1
		
		sort date_ym `g'group
		egen newid = group(`g'group)
			
	
		gen wgt_HS = ernwgt if educgroup == 1
		gen wgt_AC = ernwgt if educgroup == 2
		gen wgt_BA = ernwgt if educgroup == 3
		gen wgt_MA = ernwgt if educgroup == 4
		
		
		foreach i in "HS" "AC" "BA" "MA" {
			replace wgt_`i' = 0 if missing(wgt_`i') 
		}
		
		preserve
			collapse (sum) wgt_HS wgt_AC wgt_BA wgt_MA, by(date_ym newid)
			xtset newid date_ym
			tsfill
			
			rename wgt_HS wgt_hs
			rename wgt_AC wgt_ac
			rename wgt_BA wgt_ba
			rename wgt_MA wgt_ma  
			
			gen tmp = wgt_hs + wgt_ac + wgt_ba + wgt_ma
			gen share_hs = wgt_hs / tmp
			gen share_ac = wgt_ac / tmp 
			gen share_ba = wgt_ba / tmp
			gen share_ma = wgt_ma / tmp 
			
			drop tmp 
		
			save "./Data_cleaning/Data/`g'_educ_`r'.dta", replace
		restore
		
		gen ern_HS = real_ern_all if educgroup == 1
		gen ern_AC = real_ern_all if educgroup == 2 
		gen ern_BA = real_ern_all if educgroup == 3
		gen ern_MA = real_ern_all if educgroup == 4
		
		gen hr_HS = hr_all if educgroup == 1
		gen hr_AC = hr_all if educgroup == 2
		gen hr_BA = hr_all if educgroup == 3
		gen hr_MA = hr_all if educgroup == 4
		
		collapse (mean) ern_HS ern_AC ern_BA ern_MA hr_HS hr_AC hr_BA hr_MA [aweight = ernwgt], by(date_ym newid)
		
		gen ahe_hs = ern_HS / hr_HS
		gen ahe_ac = ern_AC / hr_AC
		gen ahe_ba = ern_BA / hr_BA
		gen ahe_ma = ern_MA / hr_MA
		
		
		save "./Data_cleaning/Data/`g'_educAHE_`r'.dta", replace
		
		preserve
		keep ahe* date_ym newid
		rename ahe_hs ahe_hs_`g'
		rename ahe_ac ahe_ac_`g'
		rename ahe_ba ahe_ba_`g'
		rename ahe_ma ahe_ma_`g'
		
		reshape wide ahe*, i(date_ym) j(newid)
		export excel using "./Data_cleaning/Output/ahe_educ.xlsx", sheet("`r'") sheetreplace firstrow(varlab)
		restore
		
	}

}
