* Set up ahe and hr by group ***************************************************
	foreach g in "$categories" {
		use "./Data_cleaning/Data/cps_earnings.dta", clear
		drop _*
		
		* Keep agegroup 1 if only want to look at 25-34 y/o
		*keep if agegroup == 1
		* Get shares for hours shift share later
		preserve
			collapse (sum) wgtE wgtU wgtN, by(date_ym `g'group)
			
			rename wgtE wgte
			rename wgtU wgtu
			rename wgtN wgtn
			
			tempfile hr_share_emp
			save `hr_share_emp'
		restore
		
		rename ahe_all ahe_group_og
		rename hr_all hr_group
		collapse (mean) ahe_group_og hr_group real_ern_all [aweight = ernwgt], by(date_ym `g'group)
		gen ahe_group = real_ern_all / hr_group 
		
		merge 1:1 date_ym `g'group using `hr_share_emp', nogen
		xtset `g'group date_ym
		tsfill
		save "./Data_cleaning/Data/`g'ahe.dta", replace
	}



 
* Slice by race ****************************************************************
	foreach g in "$RaceCategories" {
	*foreach g in "agegenderrace" {
		foreach r in "White" "Black" "Hispanic" "Other" {
			use "./Data_cleaning/Data/`g'ahe.dta", clear
			drop if missing(`g'group)
			drop if missing(ahe_group)

			bys date_ym: egen emp_pop = sum(wgte) 
			gen double share_emp = 100 * (wgte) / emp_pop 
			
			decode(`g'group), gen(group_str)
			gen race_dummy = . 
			replace race_dummy = 1 if strpos(group_str, `"`r'"')
			keep if race_dummy == 1
			
			sort date_ym `g'group
			egen newid = group(`g'group)
			
			save "./Data_cleaning/Data/`g'ahe_`r'.dta", replace
			drop group_str race_dummy `g'group wgt* share_emp
			
	
			rename ahe_group ahe_group_`g'
			rename hr_group hr_group_`g'
			rename ahe_group_og ahe_og_`g'
			drop real_ern_all
			reshape wide ahe_group_`g' hr_group_`g' ahe_og_`g', i(date_ym) j(newid)
			
			tempfile `g'_`r'
			save ``g'_`r''
			
		}
	}	

	* merge together
	foreach r in "White" "Black" "Hispanic" "Other" {
	
	use `race_`r'', clear
	
	foreach g in "$RaceCategories" {
		merge 1:1 date_ym using ``g'_`r'', nogen
		tsset date_ym
		label var date_ym "Date (Monthly)"
		save "./Data_cleaning/Data/ahe_group_`r'.dta", replace //shift_share adjusted rates
		
	}
	
	
	use "./Data_cleaning/Data/ahe_group_`r'.dta", clear
		
	preserve
	keep ahe_group* date_ym
	export excel using "./Data_cleaning/Output/all_ahe.xlsx", sheet("`r'") sheetreplace firstrow(varlab)
	restore
	
			
	preserve
	keep hr_group* date_ym
	export excel using "./Data_cleaning/Output/hours.xlsx", sheet("`r'") sheetreplace firstrow(varlab)
	restore
	
	}

