#delimit ;
clear all;
set maxvar 10000;

capture log close;
log using satact_maps_for_replication.log, replace;

graph set window fontface "Times New Roman";

* Use of dataset below is currently restricted and may require contracts
  with the College Board and ACT. Please contact choxby@stanford.edu
  to discuss this issue. Hoxby is glad to provide additional programs
  depending on the data restrictions.;
use data_for_BPEAsatact_maps_incl18yroldpop.dta;

rename fipsstcnty fipsstcntystring;
rename fipscnty fipscntystring;
rename fipsst fipsststring;
destring fipsstcntystring, generate(fipsstcnty);

gen str1 zero="0";
gen STATEFP=int(fipsstcnty/1000);
clonevar fipsst=STATEFP;
gen COUNTYFP=fipsstcnty-(STATEFP*1000);
clonevar fipscnty=COUNTYFP;
tostring STATEFP, replace;
gen length=length(STATEFP);
egen temp=concat(zero STATEFP);
replace STATEFP=temp if length==1;
drop length temp;
tostring COUNTYFP, replace;
gen length=length(COUNTYFP);
egen temp=concat(zero COUNTYFP);
replace COUNTYFP=temp if length==2;
drop temp;
egen temp=concat(zero zero COUNTYFP);
replace COUNTYFP=temp if length==1;
drop length zero temp;

sort STATEFP COUNTYFP;

* Merge with shapefile data.;
merge STATEFP COUNTYFP using usdb_county.dta, update;
tab _merge;
drop if _merge==2;
drop _merge;

* Merge with FIPS data.;
sort fipsst;
merge fipsst using state_names.stabbr.fipsst.reg_div.dta,
  update nokeep keep(fipsdiv fipsreg divname regname stabbr stname);
tab _merge;
drop _merge;

* Make the maps.;
for @ in any pstusincnty_mgte75th pstusincnty_mgte90th:
spmap @ using xy_coor_county,
 id(id) clnumber(10) 
 fcolor(gs15 gs14 gs10 gs9 gs8 gs7 gs6 gs5 gs1 gs0)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) \
graph export satact2008_@_map.svg, replace ;

log close;
clear;
