#delimit ;
clear all;
set maxvar 10000;

capture log close;
log using map_of_presidential_election_2016_for_replication.log, replace;

graph set window fontface "Times New Roman";


* The following data file comes from the MIT Election Data and Science Lab.
  I used version 20191203 of the county-level presidential election data.;

insheet using countypres_2000-2016.csv, comma;
keep if year==2016;
destring candidatevotes, replace force;
rename fips fipsstcnty;
rename state_po stabbr;
rename state statename;
rename county countyname;
label var year "year of Presidential election (always 2016 in this case)";
label var stabbr "postal abbreviation of state";
label var statename "name of state";
label var countyname "name of county";
label var fipsstcnty "fips state code (2 digits) | fips county code (3 digits)";
label var office "office for which the election is held (always President in this case)";
label var totalvotes "total votes cast in the county in 2016";
rename candidate candidatefull;
label var candidatefull "candidate full name";
gen str7 candidate="Trump" if candidatefull=="Donald Trump";
replace candidate="Clinton" if candidatefull=="Hillary Clinton";
replace candidate="Other" if candidatefull=="Other";
rename candidatefull fullname;
rename candidatevotes votes;

reshape i fipsstcnty;
reshape xi year statename stabbr countyname office totalvotes;
reshape j candidate, string;
reshape xij fullname party votes;
reshape wide;
order year statename stabbr countyname office totalvotes;

destring votes*, replace force;
for @ in any Clinton Other Trump: gen double pvotes@=votes@/totalvotes;
for @ in any Clinton Other Trump: label var pvotes@ "pct of votes in county for @ =votes@/totalvotes
destring fipsstcnty, replace;
duplicates report fipsstcnty;
sort fipsstcnty;

* Save the dataset for further use.;
save presidential_election_maps_data.dta, replace;

gen str1 zero="0";
gen STATEFP=int(fipsstcnty/1000);
clonevar fipsst=STATEFP;
gen COUNTYFP=fipsstcnty-(STATEFP*1000);
clonevar fipscnty=COUNTYFP;
tostring STATEFP, replace;
gen length=length(STATEFP);
egen temp=concat(zero STATEFP);
replace STATEFP=temp if length==1;
drop length temp;
tostring COUNTYFP, replace;
gen length=length(COUNTYFP);
egen temp=concat(zero COUNTYFP);
replace COUNTYFP=temp if length==2;
drop temp;
egen temp=concat(zero zero COUNTYFP);
replace COUNTYFP=temp if length==1;
drop length zero temp;

sort STATEFP COUNTYFP;

* Merge with the shapefile data.;
merge STATEFP COUNTYFP using usdb_county.dta, update;
tab _merge;
drop if _merge==2;
drop _merge;

* Merge with FIPS data.;
sort fipsst;
merge fipsst using state_names.stabbr.fipsst.reg_div.dta,
  update nokeep keep(fipsdiv fipsreg divname regname stabbr stname);
tab _merge;
drop _merge;

for @ in any pvotesTrump:
spmap @ using xy_coor_county,
 id(id) clnumber(10) fcolor(gs15 gs14 gs10 gs9 gs8 gs7 gs6 gs5 gs1 gs0)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) \
graph export presidential_election_map_@_for_replication.svg, replace;

log close;
clear;
