#delimit ;
clear all;
set maxvar 10000;

capture log close;
log using climate_map_replication.log, replace;

* Use data that is downloadable from the Climate map website which is
  https://climatecommunication.yale.edu/visualizations-data/ycom-us/ ;

* It is already put in Stata format here but is otherwise unchanged.;
use YCOM_2020_Data.dta;
keep if geotype=="County";
drop geotype;
rename geoid fipsstcnty;
rename geoname countyname;
duplicates report fipsstcnty;
sort fipsstcnty;

* Save the data for further use.;
save climate_opinion_data_for_maps.dta, replace;

graph set window fontface "Times New Roman";

gen str1 zero="0";
gen STATEFP=int(fipsstcnty/1000);
clonevar fipsst=STATEFP;
gen COUNTYFP=fipsstcnty-(STATEFP*1000);
clonevar fipscnty=COUNTYFP;
tostring STATEFP, replace;
gen length=length(STATEFP);
egen temp=concat(zero STATEFP);
replace STATEFP=temp if length==1;
drop length temp;
tostring COUNTYFP, replace;
gen length=length(COUNTYFP);
egen temp=concat(zero COUNTYFP);
replace COUNTYFP=temp if length==2;
drop temp;
egen temp=concat(zero zero COUNTYFP);
replace COUNTYFP=temp if length==1;
drop length zero temp;

sort STATEFP COUNTYFP;

* Merge with shapefile data.;
merge STATEFP COUNTYFP using usdb_county.dta, update;
tab _merge;
drop if _merge==2;
drop _merge;

* Merge with FIPS data.;
sort fipsst;
merge fipsst using state_names.stabbr.fipsst.reg_div.dta,
  update nokeep keep(fipsdiv fipsreg divname regname stabbr stname);
tab _merge;
drop _merge;

* Make the map.;
for @ in any consensus :
spmap @ using xy_coor_county,
 id(id) clnumber(10) fcolor(gs15 gs14 gs10 gs9 gs8 gs7 gs6 gs5 gs1 gs0)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) \
graph export climate_opinion_map_all_us_@_final_bpea.svg, replace;

log close;
clear;

