#delimit ;
clear all;
set maxvar 10000;

capture log close;
log using seda_map_replication.log, replace;

* Use data downloaded from Stanford Education Data Archive website. The data are available in Stata
  format.;
use SEDA_county_long_NAEP_v21.dta;

* Drop unneeded variables.; 
drop totgyb_asn mn_asn sd_asn mn_asn_se sd_asn_se totgyb_blk mn_blk sd_blk mn_blk_se sd_blk_se
  totgyb_fem mn_fem sd_fem mn_fem_se sd_fem_se totgyb_hsp mn_hsp sd_hsp mn_hsp_se sd_hsp_se totgyb_mal
  mn_mal sd_mal mn_mal_se sd_mal_se totgyb_wht mn_wht sd_wht mn_wht_se sd_wht_se mn_wag mn_wag_se
  mn_wbg mn_wbg_se mn_whg mn_whg_se mn_mfg mn_mfg_se ;
* Keep only the year ultimately used.;
drop if year~=2013;

* Reshape the data.;
duplicates report countyid grade year subject;

for @ in any totgyb_all mn_all sd_all mn_all_se sd_all_se:  rename @ela @_ela_ \ rename @math @_math_;
reshape i countyid year;
reshape j grade;
reshape xi countyname fips stateabb;
reshape xij totgyb_all_ela_ mn_all_ela_ sd_all_ela_ mn_all_se_ela_ sd_all_se_ela_ totgyb_all_math_
  mn_all_math_ sd_all_math_ mn_all_se_math_ sd_all_se_math_;
reshape wide;

for @ in any totgyb_all_ela_3 mn_all_ela_3 sd_all_ela_3 mn_all_se_ela_3 sd_all_se_ela_3 totgyb_all_math_3
  mn_all_math_3 sd_all_math_3 mn_all_se_math_3 sd_all_se_math_3 totgyb_all_ela_4 mn_all_ela_4
  sd_all_ela_4 mn_all_se_ela_4 sd_all_se_ela_4 totgyb_all_math_4 mn_all_math_4 sd_all_math_4
  mn_all_se_math_4 sd_all_se_math_4 totgyb_all_ela_5 mn_all_ela_5 sd_all_ela_5 mn_all_se_ela_5
  sd_all_se_ela_5 totgyb_all_math_5 mn_all_math_5 sd_all_math_5 mn_all_se_math_5 sd_all_se_math_5
  totgyb_all_ela_6 mn_all_ela_6 sd_all_ela_6 mn_all_se_ela_6 sd_all_se_ela_6 totgyb_all_math_6
  mn_all_math_6 sd_all_math_6 mn_all_se_math_6 sd_all_se_math_6 totgyb_all_ela_7 mn_all_ela_7
  sd_all_ela_7 mn_all_se_ela_7 sd_all_se_ela_7 totgyb_all_math_7 mn_all_math_7 sd_all_math_7
  mn_all_se_math_7 sd_all_se_math_7 totgyb_all_ela_8 mn_all_ela_8 sd_all_ela_8 mn_all_se_ela_8
  sd_all_se_ela_8 totgyb_all_math_8 mn_all_math_8 sd_all_math_8 mn_all_se_math_8 sd_all_se_math_8:
  rename @ @_;
reshape i countyid;
reshape j year;
reshape xi countyname fips stateabb;
reshape xij totgyb_all_ela_3_ mn_all_ela_3_ sd_all_ela_3_ mn_all_se_ela_3_ sd_all_se_ela_3_
  totgyb_all_math_3_ mn_all_math_3_ sd_all_math_3_ mn_all_se_math_3_ sd_all_se_math_3_ totgyb_all_ela_4_
  mn_all_ela_4_ sd_all_ela_4_ mn_all_se_ela_4_ sd_all_se_ela_4_ totgyb_all_math_4_ mn_all_math_4_
  sd_all_math_4_ mn_all_se_math_4_ sd_all_se_math_4_ totgyb_all_ela_5_ mn_all_ela_5_ sd_all_ela_5_
  mn_all_se_ela_5_ sd_all_se_ela_5_ totgyb_all_math_5_ mn_all_math_5_ sd_all_math_5_ mn_all_se_math_5_
  sd_all_se_math_5_ totgyb_all_ela_6_ mn_all_ela_6_ sd_all_ela_6_ mn_all_se_ela_6_ sd_all_se_ela_6_
  totgyb_all_math_6_ mn_all_math_6_ sd_all_math_6_ mn_all_se_math_6_ sd_all_se_math_6_ totgyb_all_ela_7_
  mn_all_ela_7_ sd_all_ela_7_ mn_all_se_ela_7_ sd_all_se_ela_7_ totgyb_all_math_7_ mn_all_math_7_
  sd_all_math_7_ mn_all_se_math_7_ sd_all_se_math_7_ totgyb_all_ela_8_ mn_all_ela_8_ sd_all_ela_8_
  mn_all_se_ela_8_ sd_all_se_ela_8_ totgyb_all_math_8_ mn_all_math_8_ sd_all_math_8_ mn_all_se_math_8_
  sd_all_se_math_8_;
reshape wide;

* Save the data for further use.;
save seda_based_maps_data.dta, replace;

graph set window fontface "Times New Roman";

* Predict math scores so that Virginia is not empty for grades 5-8. 
  Virginia only has NAEP-scale math scores for grades 3 and 4.  So predict 
  math scores based on Virginia ELA scores.;

for @ in num 3/8: regress mn_all_math_@_2013 mn_all_ela_@_2013 \ predict pmn_all_math_@_2013 ;
for @ in num 3/8: label var pmn_all_math_@_2013 "predict from regress of mn_all_math_@_2013 on mn_all_ela_@_2013)";
for @ in num 3/8: label var mn_all_math_@_2013 "county mean math grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var sd_all_math_@_2013 "county std dev math grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var mn_all_se_math_@_2013 "std err of county mean math grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var sd_all_se_math_@_2013 "std err of county std dev math grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var mn_all_ela_@_2013 "county mean ela grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var sd_all_ela_@_2013 "county std dev ela grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var mn_all_se_ela_@_2013 "std err of county mean ela grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var sd_all_se_ela_@_2013 "std err of county std dev ela grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var totgyb_all_math_@_2013 "county total obs math grd @ in 2013 on NAEP scale";
for @ in num 3/8: label var totgyb_all_ela_@_2013 "county total obs ela grd @ in 2013 on NAEP scale";


* Substitute predicted math scores so that Virginia is not empty for grades 5-8.;
for @ in any 2013:
  replace mn_all_math_3_@=pmn_all_math_3_@ if mn_all_math_3_@==. \
  replace mn_all_math_5_@=pmn_all_math_5_@ if mn_all_math_5_@==. \
  replace mn_all_math_8_@=pmn_all_math_8_@ if mn_all_math_8_@==. ;

rename countyid fipsstcntystring;
destring fipsstcntystring, generate(fipsstcnty);
rename fips fipsststring;

gen str1 zero="0";
gen STATEFP=int(fipsstcnty/1000);
clonevar fipsst=STATEFP;
gen COUNTYFP=fipsstcnty-(STATEFP*1000);
clonevar fipscnty=COUNTYFP;
tostring STATEFP, replace;
gen length=length(STATEFP);
egen temp=concat(zero STATEFP);
replace STATEFP=temp if length==1;
drop length temp;
tostring COUNTYFP, replace;
gen length=length(COUNTYFP);
egen temp=concat(zero COUNTYFP);
replace COUNTYFP=temp if length==2;
drop temp;
egen temp=concat(zero zero COUNTYFP);
replace COUNTYFP=temp if length==1;
drop length zero temp;

sort STATEFP COUNTYFP;

merge STATEFP COUNTYFP using usdb_county.dta, update;
tab _merge;
drop if _merge==2;
drop _merge;

sort fipsst;
merge fipsst using state_names.stabbr.fipsst.reg_div.dta,
  update nokeep keep(fipsdiv fipsreg divname regname stabbr stname);
tab _merge;
drop _merge;

* Create the maps.;

for @ in any 2013 :
spmap mn_all_math_3_@ using xy_coor_county,
 id(id) clnumber(10)
 fcolor(gs15 gs14 gs10 gs9 gs8 gs7 gs6 gs5 gs1 gs0)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) \
graph export SEDA_math_all_us_grd3_@_final_bpea.svg, replace \
spmap mn_all_math_5_@ using xy_coor_county,
 id(id) clnumber(10)
 fcolor(gs15 gs14 gs10 gs9 gs8 gs7 gs6 gs5 gs1 gs0)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) \
graph export SEDA_math_all_us_grd5_@_final_bpea.svg, replace \
spmap mn_all_math_8_@ using xy_coor_county,
 id(id) clnumber(10)
 fcolor(gs15 gs14 gs10 gs9 gs8 gs7 gs6 gs5 gs1 gs0)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) \
graph export SEDA_math_all_us_grd8_@_final_bpea.svg, replace ;

log close;
clear;


