#delimit ;
clear all;
set maxvar 10000;

capture log close;
log using piaac_maps_for_replication.log, replace;

* Data was pasted into Stata editor from the PIAAC local estimates Excel spreadsheet SAE_website_dataset.dcae7f6f.xlsx
  downloaded from the NCES website. It is currently downloadable from https://nces.ed.gov/surveys/piaac/skillsmap/ ;
* NCES often changes its website so if the above link does not work go to nces.ed.gov and follow links through to
  PIAAC files.;
* Drop the variables that we do not need.;
drop pop pop_target male female white black hispanic asian aian nhpi other_race less_hs hs more_hs eng_not_well
  fb_after2010 fb_1990_2009 fb_before1990 fb poverty_100 poverty_150 snap employed unemployed not_in_labor
  occ_manage occ_service occ_sales occ_natural occ_military occ_prod no_insurance lit_p1_ci_l lit_p1_ci_u lit_p1_cv
  lit_p2_ci_l lit_p2_ci_u lit_p2_cv lit_p3_ci_l lit_p3_ci_u lit_p3_cv lit_a_ci_l lit_a_ci_u lit_a_cv num_p1_ci_l
  num_p1_ci_u num_p1_cv num_p2_ci_l num_p2_ci_u num_p2_cv num_p3_ci_l num_p3_ci_u num_p3_cv ;
* Save the data because we are going to need it for the spmap programs.;
save piacc_maps.dta, replace ;

* Make the maps.;

graph set window fontface "Times New Roman";

rename state statename;
rename county countyname;
rename fips_code fipsstcnty;

gen str1 zero="0";
gen STATEFP=int(fipsstcnty/1000);
clonevar fipsst=STATEFP;
gen COUNTYFP=fipsstcnty-(STATEFP*1000);
clonevar fipscnty=COUNTYFP;
tostring STATEFP, replace;
gen length=length(STATEFP);
egen temp=concat(zero STATEFP);
replace STATEFP=temp if length==1;
drop length temp;
tostring COUNTYFP, replace;
gen length=length(COUNTYFP);
egen temp=concat(zero COUNTYFP);
replace COUNTYFP=temp if length==2;
drop temp;
egen temp=concat(zero zero COUNTYFP);
replace COUNTYFP=temp if length==1;
drop length zero temp;

sort STATEFP COUNTYFP;

* Merge with shapefile data;
merge STATEFP COUNTYFP using usdb_county.dta, update;
tab _merge;
drop if _merge==2;
drop _merge;

* Merge with FIPS data for states divisions and regions.;
sort fipsst;
merge fipsst using state_names.stabbr.fipsst.reg_div.dta,
  update nokeep keep(fipsdiv fipsreg divname regname stabbr stname);
tab _merge;
drop _merge;

* National in the Grey color scheme.;

for @ in any num_p3:
spmap @ using xy_coor_county,
 id(id) clmethod(custom) clbreaks(0 .171 .209 .245 .273 .2995 .328 .356 .385 .428 .672)
 fcolor(Greys2)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none)
 polygon(data("xy_coor_state.dta") osize(vvthin) ocolor(black))
 ndo(none) ndsize(none) ;
graph export piaac_map_wlines_numeracy_greys.svg, replace;

* Main Appalachia states' counties in the Grey color scheme.;
* Note that the breaks are the same as in the national map since we are merely focusing in.;

for @ in any num_p3: spmap @ using xy_coor_county if fipsst==1 | fipsst==13 | fipsst==21 | fipsst==39 |
 fipsst==42 | fipsst==47 | fipsst==54, id(id) clmethod(custom)
 clbreaks(0 .171 .209 .245 .273 .2995 .328 .356 .385 .428 .672)
 fcolor(Greys2)
 osize(none none none none none none none none none none)
 ocolor(none none none none none none none none none none) ndo(none) ndsize(none) ;
graph export
 piaac_map_wlines_numeracy_appalachia_main_states_greys.svg, replace;

log close;
clear;
