/*==============================================================================                                                                    
Project: 	Brookings Criminal Justice Symposium	    
			Will Dobbie and Crystal Yang         
			
			This file creates all relevant figures and tables

			First coded: 1/21/2021
			Last updated: 4/26/2021
			
================================================================================*/
/** Paths set in 0_US_PTDetention_RacialGaps_MASTER.do 

clear all
set more off
cap log close
set maxvar 100000

* Local & Network directories
global Brookings  = "SCPS data folder (Encrypted Drive)"
global local_temp = "$Brookings/Temp"
global local_data = "$Brookings/ SCPS data sub-Folder with main dataset"

global dropbox    = "Network directory with public access datasets"
global do_files   = "$dropbox/Do_files"
global results	  = "$dropbox/Results"

global censuskey  = "739fc5d493d01589c1bdb7a2fd30a2b308b3e893"

cd "$dropbox"
*/


*Install necessary packages
// ssc install egenmore
// ssc install grstyle, replace

*Set graph settings
graph set window fontface "Ebrima"
set scheme s2mono
grstyle init
grstyle color background white

*********************
**Figure 2: Panel A** 
*********************
use "$local_temp/DetRate_TOTAL_pweight.dta", clear

*Create and export graphs 
line Det_Rate Det_Rate_Black Det_Rate_HisWhite Det_Rate_NonHisWhite YEAR, ///
lcolor(black black black black) ///
lpattern(solid dash shortdash_dot longdash_dot) ///
xtitle("Year") ///
ylabel(,nogrid) ///
ytitle("Detention Rate (%)"" ") ///
xsc(titlegap(1))
graph export "$results/fig2_a.pdf", replace 

*********************
**Figure 2: Panel B**
*********************
use "$dropbox/Data/Economic Indicators/FRED_EmpPop_1990_2009_CLEAN.dta", clear

*Create and export line graph
line EmpPop_All EmpPop_Black EmpPop_Hispanic EmpPop_White Date, ///
lcolor(black black black black) ///
lpattern(solid dash shortdash_dot longdash_dot) ///
xlabel(10958 "1990" 12784 "1995" 14610 "2000" 16437 "2005" 18263 "2010") ///
xtitle("Year") ///
ylabel(,nogrid) ///
ytitle("Employment to" "Population Ratio (%)") ///
xsc(titlegap(1))
graph export "$results/fig2_b.pdf", replace 

*********************
**Figure 2: Panel C** 
*********************
use "$dropbox/Data/Census/CPS_PctPov_1990_2019_CLEAN.dta", clear

*Create and export graphs 
line All_Ages_PctPov_All All_Ages_PctPov_Black All_Ages_PctPov_Hispanic All_Ages_PctPov_NonHisWhite Year if Year <= 2010 & Year >= 1990, ///
lcolor(black black black black) ///
lpattern(solid dash shortdash_dot longdash_dot) ///
ylabel(,nogrid) ///
xtitle("Year") ///
ytitle("Poverty Rate (%)"" ") ///
xsc(titlegap(1))
graph export "$results/fig2_c.pdf", replace 

************
**Figure 3**
************
use "$local_temp/All_Vars_Merged_Wide.dta", clear 

*Poverty  - 25 to 44

*Get y-axis points 
*Minimum
local min_y = 100
foreach x in All Black NonHisWhite Hispanic {
	sum PctPov_`x'_25_44_DIF if !mi(Det_Rate_Dif_2000_2009), d
	if `r(min)' <= `min_y' {
		local min_y = `r(min)'
	}
	else {
		local min_y = `min_y'
	}
}
local min_y_adj = round(`min_y', 5)
if `min_y_adj' > `min_y' {
	local min_y_adj = `min_y_adj' - 5 
}
else {
	local min_y_adj = `min_y_adj'
}

*Maximum
local max_y = 0
foreach x in All Black NonHisWhite Hispanic {
	sum PctPov_`x'_25_44_DIF if !mi(Det_Rate_Dif_2000_2009), d
	if `r(max)' >= `max_y' {
		local max_y = `r(max)'
	}
	else {
		local max_y = `max_y'
	}
}
local max_y_adj = round(`max_y', 5)
if `max_y_adj' < `max_y' {
	local max_y_adj = `max_y_adj' + 5 
}
else {
	local max_y_adj = `max_y_adj'
}

*Get bounds for x-axis
sum Det_Rate_Dif_2000_2009
local min_x = round(floor(r(min)), 5)- 5
local max_x = round(ceil(r(max)), 5) +10

*Create figures
foreach x in All Black NonHisWhite Hispanic {
	
	*Beta
	reg PctPov_`x'_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_`x'_25_44_2000] 
	local beta = string(_b[Det_Rate_Dif_2000_2009],"%9.2f")
	
	*r 
	corr PctPov_`x'_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_`x'_25_44_2000] 
	local rho = string(`r(rho)',"%9.2f")
	
	*Create markers for beta and rho
	local x_range 		= `max_x' - `min_x'
	local x_unit	 	= `x_range' / 6
	local y_range 		= `max_y_adj' - `min_y_adj'
	local y_unit		= `y_range' / 6
	local rho_y 		= `min_y_adj' + (`y_unit' * 5.5)

	if strpos("`rho'", "-") > 0 {
		local rho_x 	= `max_x' - `x_unit'
	}
	else {
		local rho_x 	= `min_x' + `x_unit'
	}

	*Extract varlabel for graph title
	local y_varlabel: var label PctPov_`x'_25_44_DIF
	local x_varlabel: var label Det_Rate_Dif_2000_2009
	
	*Create and export graph
	twoway (scatter PctPov_`x'_25_44_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_`x'_25_44_2000], ///
	text(`rho_y' `rho_x' "r = `rho'", place(n) size(large)) ///
	text(`rho_y' `rho_x' "{&beta} = `beta'", place(s) size(large)) ///
	xtitle("`x_varlabel'") ///
	ytitle("{&Delta} Below Poverty Line 2000-2010" "`y_varlabel'") ///
	ysc(titlegap(2)) ///
	xsc(titlegap(1)) ///
	mcolor(black) ///
	msymbol(Oh) ///
	xlabel(`min_x' (10) `max_x') /// 
	ylabel(`min_y_adj' (5) `max_y_adj', nogrid) ///
	lcolor(black)) ///
	(lfit PctPov_`x'_25_44_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_`x'_25_44_2000], ///
	lcolor(black) lp(l))(scatter PctPov_`x'_25_44_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009), ms(i) mlabcolor(black) mlabel(Det_Rate_Dif_Labels)) , legend(off)
	
	*Graph titles 
	if "`x'" == "All" {
		local panel = "a"
	}
	else if "`x'" == "Black" {
		local panel = "b"
	}
	else if "`x'" == "Hispanic" {
		local panel = "c"
	}
	else if "`x'" == "NonHisWhite" {
		local panel = "d"
	}
	
	graph export "$results/fig3_`panel'.pdf", replace 
}

************
**Figure 4**
************
*Employment - 16 to 64

*Get y-axis points 
*Minimum
local min_y = 100
foreach x in Black NonHisWhite Hispanic {
	sum Emp_`x'_16_64_DIF if !mi(Det_Rate_Dif_2000_2009), d
	if `r(min)' <= `min_y' {
		local min_y = `r(min)'
	}
	else {
		local min_y = `min_y'
	}
}
local min_y_adj = round(`min_y', 5)
if `min_y_adj' > `min_y' {
	local min_y_adj = `min_y_adj' - 5 
}
else {
	local min_y_adj = `min_y_adj'
}

*Maximum
local max_y = 0
foreach x in Black NonHisWhite Hispanic  {
	sum Emp_`x'_16_64_DIF if !mi(Det_Rate_Dif_2000_2009), d
	if `r(max)' >= `max_y' {
		local max_y = `r(max)'
	}
	else {
		local max_y = `max_y'
	}
}
local max_y_adj = round(`max_y', 5)
if `max_y_adj' < `max_y' {
	local max_y_adj = `max_y_adj' + 5 
}
else {
	local max_y_adj = `max_y_adj'
}

*Get bounds for x-axis
sum Det_Rate_Dif_2000_2009
local min_x = round(floor(r(min)), 5)- 5
local max_x = round(ceil(r(max)), 5) +10
	
*Create figures 
foreach x in Black NonHisWhite Hispanic {
		
	*Beta
	reg Emp_`x'_16_64_DIF Det_Rate_Dif_2000_2009 [aweight = pop_`x'_16_64_2000] 
	local beta = string(_b[Det_Rate_Dif_2000_2009], "%9.2f")
	
	*r
	corr Emp_`x'_16_64_DIF Det_Rate_Dif_2000_2009 [aweight = pop_`x'_16_64_2000] 
	local rho = string(`r(rho)', "%9.2f")
	
	*Create markers for beta and rho
	local x_range 		= `max_x' - `min_x'
	local x_unit	 	= `x_range' / 6
	local y_range 		= `max_y_adj' - `min_y_adj'
	local y_unit		= `y_range' / 6
	local rho_y 	= `min_y_adj' + (`y_unit' * 5.5)

	if strpos("`rho'", "-") > 0 {
		local rho_x 	= `max_x' - `x_unit'
	}
	else {
		local rho_x 	= `min_x' + `x_unit'
	}
	
	*Extract varlabel for graph title
	local y_varlabel: var label Emp_`x'_16_64_DIF
	local x_varlabel: var label Det_Rate_Dif_2000_2009
		
	*Create and export graph
	twoway (scatter Emp_`x'_16_64_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_`x'_16_64_2000], ///
	text(`rho_y' `rho_x' "r = `rho'", place(n) size(large)) ///
	text(`rho_y' `rho_x' "{&beta} = `beta'", place(s) size(large)) ///
	xtitle("`x_varlabel'") ///
	ytitle("{&Delta} Employment Rate 2000-2010" "`y_varlabel'") ///
	ysc(titlegap(2)) ///
	xsc(titlegap(1)) ///
	mcolor(black) ///
	msymbol(Oh) ///
	xlabel(`min_x' (10) `max_x') /// 
	ylabel(`min_y_adj' (5) `max_y_adj', nogrid) ///
	lcolor(black)) ///
	(lfit Emp_`x'_16_64_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_`x'_16_64_2000], ///
	lcolor(black) lp(l))(scatter Emp_`x'_16_64_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009), ///
	ms(i) mlabcolor(black) mlabel(Det_Rate_Dif_Labels)), legend(off)
	
	*Graph titles 
	if "`x'" == "Black" {
		local panel = "b"
	}
	else if "`x'" == "Hispanic" {
		local panel = "c"
	}
	else if "`x'" == "NonHisWhite" {
		local panel = "d"
	}
	
	graph export "$results/fig4_`panel'.pdf", replace 
}

*Employment 25 to 44
*Beta
reg Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000] 
local beta = string(_b[Det_Rate_Dif_2000_2009], "%9.2f")

*r
corr Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000] 
local rho = string(`r(rho)', "%9.2f")

*Extract varlabel for graph title
local y_varlabel: var label Emp_All_25_44_DIF
local x_varlabel: var label Det_Rate_Dif_2000_2009

*Get bounds for x-axis
sum Det_Rate_Dif_2000_2009
local min_x = round(floor(r(min)), 5) - 5
local max_x = round(ceil(r(max)), 5) +10

*Create markers for beta and rho
local x_range 		= `max_x' - `min_x'
local x_unit	 	= `x_range' / 6
local y_range 		= `max_y_adj' - `min_y_adj'
local y_unit		= `y_range' / 6
local rho_y 	= `min_y_adj' + (`y_unit' * 5.5)


if strpos("`rho'", "-") > 0 {
	local rho_x 	= `max_x' - `x_unit'
}
else {
	local rho_x 	= `min_x' + `x_unit'
}

*Create and export graph
twoway (scatter Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_All_25_44_2000], ///
text(`rho_y' `rho_x' "r = `rho'", place(n) size(large)) ///
text(`rho_y' `rho_x' "{&beta} = `beta'", place(s) size(large)) ///
xtitle("`x_varlabel'") ///
ytitle("{&Delta} Employment Rate 2000-2010" "`y_varlabel'") ///
ysc(titlegap(2)) ///
xsc(titlegap(1)) ///
mcolor(black) ///
msymbol(Oh) ///
xlabel(`min_x' (10) `max_x') /// 
ylabel(`min_y_adj' (5) `max_y_adj', nogrid) /// Emp_All_25_44_DIF max and min fit within these bounds established for last figures
lcolor(black)) ///
(lfit Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_All_25_44_2000], ///
lcolor(black) lp(l))(scatter Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 if !mi(Det_Rate_Dif_2000_2009), ms(i) mlabcolor(black) mlabel(Det_Rate_Dif_Labels)), legend(off)

graph export "$results/fig4_a.pdf", replace 

***************
**Figures 5-6**
***************
*Intergenerational Mobility 

*Label two lowest and two highest counties in terms of 1990 detention rate
gsort -Det_Rate1990
egen Rank_Det_Rate1990 = rank(Det_Rate1990)
sum Rank_Det_Rate1990
local max_rank = `r(max)'
local min_rank = `r(min)'
gen Det_Rate1990_Labels = CountyName if Rank_Det_Rate1990 == `max_rank' | Rank_Det_Rate1990 == `max_rank' - 1
replace Det_Rate1990_Labels = CountyName if Rank_Det_Rate1990 == `min_rank' | Rank_Det_Rate1990 == `min_rank' + 1 

*Get bounds for x-axis
sum Det_Rate1990
local min_x = round(floor(r(min)), 5)- 5
local max_x = round(ceil(r(max)), 5) + 10 
		
*25th and 7th percentile 
foreach pctile in 25 75 {
	*Get y-axis points 
	*Minimum
	local min_y = 100
	foreach x in All Black NonHisWhite Hispanic  {
		sum interMob_`x'_p`pctile' if !mi(Det_Rate1990), d
		if `r(min)' <= `min_y' {
			local min_y = `r(min)'
		}
		else {
			local min_y = `min_y'
		}
	}
	local min_y_adj = round(`min_y', 5)
	if `min_y_adj' > `min_y' {
		local min_y_adj = `min_y_adj' - 5 
	}
	else {
		local min_y_adj = `min_y_adj'
	}

	*Maximum
	local max_y = 0
	foreach x in All Black NonHisWhite Hispanic {
		sum interMob_`x'_p`pctile' if !mi(Det_Rate1990), d
		if `r(max)' >= `max_y' {
			local max_y = `r(max)'
		}
		else {
			local max_y = `max_y'
		}
	}
	local max_y_adj = round(`max_y', 5)
	if `max_y_adj' < `max_y' {
		local max_y_adj = `max_y_adj' + 5 
	}
	else {
		local max_y_adj = `max_y_adj'
	}

	*Create figures
	foreach x in All Black Hispanic NonHisWhite {
			
		*Beta
		reg interMob_`x'_p`pctile' Det_Rate1990 [aweight = pop_`x'_2000] 
		local beta = string(_b[Det_Rate1990], "%9.2f") 
		
		*r 
		corr interMob_`x'_p`pctile' Det_Rate1990 [aweight = pop_`x'_2000] 
		local rho = string(`r(rho)', "%9.2f")
		
		*Extract varlabel for graph title
		local y_varlabel: var label interMob_`x'_p25
		local x_varlabel: var label Det_Rate1990
		
		*Create markers for beta and rho
		local x_range 		= `max_x' - `min_x'
		local x_unit	 	= `x_range' / 6
		local y_range 		= `max_y_adj' - `min_y_adj'
		local y_unit		= `y_range' / 6
		local rho_y 		= `min_y_adj' + (`y_unit' * 5.5)

		if strpos("`rho'", "-") > 0 {
			local rho_x 	= `max_x' - `x_unit'
		}
		else {
			local rho_x 	= `min_x' + `x_unit'
		}
			
		*Create and export graph
		twoway (scatter interMob_`x'_p`pctile' Det_Rate1990 if !mi(Det_Rate1990) [aweight = pop_`x'_2000], ///
		text(`rho_y' `rho_x' "r = `rho'", place(n) size(large)) ///
		text(`rho_y' `rho_x' "{&beta} = `beta'", place(s) size(large)) ///
		xtitle("`x_varlabel'") ///
		ytitle("Mobility at the `pctile'th Parental" "Income Percentile `y_varlabel'") ///
		ysc(titlegap(2)) ///
		xsc(titlegap(1)) ///
		mcolor(black) ///
		msymbol(Oh) ///
		xlabel(`min_x' (10) `max_x') ///
		ylabel(`min_y_adj' (5) `max_y_adj', nogrid) ///
		lcolor(black)) ///
		(lfit interMob_`x'_p`pctile' Det_Rate1990 if !mi(Det_Rate1990) [aweight = pop_`x'_2000], ///
		lcolor(black) lp(l))(scatter interMob_`x'_p`pctile' Det_Rate1990 if !mi(Det_Rate1990), ms(i) mlabcolor(black) mlabel(Det_Rate1990_Labels)), legend(off)
		
		*Graph titles 
		if "`x'" == "All" {
			local panel = "a"
		}
		else if "`x'" == "Black" {
			local panel = "b"
		}
		else if "`x'" == "Hispanic" {
			local panel = "c"
		}
		else if "`x'" == "NonHisWhite" {
			local panel = "d"
		}
		
		if 	"`pctile'" == "25" {
			local fig = "fig5"
		}
		else if "`pctile'" == "75" {
			local fig = "fig6"
		}
	
		graph export "$results/`fig'_`panel'.pdf", replace 
	}
}

***********
**Table 2**
***********
use "$local_temp/All_Vars_Merged_Wide.dta", clear 

*Rename variables to accomodate local max size for LaTex output
rename Det_Rate_Dif_2000_2009 	drd0009
rename Det_Rate1990 			dr1990 

*Regression covariates
local x_vars_emp "crime_total mi_crime_total crime_violent frac_coll_plus2000 LFP_Female_2000 Log_pop_All_2000 hhinc_mean2000 singleparent_share2000 cs_born_foreign eitc_exposure share_Female_2000 Unemp_All_16Over_2000"
local x_vars_pov "crime_total mi_crime_total crime_violent frac_coll_plus2000 LFP_Female_2000 Log_pop_All_2000 hhinc_mean2000 singleparent_share2000 cs_born_foreign eitc_exposure share_Female_2000 Unemp_All_16Over_2000" 
local x_vars_IM "crime_total mi_crime_total crime_violent gini99 dropout_r mi_dropout_r scap_ski90pcm  mi_scap_ski90pcm cs_fam_wkidsinglemom cs_race_bla"

**Run regressions and store results**
*Poverty regressions - controls
foreach x in All Black Hispanic NonHisWhite {
	reg PctPov_`x'_25_44_DIF drd0009 `x_vars_pov' [aweight = pop_`x'_25_44_2000], robust
	
	local cons_pov_`x'c   		= string(_b[_cons], "%9.3f")
	local SEcons_pov_`x'c 		= string(_se[_cons], "%9.3f")
	local B_pov_drd0009_`x'c 	= string(_b[drd0009],"%9.3f")
	local SE_pov_drd0009_`x'c	= string(_se[drd0009], "%9.3f")
	local N_pov_`x'c 			= e(N)
	local r2_pov_`x'c 			= string(e(r2), "%9.3f")
	
}

*Poverty regressions - no controls
foreach x in All Black Hispanic NonHisWhite {
	reg PctPov_`x'_25_44_DIF drd0009 [aweight = pop_`x'_25_44_2000], robust
	
	local cons_pov_`x'nc    	= string(_b[_cons], "%9.3f")
	local SEcons_pov_`x'nc  	= string(_se[_cons], "%9.3f")
	local B_pov_drd0009_`x'nc	= string(_b[drd0009],"%9.3f")
	local SE_pov_drd0009_`x'nc 	= string(_se[drd0009], "%9.3f")
	local N_pov_`x'nc 			= e(N)
	local r2_pov_`x'nc 			= string(e(r2), "%9.3f")
}

*Employment regressions - controls
reg Emp_All_25_44_DIF drd0009 `x_vars_emp' [aweight = pop_All_25_44_2000] , robust

local cons_emp_Allc 	 	= string(_b[_cons], "%9.3f")
local SEcons_emp_Allc	 	= string(_se[_cons], "%9.3f")
local B_emp_drd0009_Allc	= string(_b[drd0009],"%9.3f")
local SE_emp_drd0009_Allc	= string(_se[drd0009], "%9.3f")
local N_emp_Allc			= e(N)
local r2_emp_Allc			= string(e(r2), "%9.3f")


foreach x in Black Hispanic NonHisWhite {
	reg Emp_`x'_16_64_DIF drd0009 `x_vars_emp' [aweight = pop_`x'_16_64_2000], robust
	
	local cons_emp_`x'c			= string(_b[_cons], "%9.3f")
	local SEcons_emp_`x'c 		= string(_se[_cons], "%9.3f")
	local B_emp_drd0009_`x'c 	= string(_b[drd0009],"%9.3f")
	local SE_emp_drd0009_`x'c	= string(_se[drd0009], "%9.3f")
	local N_emp_`x'c			= e(N)
	local r2_emp_`x'c 			= string(e(r2), "%9.3f")
}

*Employment regressions - no controls
reg Emp_All_25_44_DIF drd0009 [aweight = pop_All_25_44_2000] , robust

local cons_emp_Allnc 	 	= string(_b[_cons], "%9.3f")
local SEcons_emp_Allnc	 	= string(_se[_cons], "%9.3f")
local B_emp_drd0009_Allnc	= string(_b[drd0009],"%9.3f")
local SE_emp_drd0009_Allnc	= string(_se[drd0009], "%9.3f")
local N_emp_Allnc			= e(N)
local r2_emp_Allnc			= string(e(r2), "%9.3f")
	
foreach x in Black Hispanic NonHisWhite {
	reg Emp_`x'_16_64_DIF drd0009 [aweight = pop_`x'_16_64_2000], robust
	
	local cons_emp_`x'nc		= string(_b[_cons], "%9.3f")
	local SEcons_emp_`x'nc 		= string(_se[_cons], "%9.3f")
	local B_emp_drd0009_`x'nc 	= string(_b[drd0009],"%9.3f")
	local SE_emp_drd0009_`x'nc	= string(_se[drd0009], "%9.3f")
	local N_emp_`x'nc			= e(N)
	local r2_emp_`x'nc 			= string(e(r2), "%9.3f")
}

*Intergenerational Mobility
foreach pctile in 25 75 {
	*Intergenerational Mobility regressions - controls
	foreach x in All Black Hispanic NonHisWhite {
		reg interMob_`x'_p`pctile' dr1990 `x_vars_IM' [aweight = pop_`x'_2000], robust 
		
		local cons_IM_`x'`pctile'c 		= string(_b[_cons], "%9.3f")
		local SEcons_IM_`x'`pctile'c	= string(_se[_cons], "%9.3f")
		local B_IM_dr1990_`x'`pctile'c 	= string(_b[dr1990],"%9.3f")
		local SE_IM_dr1990_`x'`pctile'c = string(_se[dr1990], "%9.3f")
		local N_IM_`x'`pctile'c 		= e(N)
		local r2_IM_`x'`pctile'c 		= string(e(r2), "%9.3f")	
	}

	*Intergenerational Mobility regressions - no controls
	foreach x in All Black Hispanic NonHisWhite {
		reg interMob_`x'_p`pctile' dr1990 [aweight = pop_`x'_2000], robust 
		
		local cons_IM_`x'`pctile'nc 		= string(_b[_cons], "%9.3f")
		local SEcons_IM_`x'`pctile'nc 		= string(_se[_cons], "%9.3f")
		local B_IM_dr1990_`x'`pctile'nc		= string(_b[dr1990],"%9.3f")
		local SE_IM_dr1990_`x'`pctile'nc	= string(_se[dr1990], "%9.3f")
		local N_IM_`x'`pctile'nc			= e(N)
		local r2_IM_`x'`pctile'c			= string(e(r2), "%9.3f")
	}
}


*********************
**Appendix Table A1**
*********************
use "$local_temp/D1_Clean_Prepped.dta", clear 

*Svyset for weighted specific statistics
svyset ID [pweight = TOTALWT]

*Summarize variables
foreach var in NonHisWhite HisWhite Black Race_Other age_24U age_25_44 ///
age_45_64 age_65over MALE violent property drug pubOrder PRIARR PRIFARR ///
PRICONV PRIFCONV PRIORFTA {
	foreach x in All Detained Release {
		svy: mean `var' if `x' == 1 
		mat b = e(b)
		local `var'_`x'_PWEIGHT = b[1,1] 
		local `var'_`x'_PWEIGHT = string(``var'_`x'_PWEIGHT',"%4.3f") 
	}
}

*Conduct T-tests of weighted means
foreach var in NonHisWhite HisWhite Black Race_Other age_24U age_25_44 ///
age_45_64 age_65over MALE violent property drug pubOrder PRIARR PRIFARR ///
PRICONV PRIFCONV PRIORFTA {
	di "`var'"
	svy: reg `var' Release
}

*Create observation counts for all populated variables 
sum All if Release == 1
local totalObs_Release = r(N)
sum All if Detained == 1
local totalObs_Detained = r(N)
local totalObs = `totalObs_Release' + `totalObs_Detained'
local totalObs = string(`totalObs', "%8.0fc")
local totalObs_Detained = string(`totalObs_Detained', "%8.0fc")
local totalObs_Release  = string(`totalObs_Release', "%8.0fc")

*********************
**Appendix Table A2**
*********************
use "$local_temp/All_Vars_Merged_Wide.dta", clear

*Panel A statistics - not weighted
foreach var in Det_Rate_Dif_2000_2009 Det_Rate1990 Det_Rate2000 Det_Rate2009 {
	sum `var', d 
	local m`var'_nWT 	= string(`r(mean)', "%3.2f")
	local N`var'_nWT	= string(`r(N)', "%10.0fc")
	local sd`var'_nWT	= string(`r(sd)', "%3.2f")
}

*Panel A statistics - weighted; Census population weights
foreach var in Det_Rate_Dif_2000_2009 Det_Rate1990 Det_Rate2000 Det_Rate2009 {
	sum `var' [aweight = pop_All_2000] , d 
	local m`var'_WT 	= string(`r(mean)', "%3.2f")
	local N`var'_WT	 	= string(`r(N)', "%10.0fc")
	local sd`var'_WT	= string(`r(sd)', "%3.2f")
}

*Panel B statistics - weighted
foreach x in All Black NonHisWhite Hispanic {
	sum PctPov_`x'_25_44_DIF if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_`x'_25_44_2000], d
	local mPov_`x'_25_44_DIF_WT   = string(`r(mean)', "%3.2f")
	local NPov_`x'_25_44_DIF_WT	  = string(`r(N)', "%10.0fc")
	local sdPov_`x'_25_44_DIF_WT  = string(`r(sd)', "%3.2f")
}

*Panel B statistics - not weighted
foreach x in All Black NonHisWhite Hispanic {
	sum PctPov_`x'_25_44_DIF if !mi(Det_Rate_Dif_2000_2009), d
	local mPov_`x'_25_44_DIF_nWT  	   = string(`r(mean)', "%3.2f")
	local NPov_`x'_25_44_DIF_nWT	   = string(`r(N)', "%10.0fc")
	local sdPov_`x'_25_44_DIF_nWT 	   = string(`r(sd)', "%3.2f")
}

*Panel C statistics - weighted
sum Emp_All_25_44_DIF if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_All_25_44_2000], d 
local mEmp_All_25_44_DIF_WT		= string(`r(mean)', "%3.2f")
local NEmp_All_25_44_DIF_WT		= string(`r(N)', "%10.0fc")
local sdEmp_All_25_44_DIF_WT	= string(`r(sd)', "%3.2f")

foreach x in Black NonHisWhite Hispanic {
	sum Emp_`x'_16_64_DIF if !mi(Det_Rate_Dif_2000_2009) [aweight = pop_`x'_16_64_2000], d
	local mEmp_`x'_16_64_DIF_WT		= string(`r(mean)', "%3.2f")
	local NEmp_`x'_16_64_DIF_WT		= string(`r(N)', "%10.0fc")
	local sdEmp_`x'_16_64_DIF_WT	= string(`r(sd)', "%3.2f")
}

*Panel C statistics - not weighted
sum Emp_All_25_44_DIF if !mi(Det_Rate_Dif_2000_2009), d 
local mEmp_All_25_44_DIF_nWT	= string(`r(mean)', "%3.2f")
local NEmp_All_25_44_DIF_nWT	= string(`r(N)', "%10.0fc")
local sdEmp_All_25_44_DIF_nWT	= string(`r(sd)', "%3.2f")

foreach x in Black NonHisWhite Hispanic {
	sum Emp_`x'_16_64_DIF if !mi(Det_Rate_Dif_2000_2009), d
	local mEmp_`x'_16_64_DIF_nWT	= string(`r(mean)', "%3.2f")
	local NEmp_`x'_16_64_DIF_nWT	= string(`r(N)', "%10.0fc")
	local sdEmp_`x'_16_64_DIF_nWT	= string(`r(sd)', "%3.2f")
}

foreach pctile in 25 75 {
	*Panel D / E - weighted
	foreach x in All Black Hispanic NonHisWhite {
		sum interMob_`x'_p`pctile' if !mi(Det_Rate1990) [aweight = pop_`x'_2000], d
		local minterMob_`x'_p`pctile'_WT 	= string(`r(mean)', "%3.2f")
		local NinterMob_`x'_p`pctile'_WT	= string(`r(N)', "%10.0fc")
		local sdinterMob_`x'_p`pctile'_WT	= string(`r(sd)', "%3.2f")
	}

	*Panel D / E - not weighted
	foreach x in All Black Hispanic NonHisWhite {
		sum interMob_`x'_p`pctile' if !mi(Det_Rate1990), d
		local minterMob_`x'_p`pctile'_nWT 	= string(`r(mean)', "%3.2f")
		local NinterMob_`x'_p`pctile'_nWT	= string(`r(N)', "%10.0fc")
		local sdinterMob_`x'_p`pctile'_nWT	= string(`r(sd)', "%3.2f")
	}
}



