/*==============================================================================                                                                   
Project: 	Brookings Criminal Justice Symposium	    
			Will Dobbie and Crystal Yang         
			
			This file runs all relevant files needed to create 
			scatter plots, longitudinal figures, and tables of the pre-trial
			detention rates and racial gaps within selected US counties.
			
			First coded: 1/21/2021
			Last updated: 4/26/2021
			
================================================================================*/

clear all
set more off
cap log close
set maxvar 100000

* Local & Network directories
global Brookings  = "SCPS data folder (Encrypted Drive)"
global local_temp = "$Brookings/Temp"
global local_data = "$Brookings/ SCPS data sub-Folder with main dataset"

global dropbox    = "Network directory with public access datasets"
global do_files   = "$dropbox/Do_files"
global results	  = "$dropbox/Results"

global censuskey  = "739fc5d493d01589c1bdb7a2fd30a2b308b3e893"

local date : di %tdDNCY daily("$S_DATE", "DMY")
log using "$do_files/master_`date'.log", replace

cd "$dropbox"

**************************
** Clean and Import Data**
**************************
do "$do_files/1_cr_data_brookings.do" 

***************************************
** Run Analyses (Tables and Figures) **
***************************************
do "$do_files/2_analysis_brookings.do"

*********************************************
** Run Simulations for Policy Implications **
*********************************************
do "$do_files/3_simulations_brookings.do"

cap log close















