/*==============================================================================                                                                   
Project: 	Brookings Criminal Justice Symposium	    
			Will Dobbie and Crystal Yang         
			
			This file calculates various policy counterfactuals for in-text 
			estimates ("policy implications")
			
			First coded: 1/21/2021
			Last updated: 4/26/2021 
			
================================================================================*/

/** Paths set in 0_US_PTDetention_RacialGaps_MASTER.do 

clear all
set more off
cap log close
set maxvar 100000

* Local & Network directories
global Brookings  = "SCPS data folder (Encrypted Drive)"
global local_temp = "$Brookings/Temp"
global local_data = "$Brookings/ SCPS data sub-Folder with main dataset"

global dropbox    = "Network directory with public access datasets"
global do_files   = "$dropbox/Do_files"
global results	  = "$dropbox/Results"

global censuskey  = "739fc5d493d01589c1bdb7a2fd30a2b308b3e893"

cd "$dropbox"
*/


***************************************************
***** IN TEXT CALCULATIONS: POV, EMP, AND IM ******
***************************************************

use "$local_temp/All_Vars_Merged_Wide.dta", clear

*Regression covariates
local x_vars_emp "crime_total mi_crime_total crime_violent frac_coll_plus2000 LFP_Female_2000 Log_pop_All_2000 hhinc_mean2000 singleparent_share2000 cs_born_foreign eitc_exposure share_Female_2000 Unemp_All_16Over_2000"
local x_vars_pov "crime_total mi_crime_total crime_violent frac_coll_plus2000 LFP_Female_2000 Log_pop_All_2000 hhinc_mean2000 singleparent_share2000 cs_born_foreign eitc_exposure share_Female_2000 Unemp_All_16Over_2000" 
local x_vars_IM "crime_total mi_crime_total crime_violent gini99 dropout_r mi_dropout_r scap_ski90pcm  mi_scap_ski90pcm cs_fam_wkidsinglemom cs_race_bla"

*poverty rate changes for 2 highest and 2 lowest detention change counties
foreach local in "Wayne, MI" "Franklin, OH" "Broward, FL" "Miami-Dade, FL" {
sum PctPov_All_25_44_DIF if CountyName == "`local'"
di "Change in 25 to 44 Poverty Rate in `local': `r(mean)'"
}

*employment rate changes for 2 highest and 2 lowest detention change counties
foreach local in "Wayne, MI" "Franklin, OH" "Broward, FL" "Miami-Dade, FL" {
sum Emp_All_25_44_DIF if CountyName == "`local'"
di "Change in 25 to 44 Employment Rate in `local': `r(mean)'"
}

*IM for 1990 detention counties
foreach local in "Fulton, GA" "Suffolk, MA" {
sum interMob_Black_p25 if CountyName == "`local'"
di "IM p25 for Black Children in `local': `r(mean)'"
}

*detention rate changes for 2 highest and 2 lowest detention change counties
foreach local in "Wayne, MI" "Franklin, OH" "Broward, FL" "Miami-Dade, FL" {
sum Det_Rate_Dif_2000_2009 if CountyName == "`local'"
di "Change Detention Rate in `local': `r(mean)'"
}

*1990 detention counties
foreach local in "Fulton, GA" "Orange, CA" "Suffolk, MA" "Essex, NJ" {
sum Det_Rate1990 if CountyName == "`local'"
di "IM p25 for Black Children in `local': `r(mean)'"
}

*******************************************************************
****** Franklin, OH vs. Broward, FL simulation for poverty ********
*******************************************************************

*Get Franklin detention rate change
sum Det_Rate_Dif_2000_2009 if CountyName == "Franklin, OH"
local Franklin_det_rate = `r(mean)'

*Get Broward detention rate change
sum Det_Rate_Dif_2000_2009 if CountyName == "Broward, FL"
local Broward_det_rate = `r(mean)'

*Get Franklin poverty rate change
sum PctPov_All_25_44_DIF if CountyName == "Franklin, OH"
local Franklin_allpov_rate = `r(mean)'

*Get Franklin poverty rate change for Black individuals
sum PctPov_Black_25_44_DIF if CountyName == "Franklin, OH"
local Franklin_blackpov_rate = `r(mean)'

**Delta Poverty Delta Detention linear fit NO CONTROLS
reg PctPov_All_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000 ]

*Estimate poverty rate delta if Franklin changed to Broward and calculate differences
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_pov_rate = `delta_pov_rate' + `Franklin_allpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

**Delta Poverty Delta Detention linear fit WITH CONTROLS
reg PctPov_All_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_pov' [aweight = pop_All_25_44_2000 ]
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_pov_rate = `delta_pov_rate' + `Franklin_allpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

**Delta Poverty Delta Detention linear fit for Black individuals NO CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_Black_25_44_2000 ]
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_pov_rate = `delta_pov_rate' + `Franklin_blackpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

**Delta Poverty Delta Detention linear fit for Black individuals WITH CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_pov' [aweight = pop_Black_25_44_2000 ]
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_pov_rate = `delta_pov_rate' + `Franklin_blackpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

**********************************************************************
****** Franklin, OH vs. Broward, FL simulation for employment ********
**********************************************************************

*Get Franklin detention rate change
sum Det_Rate_Dif_2000_2009 if CountyName == "Franklin, OH"
local Franklin_det_rate = `r(mean)'

*Get Broward detention rate change
sum Det_Rate_Dif_2000_2009 if CountyName == "Broward, FL"
local Broward_det_rate = `r(mean)'

*Get Franklin emp rate change
sum Emp_All_25_44_DIF if CountyName == "Franklin, OH"
local Franklin_allemp_rate = `r(mean)'

*Get Franklin emp rate change for Black individuals
sum Emp_Black_16_64_DIF if CountyName == "Franklin, OH"
local Franklin_blackemp_rate = `r(mean)'

**Delta Emp Delta Detention linear fit NO CONTROLS
reg Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000 ]

*Estimate emp rate delta if Franklin changed to Broward and calculate differences
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_emp_rate = `delta_emp_rate' + `Franklin_allemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

**Delta Emp Delta Detention linear fit WITH CONTROLS
reg Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_emp' [aweight = pop_All_25_44_2000 ]
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_emp_rate = `delta_emp_rate' + `Franklin_allemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

**Delta Emp Delta Detention linear fit for Black individuals NO CONTROLS
reg Emp_Black_16_64_DIF Det_Rate_Dif_2000_2009 [aweight = pop_Black_16_64_2000 ]
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_emp_rate = `delta_emp_rate' + `Franklin_blackemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

**Delta Emp Delta Detention linear fit for Black individuals WITH CONTROLS
reg Emp_Black_16_64_DIF Det_Rate_Dif_2000_2009 `x_vars_emp' [aweight = pop_Black_16_64_2000 ]
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`Franklin_det_rate' - `Broward_det_rate'))	
local counterfactual_emp_rate = `delta_emp_rate' + `Franklin_blackemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

****************************************************************
****** Fulton, GA vs. Suffolk, MA simulation for IM p25 ********
****************************************************************

*Get Fulton 1990 detention rate
sum Det_Rate1990 if CountyName == "Fulton, GA"
local Fulton_det_rate = `r(mean)'

*Get Suffolk 1990 detention rate
sum Det_Rate1990 if CountyName == "Suffolk, MA"
local Suffolk_det_rate = `r(mean)'

*Get Fulton p25 IM for all kids
sum interMob_All_p25 if CountyName == "Fulton, GA"
local Fulton_allim_rate = `r(mean)'

*Get Fulton p25 IM for black kids
sum interMob_Black_p25 if CountyName == "Fulton, GA"
local Fulton_blackim_rate = `r(mean)'

**IM Detention linear fit NO CONTROLS
reg interMob_All_p25 Det_Rate1990 [aweight = pop_All_2000 ]

*Estimate IM if Fulton changed to Suffolk and calculate differences
local delta_im_rate = _b[Det_Rate1990]*(-(`Fulton_det_rate' - `Suffolk_det_rate'))	
local counterfactual_im_rate = `delta_im_rate' + `Fulton_allim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

**IM Detention linear fit WITH CONTROLS
reg interMob_All_p25 Det_Rate1990 `x_vars_IM' [aweight = pop_All_2000 ]
local delta_im_rate = _b[Det_Rate1990]*(-(`Fulton_det_rate' - `Suffolk_det_rate'))	
local counterfactual_im_rate = `delta_im_rate' + `Fulton_allim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

**IM Detention linear fit for Black kids NO CONTROLS
reg interMob_Black_p25 Det_Rate1990 [aweight = pop_Black_2000 ]

*Estimate IM if Fulton changed to Suffolk and calculate differences
local delta_im_rate = _b[Det_Rate1990]*(-(`Fulton_det_rate' - `Suffolk_det_rate'))	
local counterfactual_im_rate = `delta_im_rate' + `Fulton_blackim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

**IM Detention linear fit for Black kids WITH CONTROLS
reg interMob_Black_p25 Det_Rate1990 `x_vars_IM' [aweight = pop_Black_2000 ]
local delta_im_rate = _b[Det_Rate1990]*(-(`Fulton_det_rate' - `Suffolk_det_rate'))	
local counterfactual_im_rate = `delta_im_rate' + `Fulton_blackim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

****************************************************************************
** All counties dropping to a 10 % detention level simulation for poverty **
****************************************************************************

*Get pop weighted average detention rate in 2000 in SCPS
sum Det_Rate2000 [aweight = pop_All_25_44_2000]
local mean_det_rate = `r(mean)'
di "`mean_det_rate' - 10"

*Get pop weighted average change in detention rate from 2000 to 2009 in SCPS
sum Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000]
local actual_det_rate_change = `r(mean)'

*Get pop weighted average delta poverty
sum PctPov_All_25_44_DIF if Det_Rate_Dif_2000_2009!=. [aweight = pop_All_25_44_2000]
local mean_allpov_rate = `r(mean)'

*Get pop weighted average delta poverty for Black individuals 
sum PctPov_Black_25_44_DIF if Det_Rate_Dif_2000_2009!=. [aweight = pop_Black_25_44_2000]
local mean_blackpov_rate = `r(mean)'

******
 
**Delta Poverty Delta Detention linear fit NO CONTROLS
reg PctPov_All_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000 ], robust

*Estimate poverty rate delta if every county went to a 10 percent detention level 
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate = `delta_pov_rate' + `mean_allpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
di `lower_coeff'
local delta_pov_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate_ci = `delta_pov_rate_ci' + `mean_allpov_rate'
di "`delta_pov_rate_ci' `counterfactual_pov_rate_ci'"

******
 
**Delta Poverty Delta Detention linear fit WITH CONTROLS
reg PctPov_All_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_pov' [aweight = pop_All_25_44_2000 ], robust
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_pov_rate = `delta_pov_rate' + `mean_allpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
di `lower_coeff'
local delta_pov_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate_ci = `delta_pov_rate_ci' + `mean_allpov_rate'
di "`delta_pov_rate_ci' `counterfactual_pov_rate_ci'"

******
 
**Delta Poverty Delta Detention linear fit for Black individuals NO CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_Black_25_44_2000 ], robust
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate = `delta_pov_rate' + `mean_blackpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
di `lower_coeff'
local delta_pov_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate_ci = `delta_pov_rate_ci' + `mean_allpov_rate'
di "`delta_pov_rate_ci' `counterfactual_pov_rate_ci'"

******
 
**Delta Poverty Delta Detention linear fit for Black individuals WITH CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_pov' [aweight = pop_Black_25_44_2000 ], robust
local delta_pov_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate = `delta_pov_rate' + `mean_blackpov_rate'
di "`delta_pov_rate' `counterfactual_pov_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
di `lower_coeff'
local delta_pov_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_pov_rate_ci = `delta_pov_rate_ci' + `mean_allpov_rate'
di "`delta_pov_rate_ci' `counterfactual_pov_rate_ci'"

************************************************************
****** All Counties, Racial Gap Benchmarks, Poverty ********
************************************************************

**Black counterfactual 2010 poverty rate 
*Delta Poverty Delta Detention linear fit for Black individuals NO CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_Black_25_44_2000 ]
local delta_pov_rate1_bk = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_pov_rate1_bk = `delta_pov_rate1_bk' + `mean_blackpov_rate'
di "`delta_pov_rate1_bk' `counterfactual_pov_rate1_bk'"

*Delta Poverty Delta Detention linear fit for Black individuals WITH CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_pov' [aweight = pop_Black_25_44_2000 ]
local delta_pov_rate2_bk = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_pov_rate2_bk = `delta_pov_rate2_bk' + `mean_blackpov_rate'
di "`delta_pov_rate2_bk' `counterfactual_pov_rate2_bk'"

**White counterfactual poverty rate change 
*Get pop weighted average delta poverty for white individuals 
sum PctPov_NonHisWhite_25_44_DIF if Det_Rate_Dif_2000_2009!=. [aweight = pop_NonHisWhite_25_44_2000]
local mean_whitepov_rate = `r(mean)'

*Delta Poverty Delta Detention linear fit for NonHisWhite individuals NO CONTROLS
reg PctPov_NonHisWhite_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_NonHisWhite_25_44_2000 ]
local delta_pov_rate1_wt = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_pov_rate1_wt = `delta_pov_rate1_wt' + `mean_whitepov_rate'
di "`delta_pov_rate1_wt' `counterfactual_pov_rate1_wt'"

*Delta Poverty Delta Detention linear fit for NonHisWhite individuals WITH CONTROLS
reg PctPov_Black_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_pov' [aweight = pop_NonHisWhite_25_44_2000 ]
local delta_pov_rate2_wt = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_pov_rate2_wt = `delta_pov_rate2_wt' + `mean_whitepov_rate'
di "`delta_pov_rate2_wt' `counterfactual_pov_rate2_wt'"

**Actual 2010 racial gap
*Get pop weighted average poverty for Black individuals in 2010
sum PctPov_Black_25_44_2010 [aweight = pop_Black_25_44_2000]
local mean_blackpov_rate = `r(mean)'

*Get pop weighted average poverty for white individuals in 2010
sum PctPov_NonHisWhite_25_44_2010 [aweight = pop_NonHisWhite_25_44_2000]
local mean_whitepov_rate = `r(mean)'

*white - black poverty gap
local wb_gap1 = `mean_whitepov_rate' - `mean_blackpov_rate'

**Counterfactual racial gap using smaller change
*Counterfactual white poverty rate
local cf_whitepov = `mean_whitepov_rate' + `delta_pov_rate1_wt'

*Counterfactual black poverty rate
local cf_blackpov = `mean_blackpov_rate' + `delta_pov_rate1_bk'

*counterfactual white - black poverty gap
local wb_gap_cf = `cf_whitepov' - `cf_blackpov'

di "white - Black 2010 actual poverty rate gap: `wb_gap1'"
di "white - Black 2010 counterfactual poverty rate gap: `wb_gap_cf'"
di "Black 2010 poverty rate: `mean_blackpov_rate'"
di "counterfact Black 2010 poverty rate: `cf_blackpov'"
di "white 2010 poverty rate: `mean_whitepov_rate'"
di "counterfact white 2010 poverty rate: `cf_whitepov'"

******************************************************************************
** All counties dropping to a 10% detention level simulation for employment **
******************************************************************************

*Get pop weighted average detention rate in 2000 in SCPS
sum Det_Rate2000 [aweight = pop_All_25_44_2000]
local mean_det_rate = `r(mean)'
di "`mean_det_rate' - 10"

*Get pop weighted average change in detention rate from 2000 to 2009 in SCPS
sum Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000]
local actual_det_rate_change = `r(mean)'

*Get pop weighted average delta emp
sum Emp_All_25_44_DIF if Det_Rate_Dif_2000_2009!=. [aweight = pop_All_25_44_2000]
local mean_allemp_rate = `r(mean)'

*Get pop weighted average delta emp for Black individuals 
sum Emp_Black_16_64_DIF if Det_Rate_Dif_2000_2009!=. [aweight = pop_Black_16_64_2000]
local mean_blackemp_rate = `r(mean)'

******
 
**Delta Emp Delta Detention linear fit NO CONTROLS
reg Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 [aweight = pop_All_25_44_2000 ], robust
*Estimate emp rate delta if every county went to a 10 percent detention level 
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate = `delta_emp_rate' + `mean_allemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
local delta_emp_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

*Using upper end of 95% CI
local upper_coeff = _b[Det_Rate_Dif_2000_2009]+(1.96*_se[Det_Rate_Dif_2000_2009])
local delta_emp_rate_ci = `upper_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

******
 
**Delta Emp Delta Detention linear fit WITH CONTROLS
reg Emp_All_25_44_DIF Det_Rate_Dif_2000_2009 `x_vars_emp' [aweight = pop_All_25_44_2000 ], robust
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate = `delta_emp_rate' + `mean_allemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
di `lower_coeff'
local delta_emp_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

*Using upper end of 95% CI
local upper_coeff = _b[Det_Rate_Dif_2000_2009]+(1.96*_se[Det_Rate_Dif_2000_2009])
di `upper_coeff'
local delta_emp_rate_ci = `upper_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

******
 
**Delta Emp Delta Detention linear fit for Black individuals NO CONTROLS
reg Emp_Black_16_64_DIF Det_Rate_Dif_2000_2009 [aweight = pop_Black_16_64_2000 ], robust
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate = `delta_emp_rate' + `mean_blackemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
local delta_emp_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

*Using upper end of 95% CI
local upper_coeff = _b[Det_Rate_Dif_2000_2009]+(1.96*_se[Det_Rate_Dif_2000_2009])
local delta_emp_rate_ci = `upper_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

******

**Delta Emp Delta Detention linear fit for Black individuals WITH CONTROLS
reg Emp_Black_16_64_DIF Det_Rate_Dif_2000_2009 `x_vars_emp' [aweight = pop_Black_16_64_2000 ], robust
local delta_emp_rate = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate = `delta_emp_rate' + `mean_blackemp_rate'
di "`delta_emp_rate' `counterfactual_emp_rate'"

*Using lower end of 95% CI
local lower_coeff = _b[Det_Rate_Dif_2000_2009]-(1.96*_se[Det_Rate_Dif_2000_2009])
local delta_emp_rate_ci = `lower_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

*Using upper end of 95% CI
local upper_coeff = _b[Det_Rate_Dif_2000_2009]+(1.96*_se[Det_Rate_Dif_2000_2009])
local delta_emp_rate_ci = `upper_coeff'*(-(`actual_det_rate_change'-(10-`mean_det_rate')))
local counterfactual_emp_rate_ci = `delta_emp_rate_ci' + `mean_allemp_rate'
di "`delta_emp_rate_ci' `counterfactual_emp_rate_ci'"

***************************************************************
****** All Counties, Racial Gap Benchmarks, Employment ********
***************************************************************

**Black counterfactual 2010 employment rate 
*Delta Employment Delta Detention linear fit for Black individuals NO CONTROLS
reg Emp_Black_16_64_DIF Det_Rate_Dif_2000_2009 [aweight = pop_Black_16_64_2000 ]
local delta_emp_rate1_bk = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))		
local counterfactual_emp_rate1_bk = `delta_emp_rate1_bk' + `mean_blackemp_rate'
di "`delta_emp_rate1_bk' `counterfactual_emp_rate1_bk'"

*Delta Employment Delta Detention linear fit for Black individuals WITH CONTROLS
reg Emp_Black_16_64_DIF Det_Rate_Dif_2000_2009 `x_vars_emp' [aweight = pop_Black_16_64_2000  ]
local delta_emp_rate2_bk = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate2_bk = `delta_emp_rate2_bk' + `mean_blackemp_rate'
di "`delta_emp_rate2_bk' `counterfactual_emp_rate2_bk'"

**White counterfactual employment rate change 
*Get pop weighted average delta employment for White individuals 
sum Emp_NonHisWhite_16_64_DIF if Det_Rate_Dif_2000_2009!=. [aweight = pop_NonHisWhite_16_64_2000]
local mean_whiteemp_rate = `r(mean)'

*Delta Employment Delta Detention linear fit for NonHisWhite individuals NO CONTROLS
reg Emp_NonHisWhite_16_64_DIF Det_Rate_Dif_2000_2009 [aweight = pop_NonHisWhite_16_64_2000 ]
local delta_emp_rate1_wt = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate1_wt = `delta_emp_rate1_wt' + `mean_whiteemp_rate'
di "`delta_emp_rate1_wt' `counterfactual_emp_rate1_wt'"

*Delta Employment Delta Detention linear fit for NonHisWhite individuals WITH CONTROLS
reg Emp_NonHisWhite_16_64_DIF Det_Rate_Dif_2000_2009 `x_vars_emp' [aweight = pop_NonHisWhite_16_64_2000 ]
local delta_emp_rate2_wt = _b[Det_Rate_Dif_2000_2009]*(-(`actual_det_rate_change'-(10-`mean_det_rate')))	
local counterfactual_emp_rate2_wt = `delta_emp_rate2_wt' + `mean_whiteemp_rate'
di "`delta_emp_rate2_wt' `counterfactual_emp_rate2_wt'"

**Actual 2010 racial gap
*Get pop weighted average emp-pop ratio for Black individuals in 2010
sum Emp_Black_16_64_2010 [aweight = pop_Black_16_64_2000]
local mean_blackemp_rate = `r(mean)'

*Get pop weighted average emp-pop ratio for white individuals in 2010
sum Emp_NonHisWhite_16_64_2010 [aweight = pop_NonHisWhite_16_64_2000]
local mean_whiteemp_rate = `r(mean)'

* white - black employment gap
local wb_gap1 = `mean_whiteemp_rate' - `mean_blackemp_rate'

**Counterfactual racial gap, using smaller change
*Counterfactual white employment rate
local cf_whiteemp = `mean_whiteemp_rate' + `delta_emp_rate2_wt'

*Counterfactual black employment rate
local cf_blackemp = `mean_blackemp_rate' + `delta_emp_rate1_bk'

*counterfactual white - black employment gap
local wb_gap_cf = `cf_whiteemp' - `cf_blackemp'

di "white - Black 2010 actual e-pop rate gap: `wb_gap1'"
di "white - Black 2010 counterfactual e-pop rate gap: `wb_gap_cf'"
di "Black 2010 e-pop rate: `mean_blackemp_rate'"
di "counterfact Black e-pop rate 2010 `cf_blackemp'"
di "white 2010 e-pop rate: `mean_whiteemp_rate'"
di "counterfact white e-pop rate 2010 `cf_whiteemp'"

***********************************************************************
** All counties dropping to 10 percent detention rate in 1990 IM p25 **
***********************************************************************

*Get mean 1990 detention rate
sum Det_Rate1990 [aweight = pop_All_2000]
local mean_det_rate = `r(mean)'

*Get mean p25 IM for all kids
sum interMob_All_p25 if Det_Rate1990!=. [aweight = pop_All_2000]
local mean_allim_rate = `r(mean)'

*Get mean p25 IM for black kids
sum interMob_Black_p25 if Det_Rate1990!=. [aweight = pop_Black_2000]
local mean_blackim_rate = `r(mean)'

**IM Detention linear fit NO CONTROLS
reg interMob_All_p25 Det_Rate1990 [aweight = pop_All_2000 ]

*Estimate IM if all counties dropped to 10 percent 
local delta_im_rate = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate = `delta_im_rate' + `mean_allim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

**IM Detention linear fit WITH CONTROLS
reg interMob_All_p25 Det_Rate1990 `x_vars_IM' [aweight = pop_All_2000 ]
local delta_im_rate = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate = `delta_im_rate' + `mean_allim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

**IM Detention linear fit for Black kids NO CONTROLS
reg interMob_Black_p25 Det_Rate1990 [aweight = pop_Black_2000 ]
local delta_im_rate = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate = `delta_im_rate' + `mean_blackim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

**IM Detention linear fit for Black kids WITH CONTROLS
reg interMob_Black_p25 Det_Rate1990 `x_vars_IM' [aweight = pop_Black_2000 ]
local delta_im_rate = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate = `delta_im_rate' + `mean_blackim_rate'
di "`delta_im_rate' `counterfactual_im_rate'"

*******************************************************
****** All Counties, Racial Gap Benchmarks, IM ********
*******************************************************

*** Get delta IM for Black kids 
*Get mean p25 IM for black kids
sum interMob_Black_p25 if Det_Rate1990!=. [aweight = pop_Black_2000]
local mean_blackim_rate = `r(mean)'

**IM Detention linear fit for Black kids NO CONTROLS
reg interMob_Black_p25 Det_Rate1990 [aweight = pop_Black_2000 ]
local delta_im_rate1_bk = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate1_nk = `delta_im_rate1_bk' + `mean_blackim_rate'
di "`delta_im_rate1_bk' `counterfactual_im_rate1_nk'"

**IM Detention linear fit for Black kids WITH CONTROLS
reg interMob_Black_p25 Det_Rate1990 `x_vars_IM' [aweight = pop_Black_2000 ]
local delta_im_rate2_bk = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate2_bk = `delta_im_rate2_bk' + `mean_blackim_rate'
di "`delta_im_rate2_bk' `counterfactual_im_rate2_bk'"

*** Get delta IM for white kids
*Get mean p25 IM for white kids
sum interMob_NonHisWhite_p25 if Det_Rate1990!=. [aweight = pop_NonHisWhite_2000]
local mean_whiteim_rate = `r(mean)'

**IM Detention linear fit for NonHisWhite kids NO CONTROLS
reg interMob_NonHisWhite_p25 Det_Rate1990 [aweight = pop_NonHisWhite_2000 ]
local delta_im_rate1_wt = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate1_nk = `delta_im_rate1_wt' + `mean_whiteim_rate'
di "`delta_im_rate1_wt' `counterfactual_im_rate1_nk'"

**IM Detention linear fit for NonHisWhite kids WITH CONTROLS
reg interMob_NonHisWhite_p25 Det_Rate1990 `x_vars_IM' [aweight = pop_NonHisWhite_2000 ]
local delta_im_rate2_wt = _b[Det_Rate1990]*(-(`mean_det_rate' - 10))	
local counterfactual_im_rate2_wt = `delta_im_rate2_wt' + `mean_whiteim_rate'
di "`delta_im_rate2_wt' `counterfactual_im_rate2_wt'"

*** Actual Racial gap 
local wb_gap1 = `mean_whiteim_rate' - `mean_blackim_rate'

*** Counterfactual Racial Gap, using smaller change
*Counterfactual white IM
local cf_whiteim = `mean_whiteim_rate' + `delta_im_rate1_wt'
di `cf_whiteim'

*Counterfactual black IM
local cf_blackim = `mean_blackim_rate' + `delta_im_rate1_bk'
di `cf_blackim'

*counterfactual white - black racial gap
local wb_gap_cf = `cf_whiteim' - `cf_blackim'
di "white - Black 2010 actual IM gap: `wb_gap1'"
di "white - Black 2010 cf IM gap: `wb_gap_cf'"
