* ============================================================================ *
* Table B.1 and Table B.2: CREATES TABLE B.1 AND RUNS ESTIMATE NEEDED FOR TABLE B.2
* ============================================================================ *

* First version: November 2019
* This  version: May 2020


cd "$path"

local cps_weight "pwsswgt"
local status_class "nstatus_clean_AHR"

local start_year = 2001
local end_year = 2019
	

*get nfp
import excel using data/nfp.xlsx, cellrange(A13:D325) firstrow clear
gen month=real(substr(Period,2,2))
gen mdate=ym(Year,month)
format mdate %tm
rename Value nfp
keep mdate month nfp
sum *
desc, full
tempfile nfp
qui save `nfp', replace




use data/JOLTS_update.dta, clear

tempfile joltsmonthly

rename Openings joltsvacancies 
rename Hires joltshires 
gen mdate=ym(Year,Month)
keep jolt* mdate 

gen double T=joltsvacancies/joltshires
qui save `joltsmonthly', replace

*merge T to nfp
merge 1:1 mdate using `nfp', assert(match using) 
keep if _merge==3 | mdate>=ym(1994,1)
drop _merge

*means over shortspan
tsset mdate
foreach v in T nfp {
  tssmooth ma double `v's =`v', window(0 1 2)
  gen double l`v'=log(`v's)
  }

tempfile lTinst

qui save `lTinst', replace

	local groups "Richmond pooled U6 22"

	foreach grp in `groups' { 
  *compile all monthly job-finding rates
	if "`grp'" == "pooled" | "`grp'" == "U6" { 
		use data/jf1_20052007_`grp'.dta, clear
		} 
	
	else { 
		use data/jf1_20052007.dta, clear
		} 
	
    gen byte f=1
    rename *_jf1_* *_*
	gen year=yofd(dofm(mdate))
	
	if "`grp'" == "Richmond" { 
	 keep if `status_class' > 2
	 } 
		
	save data/graphdata_jfr_monthly_`grp'.dta, replace

  
  * Create the 2006 population weights for the Robustness regression for equation 18
  	if "`grp'" == "pooled" | "`grp'" == "U6" { 
		use mdate ss_`cps_weight'_* using data/stocks_`grp'.dta, clear
	} 
	
	else { 
	    use mdate ss_`cps_weight'_* using data/stocks.dta, clear
	}
	
	gen year=year(dofm(mdate))
	keep if year == 2006
	reshape long ss_`cps_weight'_, i(mdate year) j(`status_class')
	collapse (mean) ss_`cps_weight'_, by(year `status_class')
	rename ss_`cps_weight'_ avg_`cps_weight'_2006
	drop year
	qui save data/avg_weight_2006_`grp'.dta, replace


	if "`grp'" == "Richmond" { 

		use data/graphdata_jfr_monthly_`grp'.dta if inrange(year,`start_year', `end_year') & `status_class' > 2, clear
  } 
  
  else if "`grp'" == "U6" { 
		
		use data/graphdata_jfr_monthly_`grp'.dta if inrange(year,`start_year', `end_year') & `status_class' == 4, clear
	}
	
  else if "`grp'" == "pooled" { 
		
		use data/graphdata_jfr_monthly_`grp'.dta if inrange(year,`start_year', `end_year') & `status_class' == 3, clear
	}
 
	else { 
	  use data/graphdata_jfr_monthly_`grp'.dta if inrange(year,`start_year', `end_year') , clear
	  
	  qui replace logit_s_pw_20052007=logit_s_pw_3a_20052007 if `status_class'== 1 | `status_class'== 2
	}
	  
  

  gen calmonth=month(dofm(mdate))

  *take logs
  foreach v of varlist logit_* {
    qui gen double log_`v'=log(`v')
    }

  *merge to nfp instrument
  merge m:1 mdate using `lTinst', nogen assert(match using) keep(match)
  
  merge m:1 `status_class' using data/avg_weight_2006_`grp'.dta, nogen assert(match using) keep(match)

  *estimate for table 6
  keep if year<=`end_year'
	
  tab year
	  
	  *** Alternate Regression: Run regression without group specific etas and time trends 
	  * Version 1:  Year 2006 group weights
	  * Version 2: No Weights 


	  ivregress 2sls log_logit_s_pw_20052007   c.mdate i.calmonth i.`status_class' (lT = lnfp) [aw = avg_`cps_weight'_2006], robust
	  estimates save estimates/elast_v1_`grp'.ster, replace
	  est sto v1_`grp', title("`grp'")
	  
	  ivregress 2sls log_logit_s_pw_20052007  c.mdate i.calmonth  i.`status_class' (lT = lnfp), robust
      estimates save estimates/elast_v2_`grp'.ster, replace
	  est sto v2_`grp', title("`grp'") 
  
	 
	if "`grp'" == "22" { 
	 *Table B.2 estimates with separate elasticity for each status
      ivregress 2sls log_logit_s_pw_20052007 `status_class'##(c.mdate  i.calmonth) (`status_class'#c.lT = `status_class'#c.lnfp), robust
      estimates save estimates/sep_elast_`grp'.ster, replace
	} 
	
	
} 



use data/microdata_raw_JFR.dta  if inrange(year,`start_year', `end_year') , clear

gen mdate = ym(year, month)

  gen calmonth=month(dofm(mdate))

  *take logs
  foreach v of varlist frate_emp* {
    qui gen double log_`v'=log(`v')
    }

  *merge to nfp instrument
  merge m:1 mdate using `lTinst', nogen assert(match using) keep(match)
  
  *merge m:1 `status_class' using data/avg_weight_2006_`grp'.dta, nogen assert(match using) keep(match)

  *estimate for table 6
  keep if year<=`end_year'
	
  tab year
	  
	  *** Alternate Regression: Run regression without group specific etas and time trends 
	  * Version 1:  Year 2006 group weights
	  * Version 2: No Weights 


	  ivregress 2sls log_frate_emp   c.mdate i.calmonth i.`status_class' (lT = lnfp) [aw = group_total], robust
	  estimates save estimates/elast_v1_`grp'.ster, replace
	  est sto v1_emp, title("Raw Job Finding Rate")
	  
	  ivregress 2sls log_frate_emp  c.mdate i.calmonth  i.`status_class' (lT = lnfp), robust
      estimates save estimates/elast_v2_`grp'.ster, replace
	  est sto v2_emp, title("`grp'") 
	  

#delimit ; 
estout v2_pooled v1_22 v2_U6 v1_Richmond v1_emp
       using tables/Table_B1.tex, 
	   unstack
       style(tex) 
       cells(b(star fmt(2)) se(par fmt(2))) transform(mdate 100*@ 100)
       mlabels(, none)  
       collabels(none) 
	   eqlabels(none)
       varlabels(lT "Elasticity with Respect to Vacancy Dur" 
                 mdate "Trend in Efficiency" 
				) 
       starl(* 0.1 ** 0.05 *** 0.01)   
       keep(lT mdate)              
       order(lT mdate) 
       prehead( 
			\begin{table}[H]
			\centering
			\caption{Cyclical And Trend Variation in the Job Finding Rate - Common Elasticities}
			\label{tab:B1}
			\scalebox{.7}{
			\begin{threeparttable}
           \begin{tabular}{@{\extracolsep{4pt}}l*{@M}{c}@{}} 
           \hline \hline 
		   & \multicolumn{1}{c}{\textbf{Unemployed Pooled}} & \multicolumn{1}{c}{\textbf{22 groups (with fixed effects)}} 
		   & \multicolumn{1}{c}{\textbf{U6 Pooled}} & \multicolumn{1}{c}{\textbf{Richmond Fed (with fixed effects)}}
		   & \multicolumn{1}{c}{\textbf{Raw Job Finding Rate (with fixed effects)}}\\
       )
       posthead(\hline) 
       prefoot() 
       postfoot(
	   \hline \hline
 			\end{tabular}
			\begin{tablenotes}
			\footnotesize \textit{Notes:}  Trend coefficients are multiplied by 100. For the 22 group and Richmond
Fed estimation it is a panel estimation (9 groups) with fixed effects for each group.
Also, these panel based group estimation use population weights of the groups for
the base period 2006.
			\end{tablenotes}
			\end{threeparttable}}
			\end{table}
			   )
       replace;
#delimit cr

