* ============================================================================ *
* TABLE B.2: CREATES TABLE B.2
* ============================================================================ *

* First version: November 2019
* This version:  December 2019

cd "$path"


    local keepmore ""
    local vmore ""
    local mlist "mdate"


      drop _all
      estimates use estimates/sep_elast_22.ster
      mat b=e(b)
      local q : colnames b
      local nb : word count `q'
      qui svmat double b
      forvalues j=1/`nb' {
        local nn : word `j' of `q'
        local nn=subinstr("`nn'","o.",".",.)
        local nn=subinstr("`nn'","b.",".",.)
        local nn=subinstr("`nn'",".","_",.)
        local nn=subinstr("`nn'","#","X",.)
        local nn=subinstr("`nn'","status_clean_AHR","status",.)
        rename b`j' b`nn'
        }
      //gen byte bsample=0
      save estimates/sep_elast_22.dta, replace
	  

      drop _all
      use estimates/sep_elast_22.dta, clear
      foreach t in `mlist' {
        foreach v of varlist b*_nstatusXc_`t' {
          replace `v'=`v'+b`t'
          }
        drop b`t'
        }
      egen double elastavg=rowmean(b*_nstatusXc_lT`span')
      gen double melastavg=elastavg/(1+elastavg)
      save estimates/sep_elast_22.dta, replace
      sum *
      desc, full
      

	  
      use b*_nstatusXc_lT`span' b*_nstatusXc_mdate `keepmore' elastavg melastavg using estimates/sep_elast_22.dta, clear

      rename b#_nstatusXc_lT`span' lT#
      rename b#_nstatusXc_mdate pretrend#
	  
	  gen byte sd = 1
      
      reshape long lT`span' pretrend `vmore', i(sd) j(nstatus_clean_AHR)
      sum *
	  
      gen status = "Employed: Not Involuntary Part-Time"  if nstatus_clean_AHR  == 1
		replace status = "Employed: Involuntary Part-Time"  if nstatus_clean_AHR  == 2
		replace status =  "Unemployed: Recently Temporarily Laid Off"   if nstatus_clean_AHR  == 4
		replace status = "Unemployed: Recently Permanently Laid Off"   if nstatus_clean_AHR  == 5
		replace status = "Unemployed: Temp. Job Recently Ended"   if nstatus_clean_AHR  == 6
		replace status ="Unemployed: Recently Left Job"   if nstatus_clean_AHR  == 7
		replace status ="Unemployed: Recently Newly Entered"   if nstatus_clean_AHR  == 8
		replace status ="Unemployed: Recently Re-Entered"   if nstatus_clean_AHR  == 9
		replace status ="Unemployed: Temporarily Laid Off for Months"   if nstatus_clean_AHR  == 10
		replace status ="Unemployed: Permanently Laid Off Months Ago"   if nstatus_clean_AHR  == 11
		replace status ="Unemployed: Temp. Job Ended Months Ago"   if nstatus_clean_AHR  == 12
		replace status ="Unemployed: Left Job Months Ago"   if nstatus_clean_AHR  == 13
		replace status ="Unemployed: Newly Entered Months Ago"   if nstatus_clean_AHR  == 14
		replace status ="Unemployed: Re-Entered Months Ago"   if nstatus_clean_AHR  == 15
		replace status ="Unemployed: Long-Term Unemployed"   if nstatus_clean_AHR  == 16
		replace status ="Not in Labor Force: Other"   if nstatus_clean_AHR  == 17
		replace status ="Not in Labor Force: In School"   if nstatus_clean_AHR  == 18
		replace status ="Not in Labor Force: Retired"   if nstatus_clean_AHR  == 19
		replace status ="Not in Labor Force: Disabled"   if nstatus_clean_AHR  == 20		
		replace status ="Want Job: Other"   if nstatus_clean_AHR  == 21
		replace status ="Want Job: Discouraged"   if nstatus_clean_AHR  == 22
		replace status ="Want Job: Looked Last 12 Months"   if nstatus_clean_AHR  == 23
		
  
	  
	 sort nstatus_clean_AHR
	 *drop nstatus_clean_AHR
	 
		
      save estimates/sep_elast_22.dta, replace

      order status sd lT pretrend elastavg melastavg

      foreach v in pretrend {
        replace `v'=`v'*100
        }
	  
	  
		replace nstatus_clean_AHR = 30 if nstatus_clean_AHR == 2
		replace nstatus_clean_AHR = 31 if nstatus_clean_AHR == 1
		replace nstatus_clean_AHR = 1 if nstatus_clean_AHR == 7
		replace nstatus_clean_AHR = 2 if nstatus_clean_AHR == 5
		replace nstatus_clean_AHR = 3 if nstatus_clean_AHR == 4
		replace nstatus_clean_AHR = 4 if nstatus_clean_AHR == 6
		replace nstatus_clean_AHR = 5 if nstatus_clean_AHR == 8
		replace nstatus_clean_AHR = 6 if nstatus_clean_AHR == 9
		replace nstatus_clean_AHR = 7 if nstatus_clean_AHR == 13
		replace nstatus_clean_AHR = 8 if nstatus_clean_AHR == 11
		replace nstatus_clean_AHR = 9 if nstatus_clean_AHR == 10
		replace nstatus_clean_AHR = 10 if nstatus_clean_AHR == 12
		replace nstatus_clean_AHR = 11 if nstatus_clean_AHR == 14
		replace nstatus_clean_AHR = 12 if nstatus_clean_AHR == 15
		replace nstatus_clean_AHR = 13 if nstatus_clean_AHR == 16
		replace nstatus_clean_AHR = 14 if nstatus_clean_AHR == 22
		replace nstatus_clean_AHR = 15 if nstatus_clean_AHR == 23
		replace nstatus_clean_AHR = 16 if nstatus_clean_AHR == 21
		replace nstatus_clean_AHR = 20 if nstatus_clean_AHR == 17
		replace nstatus_clean_AHR = 17 if nstatus_clean_AHR == 18
		replace nstatus_clean_AHR = 18 if nstatus_clean_AHR == 19	
		replace nstatus_clean_AHR = 19 if nstatus_clean_AHR == 20
		replace nstatus_clean_AHR = 21 if nstatus_clean_AHR == 30
		replace nstatus_clean_AHR = 22 if nstatus_clean_AHR == 31

	  
	  rename lT Elasticity
	  rename pretrend Trend
	  sort nstatus_clean_AHR 
	  
	  drop elastavg melastavg sd nstatus_clean_AHR sd

	  dataout, save(tables/Table_B2) tex dec(2) replace


exit

