* ============================================================================ *
* TABLE 1: THIS IS THE DO FILE TO CREATE TABLE 1 
*							   
*	Purpose: This do file creates the TeX files for the Table on page 43.
*			 Output: Final_Table_1_2006.tex and Final_Table_1_2010.tex
*			 Inputs: Empirical Job Finding Rate Dataset: microdata_raw_JFR_annual.dta
*					 Estimated Job Finding Rate Dataset: jf1_annual_20052007.dta
*					 Group share of the population in 2005-2007:  stocks.dta
*
* ============================================================================ *

* First version: November 2019
* This  version: May 2020

cd "$path"

*** CPS Weight
local cps_weight "pwsswgt"

	
  *Table 5: Uses the share of the population for each group for each year
  use mdate share_`cps_weight'_* using data/stocks.dta, clear
  gen year=year(dofm(mdate))
  collapse (mean) share_`cps_weight'_*, by(year) fast
  reshape long share_`cps_weight'_, i(year) j(nstatus_clean_AHR)
  reshape wide share_`cps_weight'_, i(nstatus_clean_AHR) j(year)
  tempfile newtab5
  qui save `newtab5', replace
  
  
  * Table 5: Transforms JFR into percent and the share into percent
  use nstatus_clean_AHR year logit_s*_pw_jf1_* using data/jf1_annual_20052007.dta, clear
  
  replace logit_s_pw_jf1_20052007=logit_s_pw_jf1_3a_20052007 if nstatus_clean_AHR==1 | nstatus_clean_AHR==2
  drop logit_s_pw_jf1_3a_20052007
  
  gen double frate_s=logit_s_pw_jf1*100

  keep year nstatus_clean_AHR frate_s 
  reshape wide frate_s, i(nstatus_clean_AHR) j(year)
  merge 1:1 nstatus_clean_AHR using `newtab5', nogen
  forvalues y = 1994/2019 {
	  replace share_`cps_weight'_`y' = share_`cps_weight'_`y'*100
	  }

 save data/Data_Table_5.dta, replace

 
 use data/Data_Table_5.dta, clear
	  
	reshape long contribs_ share_`cps_weight'_ frate_s, i(nstatus_clean_AHR) j(year)
  
	tempfile panel

	rename contribs_ contribs
	rename share_`cps_weight'_ share_`cps_weight'
	  
	gen RLO = frate_s if nstatus_clean_AHR == 4
	  
	sort year RLO
	carryforward RLO, replace 
	  
	gen norm_frate = frate_s/RLO //Generates variable that measures the job finding rate of each group relative to Recently Laid off
	drop RLO
	
	save `panel', replace
	
	*** Merge in the dataset that has calculated the empirical job finding rates for each group
	sort year nstatus_clean_AHR
	merge year nstatus_clean_AHR using data/microdata_raw_JFR_annual.dta
	drop _merge 
	
	
	*** Label the labor force groups and rearrange the order for the table

      gen status = "Employed: Not Involuntary Part-Time"  if nstatus_clean_AHR  == 1
		replace status = "Employed: Involuntary Part-Time"  if nstatus_clean_AHR  == 2
		replace status =  "Unemployed: Recently Temporarily Laid Off"   if nstatus_clean_AHR  == 4
		replace status = "Unemployed: Recently Permanently Laid Off"   if nstatus_clean_AHR  == 5
		replace status = "Unemployed: Temp. Job Recently Ended"   if nstatus_clean_AHR  == 6
		replace status ="Unemployed: Recently Left Job"   if nstatus_clean_AHR  == 7
		replace status ="Unemployed: Recently Newly Entered"   if nstatus_clean_AHR  == 8
		replace status ="Unemployed: Recently Re-Entered"   if nstatus_clean_AHR  == 9
		replace status ="Unemployed: Temporarily Laid Off for Months"   if nstatus_clean_AHR  == 10
		replace status ="Unemployed: Permanently Laid Off Months Ago"   if nstatus_clean_AHR  == 11
		replace status ="Unemployed: Temp. Job Ended Months Ago"   if nstatus_clean_AHR  == 12
		replace status ="Unemployed: Left Job Months Ago"   if nstatus_clean_AHR  == 13
		replace status ="Unemployed: Newly Entered Months Ago"   if nstatus_clean_AHR  == 14
		replace status ="Unemployed: Re-Entered Months Ago"   if nstatus_clean_AHR  == 15
		replace status ="Unemployed: Long-Term Unemployed"   if nstatus_clean_AHR  == 16
		replace status ="Not in Labor Force: Other"   if nstatus_clean_AHR  == 17
		replace status ="Not in Labor Force: In School"   if nstatus_clean_AHR  == 18
		replace status ="Not in Labor Force: Retired"   if nstatus_clean_AHR  == 19
		replace status ="Not in Labor Force: Disabled"   if nstatus_clean_AHR  == 20		
		replace status ="Want Job: Other"   if nstatus_clean_AHR  == 21
		replace status ="Want Job: Discouraged"   if nstatus_clean_AHR  == 22
		replace status ="Want Job: Looked Last 12 Months"   if nstatus_clean_AHR  == 23
		
		replace nstatus_clean_AHR = 30 if nstatus_clean_AHR == 2
		replace nstatus_clean_AHR = 31 if nstatus_clean_AHR == 1
		replace nstatus_clean_AHR = 1 if nstatus_clean_AHR == 7
		replace nstatus_clean_AHR = 2 if nstatus_clean_AHR == 5
		replace nstatus_clean_AHR = 3 if nstatus_clean_AHR == 4
		replace nstatus_clean_AHR = 4 if nstatus_clean_AHR == 6
		replace nstatus_clean_AHR = 5 if nstatus_clean_AHR == 8
		replace nstatus_clean_AHR = 6 if nstatus_clean_AHR == 9
		replace nstatus_clean_AHR = 7 if nstatus_clean_AHR == 13
		replace nstatus_clean_AHR = 8 if nstatus_clean_AHR == 11
		replace nstatus_clean_AHR = 9 if nstatus_clean_AHR == 10
		replace nstatus_clean_AHR = 10 if nstatus_clean_AHR == 12
		replace nstatus_clean_AHR = 11 if nstatus_clean_AHR == 14
		replace nstatus_clean_AHR = 12 if nstatus_clean_AHR == 15
		replace nstatus_clean_AHR = 13 if nstatus_clean_AHR == 16
		replace nstatus_clean_AHR = 14 if nstatus_clean_AHR == 22
		replace nstatus_clean_AHR = 15 if nstatus_clean_AHR == 23
		replace nstatus_clean_AHR = 16 if nstatus_clean_AHR == 21
		replace nstatus_clean_AHR = 20 if nstatus_clean_AHR == 17
		replace nstatus_clean_AHR = 17 if nstatus_clean_AHR == 18
		replace nstatus_clean_AHR = 18 if nstatus_clean_AHR == 19	
		replace nstatus_clean_AHR = 19 if nstatus_clean_AHR == 20
		replace nstatus_clean_AHR = 21 if nstatus_clean_AHR == 30
		replace nstatus_clean_AHR = 22 if nstatus_clean_AHR == 31
	
		sort nstatus_clean_AHR 
	
		
	  save `panel', replace 
  
  
	  use `panel', clear
	  
	  keep if year == 2006 | year == 2010 
	  reshape wide frate* share_* contrib* norm_*, i(nstatus_clean_AHR status) j(year)
  
	  preserve 

	  keep status share_`cps_weight'2006 frate_s2006 norm_frate*2006 
	  order  status share_`cps_weight'2006 frate*2006 norm_frate*2006
	  
	  
	  dataout, save(tables/Final_Table_1_2006) tex dec(2) replace

	  restore 
	  
	  keep status share_`cps_weight'2010 frate_s2010  norm_frate*2010 
	  order status share_`cps_weight'2010 frate*2010  norm_frate*2010 
	  
	  dataout, save(tables/Final_Table_1_2010) tex dec(2) replace
