* ============================================================================ *
* COMMAND CODE: CREATE TABLE 1, TABLE B1 AND TABLE B2
*		OUTPUT: Final_Table_1_2006.tex and Final_Table_1_2010.tex
* 				Table_B1.tex
* 			    Table_B2.tex
*							   
* 		 INPUT: Empirical Job Finding Rate Dataset:  data/microdata_raw_JFR_annual.dta
*			    Estimated Job Finding Rate Dataset:  data/jf1_annual_20052007.dta
*			    Estimated Monthly Job Finding Rate Dataset: 
*							  22 Groups and Richmond Index: data/jf1_20052007.dta
*														U6: data/jf1_20052007_U6.dta
*									   Pooled Unemployment: data/jf1_20052007_pooled.dta
*			    Group population share in 2005-2007 for: 
*					 			22 Groups and Richmond Index: data/stocks.dta
*														 U6	: data/stocks_U6.dta
*										 Pooled Unemployment: data/stocks_pooled.dta

*               JOLTS Dataset with Opening and Hires: data/JOLTS_update.dta
* 				Current Establishment Survey (CES) payroll employment: data/nfp.xlsx
*      
*	Purpose: This do file creates Tables 1, B.1 and B.2 in Abraham et al. 
*            "How Tight is the US Labor Market". Table 1 is found on page 
*			  43 of the paper. Tables B.1 and B.2 are on page 18 of the 
*			  online appendix.
* NOTE: For further explanation, see README_Tables_1_B1_B2.txt located in the 
*		folder Tables_1_B1_B2.
*
* ============================================================================ *

*************************
* Instructions:
* ***********************

*1) Set the working directory (where the do file and datasets are saved)

	global path "[Insert Directory Here]/Tables_1_B1_B2"
	cd "$path"

*2) Run Files: 

	do dofiles/Table_1.do
	do dofiles/Tables_B1_and_B2.do
	do dofiles/Table_B2.do
	




