* This code produces robustness analysis for Abraham, Haltiwanger and Rendell
* "How Tight is the U.S. Labor Market", BPEA, Spring 2020
*This code produces the analysis using 22 groups with raw job finding rates
* It is similar to baseline code but only produces the figures in appendix for this
* case.  Other analysis has been commented out.
* ============================================================================ *

* Current Revised Version: 10-16-2020


set more off
set linesize 100
clear matrix
clear


global folder "INSERT PATH HERE"
		global path "${folder}/Data_Raw/"
		global TeX 		"${folder}/Graphs_Raw"
		
		cd "$path"
		
		
set scheme sol

log using AHR_Raw.log, replace
		

use AHR_Final_raw_May_1.dta, clear


gen employment_AHR=employed_AHR+employed_IPT_AHR
		
gen Generalized_Denom_emp = gamma_OLFO*nilf_other_AHR + gamma_OLFS*nilf_school_AHR +  gamma_OLFR*nilf_retired_AHR + gamma_OLFD*nilf_disabled_AHR +/*
								 */ gamma_WJO*wantjob_other_AHR + /*
								 */ gamma_WJD*wantjob_disc_AHR + /*
								 */ gamma_WJL*wantjob_looked_AHR + /*
								 */ gamma_RLO*onlayoff_5_AHR + /*
								 */ gamma_RLPJ*permjobloser_5_AHR + /*
								 */ gamma_TJEM*tempjobloser_5_AHR + /*
								 */ gamma_RQ*jobleavers_5_AHR +  /*
								 */ gamma_RE*newentrants_5_AHR +/*
								 */ gamma_RRE*reentrants_5_AHR +/* 
								 */ gamma_LM*onlayoff_M_AHR +/*
								 */ gamma_LPJM*permjobloser_M_AHR + /*
								 */ gamma_TJEM*tempjobloser_M_AHR + /*
								 */ gamma_QM*jobleavers_M_AHR + /*
								 */ gamma_EM*newentrants_M_AHR + /*
								 */ gamma_MRE*reentrants_M_AHR +/*
								 */ gamma_LTU*longterm_U_AHR

gen Generalized_Denom_uwant =       gamma_WJO*wantjob_other_AHR + /*
								 */ gamma_WJD*wantjob_disc_AHR + /*
								 */ gamma_WJL*wantjob_looked_AHR + /*
								 */ gamma_RLO*onlayoff_5_AHR + /*
								 */ gamma_RLPJ*permjobloser_5_AHR + /*
								 */ gamma_TJEM*tempjobloser_5_AHR + /*
								 */ gamma_RQ*jobleavers_5_AHR +  /*
								 */ gamma_RE*newentrants_5_AHR +/*
								 */ gamma_RRE*reentrants_5_AHR +/* 
								 */ gamma_LM*onlayoff_M_AHR +/*
								 */ gamma_LPJM*permjobloser_M_AHR + /*
								 */ gamma_TJEM*tempjobloser_M_AHR + /*
								 */ gamma_QM*jobleavers_M_AHR + /*
								 */ gamma_EM*newentrants_M_AHR + /*
								 */ gamma_MRE*reentrants_M_AHR +/*
								 */ gamma_LTU*longterm_U_AHR								 
								 
								 
gen Generalized_Denom_u = 		  gamma_RLO*onlayoff_5_AHR + /*
								 */ gamma_RLPJ*permjobloser_5_AHR + /*
								 */ gamma_TJEM*tempjobloser_5_AHR + /*
								 */ gamma_RQ*jobleavers_5_AHR +  /*
								 */ gamma_RE*newentrants_5_AHR +/*
								 */ gamma_RRE*reentrants_5_AHR +/* 
								 */ gamma_LM*onlayoff_M_AHR +/*
								 */ gamma_LPJM*permjobloser_M_AHR + /*
								 */ gamma_TJEM*tempjobloser_M_AHR + /*
								 */ gamma_QM*jobleavers_M_AHR + /*
								 */ gamma_EM*newentrants_M_AHR + /*
								 */ gamma_MRE*reentrants_M_AHR +/*
								 */ gamma_LTU*longterm_U_AHR								 

									 

gen nonemp=population_16up_AHR-employment_AHR
						
					 
		
gen u6lev=u6*population_16up_AHR	
	
										 

gen jfru_G=frate_U_GF

							 
								 
								 
gen Generalized_Measure_emp   = Openings/Generalized_Denom_emp

gen Generalized_Measure_u   = Openings/Generalized_Denom_u

	
gen Generalized_Measure_uwant   = Openings/Generalized_Denom_uwant						 
								 

gen STU=Unemployed_All-longterm_U_AHR

gen STU_pop=STU/pop_AHR
gen LTU_pop=longterm_U_AHR/pop_AHR

gen LF=Unemployed_All+employed_AHR



gen STU_LF=STU/LF
gen LTU_LF=longterm_U_AHR/LF
	 
		
		gen LaborTightness=LaborTightness_AHR
		
		gen Generalized_Denominator=Gen_Denominator_AHR
		
		gen norm_General_Denom_emp=Generalized_Denom_emp/pop_AHR
	    gen norm_General_Denom_u=Generalized_Denom_u/pop_AHR
        gen norm_General_Denom_uwant=Generalized_Denom_uwant/pop_AHR
	
	save AHR_Baseline_Final2.dta, replace

	/*
		
		keep Year Month date Openings Unemployed_All* LaborTightness Generalized_Numerator Generalized_Denominator norm*_AHR norm_General_Denom_emp norm_General_Denom_u norm_General_Denom_uwant
			
		order Year Month date
			
		export excel using "${path}\DataForBeveridgeCurve.xlsx", firstrow(variables) replace

*/		
		

    use AHR_Baseline_Final2.dta, clear
	

* Some housecleaning


gen Generalized_Measure_trend=Gen_Measure_trend_AHR

gen Generalized_Measure_trend_06=Gen_Measure_trend_06_AHR

gen Generalized_Measure_gamma=Gen_Measure_gamma_AHR

gen Generalized_Measure_gamma_06=Gen_Measure_gamma_06_AHR


gen Generalized_Measure_06=Gen_Measure_06_AHR

gen Generalized_Denominator_trend=Gen_Denominator_trend_AHR


gen Unemployed_All=Unemployed_All_AHR


gen employment_sa=employment_AHR
gen population_16up=population_16up_AHR

gen IndexofRecruitingIntensitype=Recruiting_Intensity

gen Gen_Denominator_gamma=Gen_Denominator_gamma_AHR

gen Generalized_Measure_gamma2=Openings/Gen_Denominator_gamma_AHR
*this measure does not include RI


save AHR_Baseline_Data2.dta, replace 
	
	keep if Year == 2006
		
	egen GM_T_g2_2006=mean(Generalized_Measure_gamma2)
	egen GM_T_emp_2006 = mean(Generalized_Measure_emp)
	egen LT_D_2006=mean(norm_LT_Denominator_pop_AHR)
	egen GM_T_u_2006 = mean(Generalized_Measure_u)
	egen GM_D_emp_2006=mean(norm_General_Denom_emp)
	egen GM_D_u_2006=mean(norm_General_Denom_u)
	egen GM_T_uwant_2006 = mean(Generalized_Measure_uwant)
	egen GM_D_uwant_2006=mean(norm_General_Denom_uwant)
	egen GM_D_2006=mean(norm_Gen_Denominator_AHR)
	egen GM_D_g_2006=mean(norm_Gen_Denominator_gamma_AHR)
	egen GM_D_trend_2006=mean(norm_Gen_Denominator_trend_AHR)
	egen LT_N_Num_2006=mean(norm_LT_Numerator_pop_AHR)
	egen GM_N_Num_2006=mean(norm_Gen_Numerator_AHR)
			
	keep if _n == 1	
	keep GM_T_emp_2006 GM_T_g2_2006 GM_T_u_2006 GM_T_uwant_2006 GM_D* STU* LTU* LT_D* LT_N* GM_N* 
	
	gen n = 1
	sort n 
	save GM_Measure_2006.dta, replace 
		
	
	use AHR_Baseline_Data2.dta, clear 

	gen n = 1
	
	sort n
	
	merge m:1 n using GM_Measure_2006.dta
	
	drop n _merge
	
	sort Year Month
	
	
		
	gen Generalized_Measure_gamma2_06=Generalized_Measure_gamma2/GM_T_g2_2006
	gen Generalized_Measure_emp_06 = Generalized_Measure_emp/GM_T_emp_2006
	gen Generalized_Measure_u_06 = Generalized_Measure_u/GM_T_u_2006
	gen Generalized_Measure_uwant_06 = Generalized_Measure_uwant/GM_T_uwant_2006
	
	
	gen norm_Gen_Denom_2006=norm_Gen_Denominator_AHR/GM_D_2006
	gen norm_Gen_Denom_g_2006=norm_Gen_Denominator_gamma_AHR/GM_D_g_2006
	gen norm_Gen_Denom_emp_2006=norm_General_Denom_emp/GM_D_emp_2006
	gen norm_Gen_Denom_u_2006=norm_General_Denom_u/GM_D_u_2006
	gen norm_Gen_Denom_uwant_2006=norm_General_Denom_uwant/GM_D_uwant_2006
	gen norm_LT_Denom_2006=norm_LT_Denominator_pop_AHR/LT_D_2006
	gen norm_Gen_Denom_trend_2006=norm_Gen_Denominator_trend_AHR/GM_D_trend_2006
	gen norm_LT_Numerator_pop_06=norm_LT_Numerator_pop_AHR/LT_N_Num_2006
	gen norm_Gen_Numerator_AHR_06=norm_Gen_Numerator_AHR/GM_N_Num_2006
	
	* Bev  curve slopes for Table B.3
	
	reg norm_LT_Numerator_pop_06 norm_LT_Denom_2006
	reg norm_LT_Numerator_pop_06 norm_Gen_Denom_g_2006
	reg norm_LT_Numerator_pop_06 norm_Gen_Denom_emp_2006
	reg norm_LT_Numerator_pop_06 norm_Gen_Denom_uwant_2006
	reg norm_LT_Numerator_pop_06 norm_Gen_Denom_u_2006

gen Generalized_Measure_trend_adj=Generalized_Measure_trend
gen Generalized_Measure_trend_06_adj=Generalized_Measure_trend_06
gen Generalized_Measure_06_adj=Generalized_Measure_06
gen Generalized_Denom_trend_adj=Generalized_Denominator_trend
gen Generalized_Denom_adj=Generalized_Denominator

*These values are from Table B.2 where alpha=(1/(1+eta))

**** THE ETA FOR THE RAW IS .78***** 

gen eta = .78
gen eta_ud = 1.04
gen eta_u6 = 1.1
gen eta_rich = 0.67 


	 gen alpha=1/(1+ eta)
	 gen alpha_ud=1/(1+ eta_ud)
	 gen alpha_u6=1/(1+ eta_u6)
	 gen alpha_rich=1/(1+ eta_rich)
	
	*summ alpha*

	
	
* do gross flows predictions
gen pred_std_jfru_G=(Openings/Hires)^eta
gen pred_std_jfru_ud_G=(Openings/Hires)^eta_ud
gen pred_gen_jfru_G=((IndexofRecruitingIntensitype)^eta)*(Generalized_Denom_u/Unemployed_All)*((Openings/Hires)^eta)
gen pred_gen_jfru_NRI_G=(Generalized_Denom_u/Unemployed_All)*((Openings/Hires)^eta)
gen pred_gen_jfru_AG=((IndexofRecruitingIntensitype)^eta)*(Generalized_Denom_trend_adj/Unemployed_All)*((Openings/Hires)^eta)
gen pred_gen_jfru_SG=(Generalized_Denom_trend_adj/Unemployed_All)*((Openings/Hires)^eta)


gen u6_pop=u6*(Unemployed_All+employment_sa)/population_16up

*replace u6_pop=u6_pop/100
gen pop=population_16up

gen u6_level=u6_pop*pop
gen Richmond_level=Richmond*population_16up

* tightness measures
gen tightness_u6=Openings/u6_level
gen tightness_rich=Openings/Richmond_level

/*
* Figure A.12
tsline IndexofRecruitingIntensitype if date >=tm(1994m1), lcolor(blue) lwidth(medthick medthick) lpattern(solid) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ylabel(0 (.2) 1.3, labsize(medsmall)) /*
		*/legend(label(1 "Index") ring(0) pos(2) col(4) size(small) symxsize(10)) 
		capture graph export "$TeX/Graphs/FigureA12.png",  replace	
	*/	



gen job_fill_std=Hires/Openings



gen pred_job_fill_std=(Unemployed_All/Openings)^(alpha)

gen pred_job_fill_std_aud=(Unemployed_All/Openings)^(alpha_ud)
gen pred_job_fill_richa=(Richmond_level/Openings)^(alpha_rich)

gen pred_job_fill_u6a=(u6_level/Openings)^(alpha_u6)

gen pred_job_fill_gen_trend=IndexofRecruitingIntensitype*(Generalized_Denom_trend_adj/Generalized_Numerator)^(alpha)
gen pred_job_fill_gen=IndexofRecruitingIntensitype*(Generalized_Denom_adj/Generalized_Numerator)^(alpha)

gen pred_job_fill_gen_gamma=IndexofRecruitingIntensitype*(Gen_Denominator_gamma/Generalized_Numerator)^(alpha)
gen pred_job_fill_gen_trend_unadj=(Generalized_Denom_trend_adj/Openings)^(alpha)
gen pred_job_fill_gen_gamma_No_RI=(Gen_Denominator_gamma/Openings)^(alpha)

gen pred_job_fill_gen_emp=(Generalized_Denom_emp/Openings)^(alpha)
gen pred_job_fill_gen_u=(Generalized_Denom_u/Openings)^(alpha)
gen pred_job_fill_gen_u_unadj=(Generalized_Denom_u/Openings)^(alpha)
gen pred_job_fill_gen_uwant=(Generalized_Denom_uwant/Openings)^(alpha)

gen Richmond_Tightness=(Openings/Richmond_level)
gen u6_Tightness=(Openings/u6_level)


gen mn=1
sort mn

save AHR_Baseline_Data2.dta, replace

keep if Year==2006
egen job_fill_std_mean_06=mean(job_fill_std)

egen mpred_job_fill_std_06=mean(pred_job_fill_std)

egen mpred_job_fill_gen_06=mean(pred_job_fill_gen)
egen mpred_job_fill_gen_trend_06=mean(pred_job_fill_gen_trend)

egen mpred_job_fill_richa_06=mean(pred_job_fill_richa)


egen mpred_job_fill_std_aud_06=mean(pred_job_fill_std_aud)


egen mtightness_u6_06=mean(tightness_u6)
egen mtightness_rich_06=mean(tightness_rich)

egen mpred_job_fill_gen_gamma_06=mean(pred_job_fill_gen_gamma)
egen mpred_job_fill_gen_No_RI_06=mean(pred_job_fill_gen_gamma_No_RI)

egen mpred_job_fill_gen_tr_unadj_06=mean(pred_job_fill_gen_trend_unadj)
egen mpred_job_fill_gen_u_06=mean(pred_job_fill_gen_u)
egen mpred_job_fill_gen_emp_06=mean(pred_job_fill_gen_emp)

egen mpred_job_fill_gen_uwant_06=mean(pred_job_fill_gen_uwant)

egen mpred_job_fill_u6a_06=mean(pred_job_fill_u6a)



egen mpred_job_fill_gen_u_unadj_06=mean(pred_job_fill_gen_u_unadj)

egen mRich=mean(Richmond_Tightness)
egen mu6=mean(u6_Tightness)
egen mRichp=mean(Richmond)
egen mu6p=mean(u6)

egen mjfru_G_06=mean(jfru_G)
egen mpred_std_jfru_G_06=mean(pred_std_jfru_G)
egen mpred_gen_jfru_G_06=mean(pred_gen_jfru_G)
egen mpred_std_jfru_ud_G_06=mean(pred_std_jfru_ud_G)

egen mpred_gen_jfru_NRI_G_06=mean(pred_gen_jfru_NRI_G)
egen mpred_gen_jfru_AG_06=mean(pred_gen_jfru_AG)
egen mpred_gen_jfru_SG_06=mean(pred_gen_jfru_SG)



keep job_fill_std_mean_06 mpred* mn mRich mu6 mRichp mu6p mjfr* mtight*
sort mn
keep if _n==1

merge 1:m mn using AHR_Baseline_Data2.dta


gen tightness_rich_06=tightness_rich/mtightness_rich_06
gen tightness_u6_06=tightness_u6/mtightness_u6_06



gen job_fill_std_06=job_fill_std/job_fill_std_mean_06
gen pred_job_fill_std_06=pred_job_fill_std/mpred_job_fill_std_06

gen pred_job_fill_std_aud_06=pred_job_fill_std_aud/mpred_job_fill_std_aud_06


gen pred_job_fill_gen_06=pred_job_fill_gen/mpred_job_fill_gen_06
gen pred_job_fill_gen_trend_06=pred_job_fill_gen_trend/mpred_job_fill_gen_trend_06

gen pred_job_fill_gen_gamma_06=pred_job_fill_gen_gamma/mpred_job_fill_gen_gamma_06
gen pred_job_fill_gen_trend_unadj_06=pred_job_fill_gen_trend_unadj/mpred_job_fill_gen_tr_unadj_06
gen pred_job_fill_gen_emp_06=pred_job_fill_gen_emp/mpred_job_fill_gen_emp_06
gen pred_job_fill_gen_u_06=pred_job_fill_gen_u/mpred_job_fill_gen_u_06

gen pred_job_fill_richa_06=pred_job_fill_richa/mpred_job_fill_richa_06
gen pred_job_fill_u6a_06=pred_job_fill_u6a/mpred_job_fill_u6a_06
gen pred_job_fill_gen_No_RI_06=pred_job_fill_gen_gamma_No_RI/mpred_job_fill_gen_No_RI_06
gen pred_job_fill_gen_u_unadj_06=pred_job_fill_gen_u_unadj/mpred_job_fill_gen_u_unadj_06
gen pred_job_fill_gen_uwant_06=pred_job_fill_gen_uwant/mpred_job_fill_gen_uwant_06

gen jfru_G_06=jfru_G/mjfru_G_06
gen pred_std_jfru_G_06=pred_std_jfru_G/mpred_std_jfru_G_06
gen pred_std_jfru_ud_G_06=pred_std_jfru_ud_G/mpred_std_jfru_ud_G_06
gen pred_gen_jfru_G_06=pred_gen_jfru_G/mpred_gen_jfru_G_06

gen pred_gen_jfru_NRI_G_06=pred_gen_jfru_NRI_G/mpred_gen_jfru_NRI_G_06
gen pred_gen_jfru_AG_06=pred_gen_jfru_AG/mpred_gen_jfru_AG_06
gen pred_gen_jfru_SG_06=pred_gen_jfru_SG/mpred_gen_jfru_SG_06


gen Richmond_Tightness_06=Richmond_Tightness/mRich
gen u6_Tightness_06=u6_Tightness/mu6
gen Richmond_06=Richmond/mRichp
gen u6_06=u6/mu6p


gen dev_std=(job_fill_std_06-pred_job_fill_std_06)^2

gen dev_std_aud=(job_fill_std_06-pred_job_fill_std_aud_06)^2

gen dev_gen_trend=(job_fill_std_06-pred_job_fill_gen_trend_06)^2
gen dev_gen=(job_fill_std_06-pred_job_fill_gen_06)^2

gen dev_gen_trend_unadj=(job_fill_std_06-pred_job_fill_gen_trend_unadj_06)^2

gen dev_gen_emp=(job_fill_std_06-pred_job_fill_gen_emp_06)^2
gen dev_gen_u=(job_fill_std_06-pred_job_fill_gen_u_06)^2

gen dev_gen_u_unadj=(job_fill_std_06-pred_job_fill_gen_u_unadj_06)^2
gen dev_gen_uwant=(job_fill_std_06-pred_job_fill_gen_uwant_06)^2

gen dev_richa=(job_fill_std_06-pred_job_fill_richa_06)^2

gen dev_u6a=(job_fill_std_06-pred_job_fill_u6a_06)^2


gen dev_std_jfru_G=(jfru_G_06-pred_std_jfru_G_06)^2
gen dev_std_jfru_ud_G=(jfru_G_06-pred_std_jfru_ud_G_06)^2
gen dev_gen_jfru_G=(jfru_G_06-pred_gen_jfru_G_06)^2

gen dev_gen_jfru_NRI_G=(jfru_G_06-pred_gen_jfru_NRI_G_06)^2
gen dev_gen_jfru_AG=(jfru_G_06-pred_gen_jfru_AG_06)^2
gen dev_gen_jfru_SG=(jfru_G_06-pred_gen_jfru_SG_06)^2

gen dev_gen_gamma=(job_fill_std_06-pred_job_fill_gen_gamma_06)^2
gen dev_gen_gamma_No_RI=(job_fill_std_06-pred_job_fill_gen_No_RI_06)^2

egen sdev_gen_trend_unadj=sum(dev_gen_trend_unadj)
egen sdev_dev_gamma_No_RI=sum(dev_gen_gamma_No_RI)

egen sdev_std_jfru_G=sum(dev_std_jfru_G) 
egen sdev_std_jfru_ud_G=sum(dev_std_jfru_ud_G) 
egen sdev_gen_jfru_G=sum(dev_gen_jfru_G)
 
egen sdev_gen_jfru_NRI_G=sum(dev_gen_jfru_NRI_G)
egen sdev_gen_jfru_AG=sum(dev_gen_jfru_AG)
egen sdev_gen_jfru_SG=sum(dev_gen_jfru_SG)


egen sdev_std=sum(dev_std)
egen sdev_std_aud=sum(dev_std_aud)




egen sdev_richa=sum(dev_richa)

egen sdev_gen_trend=sum(dev_gen_trend)
egen sdev_gen=sum(dev_gen)
egen sdev_rich=sum(dev_rich)
egen sdev_gen_emp=sum(dev_gen_emp)
egen sdev_gen_u=sum(dev_gen_u)

egen sdev_unadj=sum(dev_gen_trend_unadj)

egen sdev_gen_u_unadj=sum(dev_gen_u_unadj)
egen sdev_gen_uwant=sum(dev_gen_uwant)
egen sdev_u6a=sum(dev_u6a)

egen sdev_gen_gamma=sum(dev_gen_gamma)

gen nobs=1/312^0.5

gen rmse_std=nobs*sdev_std^0.5

gen rmse_std_aud=nobs*sdev_std_aud^0.5

gen rmse_gen_No_RI_New=nobs*sdev_dev_gamma_No_RI^0.5
gen rmse_unadj=nobs*sdev_unadj^0.5


gen rmse_std_jfruG=nobs*sdev_std_jfru_G^0.5
gen rmse_std_jfru_ud_G=nobs*sdev_std_jfru_ud_G^0.5
gen rmse_gen_jfruG=nobs*sdev_gen_jfru_G^0.5
gen rmse_gen_jfru_NRIG=nobs*sdev_gen_jfru_NRI_G^0.5
gen rmse_gen_jfruAG=nobs*sdev_gen_jfru_AG^0.5
gen rmse_gen_jfruSG=nobs*sdev_gen_jfru_SG^0.5

gen rmse_std_gen=nobs*sdev_gen^0.5

gen rmse_gen_trend=nobs*sdev_gen_trend^0.5
gen rmse_gen_trend_unadj=nobs*sdev_gen_trend_unadj^0.5

gen rmse_gen_gamma=nobs*sdev_gen_gamma^0.5

gen rmse_gen_emp=nobs*sdev_gen_emp^0.5
gen rmse_gen_u=nobs*sdev_gen_u^0.5

gen rmse_gen_u_unadj=nobs*sdev_gen_u_unadj^0.5
gen rmse_gen_uwant=nobs*sdev_gen_uwant^0.5
gen rmse_u6a=nobs*sdev_u6a^0.5


gen rmse_richa=nobs*sdev_richa^0.5

*RMSE for Tables 3 and 4 -- for the most part we don't report these statistics
summ rmse_std_aud rmse_gen_No_RI_New rmse_u6a rmse_richa 

summ rmse_std rmse_gen_u rmse_gen_uwant rmse_gen_emp rmse_gen_No_RI_New 

summ rmse_std_jfru_ud_G rmse_std_jfruG rmse_gen_jfru_NRIG

summ rmse_std_aud rmse_gen_No_RI_New rmse_gen_gamma rmse_gen_trend_unadj rmse_gen_trend

summ rmse_std_jfru_ud_G rmse_std_jfruG rmse_gen_jfru_NRIG rmse_gen_jfruG rmse_gen_jfruSG rmse_gen_jfruAG

*try pre 2001

replace nobs=1/(84^0.5)

egen sdev_std_pre2001=sum(dev_std) if Year<2001
egen sdev_gen_gamma_pre2001=sum(dev_gen_gamma_No_RI) if Year<2001

gen rmse_std_pre2001=nobs*sdev_std_pre2001^0.5
gen rmse_std_gen_gamma_pre2001=nobs*sdev_gen_gamma_pre2001^0.5

egen sdev_std_jfru_G_p01=sum(dev_std_jfru_G) if Year<2001
egen sdev_std_jfru_ud_G_p01=sum(dev_std_jfru_ud_G) if Year<2001
egen sdev_gen_jfru_G_p01=sum(dev_gen_jfru_G) if Year<2001


*RMSE for pre 2001 to compare to Barnichon
summ rmse_std_pre2001 rmse_std_gen_gamma_pre2001 


* try job filling rates

gen LaborTightness_06=LaborTightness_06_AHR

/*
	tsline LaborTightness_06 Generalized_Measure_u_06 Generalized_Measure_uwant_06 Generalized_Measure_emp_06 Generalized_Measure_gamma2_06  if date >=tm(1994m1), lcolor(red blue lime dkblue green ) lwidth(medthick medthick) lpattern(solid dash_dot longddash dash_dot shortdash) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) ylabel(0.2 (.4) 2.2, labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) legend(label(4 "Gen,U+OLF") label(2 "Gen,U only") label(3 "Gen,U+Want") label(1 "Std") label(5 "Gen,All")  ring(0) pos(2) col(5) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/Figure3.png",  replace	 

tsline LaborTightness_06 Generalized_Measure_gamma2_06  tightness_u6_06 tightness_rich_06  if date >=tm(1994m1), lcolor(red dkgreen purple orange ) lwidth(medthick medthick) lpattern(solid shortdash longdash dash) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) ylabel(0.2 (.4) 2.2, labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) legend(label(3 "U6") label(4 "Richmond") label(1 "Std") label(2 "Gen,All")  ring(0) pos(2) col(4) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/FigureA4.png",  replace	 		
	
*/	

tsline job_fill_std_06 pred_job_fill_std_06 pred_job_fill_gen_u_06 pred_job_fill_gen_uwant_06 pred_job_fill_gen_emp_06 pred_job_fill_gen_No_RI_06 if date >=tm(1994m1), lcolor(black red blue lime dkblue green) lwidth(medthick medthick) lpattern(longdash_dot solid dash_dot longddash dash_dot shortdash) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) ylabel(0 (.5) 2.5, labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) legend(label(4 "Gen,U+Want") label(3 "Gen,U") label(5 "Gen,U+OLF") label(1 "Actual") label(2 "Std(elas=0.57)") label(6 "All")  ring(0) pos(2) col(7) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/FigureA5.png",  replace	 	
		
		
tsline job_fill_std_06 pred_job_fill_std_06 pred_job_fill_gen_u_06 pred_job_fill_gen_uwant_06 pred_job_fill_gen_emp_06 pred_job_fill_gen_No_RI_06 if date >=tm(1994m1), ///
		lcolor(black red*1.25 "40 60 125" lavender*1.1 midgreen*1.1 midgreen*1.6) lwidth(medsmall medsmall medsmall medsmall medsmall med) lpattern("_#" solid vshortdash "-##.##" "-##-##" "-###") name(flows21,replace) /*
		*/tlabel(1998m1 (48) 2019m12,format(%tm) labsize(small)) yscale(range(0 2.3))  ylabel(.5 "0.5" 1 "1.0" 1.5 "1.5" 2 "2.0", tposition(inside) labsize(small))  /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ///
		legend(off) ttext(2.35 2010m1 "{it:{stSerif:Std(elas=0.57)}}", size(2.6) just(right) color(black)) ttext(2.15 2012m6 "{it:{stSerif:Gen, U only}}", size(2.6) just(right) color(black)) ///
		ttext(1.85 2013m12 "{it:{stSerif:Gen, U+Want}}", size(2.6) just(left) color(black)) ttext(1.55 2015m6 "{it:{stSerif:Gen, U+OLF}}", size(2.6) just(left) color(black)) ///
		ttext(1.25 2015m12 "{it:{stSerif:Gen, All}}", size(2.6) just(left) color(black))   ttext(.88 2012m6 "{it:{stSerif:Actual}}", size(2.6) just(left) color(black))
				graph save "$TeX/Graphs/FigureA5.gph",  replace	 
		capture graph export "$TeX/Graphs/FigureA5.emf",  replace	 	
		

		

		/*
tsline job_fill_std_06 pred_job_fill_std_aud_06 pred_job_fill_gen_No_RI_06  pred_job_fill_u6a_06 pred_job_fill_richa_06 if date >=tm(1994m1), lcolor(black red green purple orange) lwidth(medthick medthick) lpattern(longdash_dot solid shortdash longdash dash_dot) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) ylabel(0 (.5) 2.5, labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) legend(label(4 "Richmond") label(5 "U6") label(1 "Actual") label(2 "Std") label(3 "Gen,All")  ring(0) pos(2) col(6) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/Figure6.png",  replace

*summary stats reported in Table3

summ job_fill_std_06 pred_job_fill_std_aud_06 pred_job_fill_gen_No_RI_06  pred_job_fill_u6a_06 pred_job_fill_richa_06
pwcorr job_fill_std_06 pred_job_fill_std_aud_06 pred_job_fill_gen_No_RI_06  pred_job_fill_u6a_06 pred_job_fill_richa_06

summ 	job_fill_std_06 pred_job_fill_std_06 pred_job_fill_gen_u_06 pred_job_fill_gen_uwant_06 pred_job_fill_gen_emp_06 pred_job_fill_gen_No_RI_06	
pwcorr 	job_fill_std_06 pred_job_fill_std_06 pred_job_fill_gen_u_06 pred_job_fill_gen_uwant_06 pred_job_fill_gen_emp_06 pred_job_fill_gen_No_RI_06	
		
		

tsline job_fill_std_06 pred_job_fill_std_aud_06 pred_job_fill_gen_No_RI_06 pred_job_fill_gen_gamma_06 pred_job_fill_gen_trend_06 if date >=tm(1994m1), lcolor(black red green orange purple) lwidth(medthick medthick) lpattern(longdash_dot solid shortdash longdash dash_dot) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) ylabel(0 (.5) 2.5, labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) legend(label(4 "Gen,All+RI") label(5 "Gen,All+RI+SI") label(1 "Actual") label(2 "Std") label(3 "Gen,All")  ring(0) pos(2) col(6) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/Figure9.png",  replace	
 		
*statistics for Table 4
summ job_fill_std_06 pred_job_fill_std_aud_06 pred_job_fill_gen_No_RI_06 pred_job_fill_gen_gamma_06 pred_job_fill_gen_trend_unadj_06 pred_job_fill_gen_trend_06
pwcorr job_fill_std_06 pred_job_fill_std_aud_06 pred_job_fill_gen_No_RI_06 pred_job_fill_gen_gamma_06 pred_job_fill_gen_trend_unadj_06 pred_job_fill_gen_trend_06		

*/
		
gen norm_General_Denom_adj=norm_Gen_Denominator_AHR	
gen norm_General_Denom_trend_adj=norm_Gen_Denominator_trend_AHR	
gen norm_LT_Denominator_pop=norm_LT_Denominator_pop_AHR
gen norm_General_Denominator_gamma=norm_Gen_Denominator_gamma_AHR

/*

tsline norm_LT_Denom_2006 norm_Gen_Denom_g_2006 norm_Gen_Denom_trend_2006 if date >=tm(1994m1), lcolor(red green ebblue) lwidth(medthick medthick) lpattern(solid shortdash longdash dash) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ylabel(0 (1) 3, labsize(medsmall)) /*
		*/legend(label(3 "General,w/ time varying weights") label(1 "Standard") label(2 "General, All") ring(0) pos(2) col(3) size(small) symxsize(10))
		capture graph export "$TeX/Graphs/FigureA13.png",  replace				
	*/	

tsline norm_LT_Denom_2006 norm_Gen_Denom_u_2006 norm_Gen_Denom_uwant_2006 norm_Gen_Denom_emp_2006 norm_Gen_Denom_g_2006 if date >=tm(1994m1),  ///
		lcolor(red*1.25 "40 60 125" lavender*1.1 midgreen*1.1 midgreen*1.6) lwidth(medsmall medsmall medsmall medsmall med)  lpattern(solid vshortdash "-##.##" "--#-" "-##") name(flows2,replace) /*
		*/tlabel(1998m1 (48) 2019m12,format(%tm) labsize(small)) yscale(range(0 3))  ylabel(.5 "0.5" 1 "1.0" 1.5 "1.5" 2 "2.0" 2.5 "2.5", tposition(inside) labsize(small))  /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ///
		legend(off) ttext(2.2 2010m3 "{it:{stSerif:Std}}", size(2.6) just(right) color(black)) ttext(1.95 2013m12 "{it:{stSerif:Gen, U only}}", size(2.6) just(right) color(black)) ///
		ttext(1.75 2015m12 "{it:{stSerif:Gen, U+Want}}", size(2.6) just(left) color(black)) ttext(1.85 2006m8 "{it:{stSerif:Gen, U+OLF}}", size(2.6) just(left) color(black)) ///
		ttext(1.05 2012m1 "{it:{stSerif:Gen, All}}", size(2.6) just(left) color(black)) 
		graph save "$TeX/Graphs/FigureA1.gph",  replace	 
		

/*		
tsline norm_LT_Denom_2006 norm_Gen_Denom_g_2006 u6_06 Richmond_06 if date >=tm(1994m1), lcolor(red green purple orange) lwidth(medthick medthick) lpattern(solid shortdash longdash dash dash_dot) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ylabel(0 (1) 3, labsize(medsmall)) /*
		*/legend(label(1 "Std") label(4 "Richmond") label(2 "Gen,All") label(3 "U6") ring(0) pos(2) col(4) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/Figure2.png",  replace			
		
		
summ norm_LT_Denom_2006 norm_Gen_Denom_u_2006 norm_Gen_Denom_uwant_2006 norm_Gen_Denom_emp_2006 norm_Gen_Denom_g_2006 u6_06 Richmond_06	
pwcorr norm_LT_Denom_2006 norm_Gen_Denom_u_2006 norm_Gen_Denom_uwant_2006 norm_Gen_Denom_emp_2006 norm_Gen_Denom_g_2006 u6_06 Richmond_06	
*/
		tsline jfru_G_06 pred_std_jfru_ud_G_06 pred_gen_jfru_NRI_G_06 if date >=tm(1994m1), ///
		lcolor(black red*1.25 midgreen*1.6) lwidth(med med med)  lpattern("_#" solid "-##") name(flowsA9,replace) /*
		*/tlabel(1998m1 (48) 2019m12,format(%tm) labsize(small)) yscale(range(0 2))  ylabel(.5 "0.5" 1 "1.0" 1.5 "1.5", tposition(inside) labsize(small))  /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ///
		legend(off) ttext(1.6 2018m1 "{it:{stSerif:Std}}", size(2.6) just(right) color(black)) ///
		ttext(1.2 2010m6 "{it:{stSerif:Gen, All}}", size(2.6) just(left) color(black)) 	ttext(.5 2010m6 "{it:{stSerif:Actual}}", size(2.6) just(left) color(black)) 
		graph save "$TeX/Graphs/FigureA9.gph",  replace	
		capture graph export "$TeX/Graphs/FigureA9.emf",  replace
	
*Summary statistics for Table 3
summ jfru_G_06 pred_std_jfru_ud_G_06 pred_std_jfru_G_06 pred_gen_jfru_NRI_G_06
pwcorr jfru_G_06 pred_std_jfru_ud_G_06 pred_std_jfru_G_06 pred_gen_jfru_NRI_G_06

/*		
		
tsline jfru_G_06 pred_std_jfru_ud_G_06 pred_gen_jfru_NRI_G_06 pred_gen_jfru_G_06 pred_gen_jfru_AG_06 if date >=tm(1994m1), lcolor(black red green blue lime ebblue) lwidth(medthick medthick) lpattern(longdash_dot solid longdash dash dash_dot) name(flows2,replace) /*
		*/tlabel(1994m1 (48) 2019m12,format(%tm) labsize(medsmall)) /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ylabel(0 (1) 2, labsize(medsmall)) /*
		*/legend(label(3 "Gen, All") label(1 "Actual") label(2 "Standard") label(4 "Gen,All+RI") label(5 "Gen,All+RI+SI")ring(0) pos(2) col(5) size(small) symxsize(8))
		capture graph export "$TeX/Graphs/Figure10.png",  replace				

			
		
*Summary statistics for Table 4 		
summ jfru_G_06 pred_std_jfru_ud_G_06 pred_gen_jfru_NRI_G_06 pred_gen_jfru_G_06  pred_gen_jfru_SG_06  pred_gen_jfru_AG_06	
pwcorr	jfru_G_06 pred_std_jfru_ud_G_06 pred_gen_jfru_NRI_G_06 pred_gen_jfru_G_06 pred_gen_jfru_SG_06 pred_gen_jfru_AG_06 	
*/

log close
