* Code for Figures for Appendix D
*		
* ============================================================================ *

* Current Revised Version: 10-16-20


set more off
set linesize 100
clear matrix
clear


* ------------------------------------------------------------------------------
* FILE OPTION SPECIFICATIONS
* ------------------------------------------------------------------------------

global folder "INSERT PATH HERE"
		global path "${folder}/Data_Baseline/"
		global TeX 		"${folder}/Graphs_Appendix_D"
		
		cd "$path"

	
set scheme sol

log using Appendix_D.log, replace
		
		use AHR_Final_baseline_May_1.dta, clear
		
		
sort Year Month


gen employment_AHR=employed_AHR+employed_IPT_AHR
		
gen Generalized_Denom_emp = gamma_OLFO*nilf_other_AHR + gamma_OLFS*nilf_school_AHR +  gamma_OLFR*nilf_retired_AHR + gamma_OLFD*nilf_disabled_AHR +/*
								 */ gamma_WJO*wantjob_other_AHR + /*
								 */ gamma_WJD*wantjob_disc_AHR + /*
								 */ gamma_WJL*wantjob_looked_AHR + /*
								 */ gamma_RLO*onlayoff_5_AHR + /*
								 */ gamma_RLPJ*permjobloser_5_AHR + /*
								 */ gamma_TJEM*tempjobloser_5_AHR + /*
								 */ gamma_RQ*jobleavers_5_AHR +  /*
								 */ gamma_RE*newentrants_5_AHR +/*
								 */ gamma_RRE*reentrants_5_AHR +/* 
								 */ gamma_LM*onlayoff_M_AHR +/*
								 */ gamma_LPJM*permjobloser_M_AHR + /*
								 */ gamma_TJEM*tempjobloser_M_AHR + /*
								 */ gamma_QM*jobleavers_M_AHR + /*
								 */ gamma_EM*newentrants_M_AHR + /*
								 */ gamma_MRE*reentrants_M_AHR +/*
								 */ gamma_LTU*longterm_U_AHR

gen Generalized_Denom_uwant =       gamma_WJO*wantjob_other_AHR + /*
								 */ gamma_WJD*wantjob_disc_AHR + /*
								 */ gamma_WJL*wantjob_looked_AHR + /*
								 */ gamma_RLO*onlayoff_5_AHR + /*
								 */ gamma_RLPJ*permjobloser_5_AHR + /*
								 */ gamma_TJEM*tempjobloser_5_AHR + /*
								 */ gamma_RQ*jobleavers_5_AHR +  /*
								 */ gamma_RE*newentrants_5_AHR +/*
								 */ gamma_RRE*reentrants_5_AHR +/* 
								 */ gamma_LM*onlayoff_M_AHR +/*
								 */ gamma_LPJM*permjobloser_M_AHR + /*
								 */ gamma_TJEM*tempjobloser_M_AHR + /*
								 */ gamma_QM*jobleavers_M_AHR + /*
								 */ gamma_EM*newentrants_M_AHR + /*
								 */ gamma_MRE*reentrants_M_AHR +/*
								 */ gamma_LTU*longterm_U_AHR								 
								 
								 
gen Generalized_Denom_u = 		  gamma_RLO*onlayoff_5_AHR + /*
								 */ gamma_RLPJ*permjobloser_5_AHR + /*
								 */ gamma_TJEM*tempjobloser_5_AHR + /*
								 */ gamma_RQ*jobleavers_5_AHR +  /*
								 */ gamma_RE*newentrants_5_AHR +/*
								 */ gamma_RRE*reentrants_5_AHR +/* 
								 */ gamma_LM*onlayoff_M_AHR +/*
								 */ gamma_LPJM*permjobloser_M_AHR + /*
								 */ gamma_TJEM*tempjobloser_M_AHR + /*
								 */ gamma_QM*jobleavers_M_AHR + /*
								 */ gamma_EM*newentrants_M_AHR + /*
								 */ gamma_MRE*reentrants_M_AHR +/*
								 */ gamma_LTU*longterm_U_AHR								 
		
		
		

gen jfru_G=frate_U_GF

								 
								 
gen Generalized_Measure_emp   = Openings/Generalized_Denom_emp

gen Generalized_Measure_u   = Openings/Generalized_Denom_u

	
gen Generalized_Measure_uwant   = Openings/Generalized_Denom_uwant						 
								 
gen Generalized_Measure_u2   = Openings/Generalized_Denom_u

gen STU=Unemployed_All-longterm_U_AHR

gen STU_pop=STU/pop_AHR
gen LTU_pop=longterm_U_AHR/pop_AHR

gen LF=Unemployed_All+employed_AHR

gen mri_coeff=0.5*0.74

gen MRI=(Openings/employed_AHR)^mri_coeff


gen STU_LF=STU/LF
gen LTU_LF=longterm_U_AHR/LF
	 
		
		gen LaborTightness=LaborTightness_AHR
		*gen Generalized_Numerator=Generalized_Numerator_AHR
		gen Generalized_Denominator=Gen_Denominator_AHR
		
		gen norm_General_Denom_emp=Generalized_Denom_emp/pop_AHR
	    gen norm_General_Denom_u=Generalized_Denom_u/pop_AHR
        gen norm_General_Denom_uwant=Generalized_Denom_uwant/pop_AHR
	
	save "${path}\Hall_Analysis_Data_Final2.dta", replace

		
		
    use "${path}\Hall_Analysis_Data_Final2.dta", clear
	save "${path}\Final_Hall_Analysis_Data_AllVariables2.dta", replace




		use "${path}\Final_Hall_Analysis_Data_AllVariables2.dta", clear



* do some replacement

gen Generalized_Measure_trend=Gen_Measure_trend_AHR

gen Generalized_Measure_trend_06=Gen_Measure_trend_06_AHR

gen Generalized_Measure_gamma=Gen_Measure_gamma_AHR

gen Generalized_Measure_gamma_06=Gen_Measure_gamma_06_AHR


gen Generalized_Measure_06=Gen_Measure_06_AHR

gen Generalized_Denominator_trend=Gen_Denominator_trend_AHR

*gen Generalized_Denominator=Gen_Denominator_AHR

*gen Generalized_Numerator=Generalized_Numerator_AHR

*gen LaborTightness=LaborTightness_AHR

gen Unemployed_All=Unemployed_All_AHR
gen avg_agg_eta=avg_agg_eta_AHR

gen employment_sa=employment_AHR
gen population_16up=population_16up_AHR

gen IndexofRecruitingIntensitype=Recruiting_Intensity

gen Gen_Denominator_gamma=Gen_Denominator_gamma_AHR

gen Generalized_Measure_gamma2=Openings/Gen_Denominator_gamma_AHR

*These values are from Table B.2 where alpha=(1/(1+eta))

	gen eta = 0.75
	gen eta_ud = 1.04
	gen eta_u6 = 1.1
	gen eta_rich = 0.67
	
	 gen alpha=1/(1+eta)
	 gen alpha_ud=1/(1+eta_ud)
	 gen alpha_u6=1/(1+eta_u6)
	 gen alpha_rich=1/(1+eta_rich)
	 
	summ alpha*
	

gen job_fill_std=Hires/Openings
gen job_fill_EV=Hires/Generalized_Numerator
gen std_lhs=log(Hires/Openings)
gen std_rhs=log(Unemployed_All/Openings)
gen gen_rhs=log(Gen_Denominator_gamma/Openings)

reg std_lhs std_rhs
predict pjob_fill_std
gen aw=_b[std_rhs]
gen cw=_b[_cons]
gen p_std=exp(pjob_fill_std)

reg std_lhs gen_rhs
gen ag=_b[gen_rhs]
gen cg=_b[_cons]
predict pjob_fill_gen
gen p_gen=exp(pjob_fill_gen)

gen mer=1

save full.dta, replace

keep if Year==2006

egen jstd06=mean(job_fill_std)
egen pstd06=mean(p_std)
egen pgen06=mean(p_gen)

keep if _n==1

keep mer jstd06 pstd06 pgen06
merge 1:m mer using full.dta
drop _merge

gen jf_06=job_fill_std/jstd06
gen pjf_06=p_std/pstd06
gen pjfg_06=p_gen/pgen06

reg std_lhs std_rhs if Year<2008
predict pjob_fill_std2
gen aw7=_b[std_rhs]
gen cw7=_b[_cons]
gen p_std2=exp(pjob_fill_std2)

reg std_lhs gen_rhs if Year<2008
predict pjob_fill_gen2
gen ag7=_b[gen_rhs]

gen cg7=_b[_cons]

gen p_gen2=exp(pjob_fill_gen2)

save full.dta, replace

keep if Year==2006

egen pstd062=mean(p_std2)
egen pgen062=mean(p_gen2)

keep if _n==1

keep mer pstd062 pgen062
merge 1:m mer using full.dta
drop _merge

*gen jf_06=job_fill_std/jsd06
gen pjf_062=p_std2/pstd062
gen pjfg_062=p_gen2/pgen062	
		
		
		
tsline jf_06 pjf_062 pjfg_062 if date >=tm(1994m1), ///
		lcolor(black red*1.25 midgreen*1.6) lwidth(med med med)  lpattern("_#" solid "-##") name(flows2,replace) /*
		*/tlabel(1998m1 (48) 2019m12,format(%tm) labsize(small)) yscale(range(0 2))  ylabel(.5 "0.5"  1 "1"  1.5 "1.5", tposition(inside) labsize(small))  /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ///
		legend(off) ttext(1.6 2013m1 "{it:{stSerif:Std}}", size(2.6) just(right) color(black)) ///
		ttext(1.5 2007m6 "{it:{stSerif:Gen, All}}", size(2.6) just(left) color(black)) 	ttext(.85 2013m6 "{it:{stSerif:Actual}}", size(2.6) just(left) color(black)) 
		graph save "$TeX/Graphs/Figure_D_1.gph",  replace	
		capture graph export "$TeX/Graphs/Figure_D_1.png",  replace		
		
		
pwcorr job_fill_std p_std2 p_gen2 if Year>2007		
		
gen dev_std=(jf_06 - pjf_062)^2
gen dev_gen=(jf_06 - pjfg_062)^2
egen std_std=sum(dev_std) if Year>2007
egen std_gen=sum(dev_gen) if Year>2007
gen rmse_std=(std_std^0.50)/12
gen rmse_gen=(std_gen^0.5)/12
summ rmse_std rmse_gen	if Year>2007	

gen ew=(1/aw)-1
gen eg=(1/ag)-1
gen jfru_Gf=jfru_G/100
gen pred_std_hu=(1+ew)*cw+ew*log(Openings/Hires)
gen epred_std_hu=exp(pred_std_hu)
gen pred_gen_hu=(1+eg)*cg+eg*log(Openings/Hires)+log((Generalized_Denom_u/Unemployed_All))
gen epred_gen_hu=exp(pred_gen_hu)
pwcorr epred_std_hu jfru_Gf epred_gen_hu

save full.dta, replace
summ jfru*

keep if Year==2006

egen jfru_G06=mean(jfru_Gf)
egen ehu06=mean(epred_std_hu)
egen ehug06=mean(epred_gen_hu)

keep if _n==1
keep mer jfru_G06 ehu06 ehug06

merge 1:m mer using full.dta
drop _merge

gen jfru06=jfru_Gf/jfru_G06
gen ehustd06=epred_std_hu/ehu06
gen ehugen06=epred_gen_hu/ehug06
summ jfru*

gen dev_stdu=(jfru06 - ehustd06)^2
gen dev_genu=(jfru06 - ehugen06)^2
egen std_stdu=sum(dev_stdu) 
egen std_genu=sum(dev_genu) 
gen rmse_stdu=(std_stdu^0.50)/17.66

gen rmse_genu=(std_genu^0.5)/17.66

summ rmse_stdu rmse_genu	

	
		
replace aw7=0.25
replace ag7=0.44
replace cw7=log(0.83)
replace cg7=log(0.53)
		
		
		
gen ew7=(1/aw7)-1
gen eg7=(1/ag7)-1
*gen jfru_Gf=jfru_G/100
gen pred_std_hu7=(1+ew7)*cw7+ew7*log(Openings/Hires)
gen epred_std_hu7=exp(pred_std_hu7)
gen pred_gen_hu7=(1+eg7)*cg7+eg7*log(Openings/Hires)+log((Generalized_Denom_u/Unemployed_All))
gen epred_gen_hu7=exp(pred_gen_hu7)
pwcorr epred_std_hu7 jfru_Gf epred_gen_hu7

save full.dta, replace

keep if Year==2006

egen ehu067=mean(epred_std_hu7)
egen ehug067=mean(epred_gen_hu7)

keep if _n==1

keep mer ehu067 ehug067

merge 1:m mer using full.dta
drop _merge

gen ehustd067=epred_std_hu7/ehu067
gen ehugen067=epred_gen_hu7/ehug067

summ ehust* ehuge* jfru06
		
		
		
tsline jfru06 ehustd067 ehugen067 if date >=tm(1994m1), ///
		lcolor(black red*1.25 midgreen*1.6) lwidth(med med med)  lpattern("_#" solid "-##") name(flows2,replace) /*
		*/tlabel(1998m1 (48) 2019m12,format(%tm) labsize(small)) yscale(range(0 4))  ylabel(.5 "0.5"  1.5 "1.5"  2.5 "2.5"  3.5 "3.5", tposition(inside) labsize(small))  /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ///
		legend(off) ttext(3.6 2018m1 "{it:{stSerif:Std}}", size(2.6) just(right) color(black)) ///
		ttext(1.9 2012m6 "{it:{stSerif:Gen, All}}", size(2.6) just(left) color(black)) 	ttext(.5 2013m6 "{it:{stSerif:Actual}}", size(2.6) just(left) color(black)) 
		graph save "$TeX/Graphs/Figure_D_2.gph",  replace	 
		capture graph export "$TeX/Graphs/Figure_D_2.png",  replace
		

gen dev_stdu7=(jfru06 - ehustd067)^2
gen dev_genu7=(jfru06 - ehugen067)^2
egen std_stdu7=sum(dev_stdu7) 
egen std_genu7=sum(dev_genu7) 
gen rmse_stdu7=(std_stdu7^0.50)/17.66

gen rmse_genu7=(std_genu7^0.5)/17.66

summ rmse_stdu7 rmse_genu7				
		
	
* generate a Figure D3

reg std_lhs std_rhs if Year<2008
gen aw7a=_b[std_rhs]
gen cw7a=_b[_cons]

reg std_lhs gen_rhs if Year<2008
gen ag7a=_b[gen_rhs]
gen cg7a=_b[_cons]

gen ew7a=(1/aw7a)-1
gen eg7a=(1/ag7a)-1
*gen jfru_Gf=jfru_G/100
gen pred_std_hu7a=(1+ew7a)*cw7a+ew7a*log(Openings/Hires)
gen epred_std_hu7a=exp(pred_std_hu7a)
gen pred_gen_hu7a=(1+eg7a)*cg7a+eg7a*log(Openings/Hires)+log((Generalized_Denom_u/Unemployed_All))
gen epred_gen_hu7a=exp(pred_gen_hu7a)
pwcorr epred_std_hu7a jfru_Gf epred_gen_hu7a

save full.dta, replace

keep if Year==2006

egen ehu067a=mean(epred_std_hu7a)
egen ehug067a=mean(epred_gen_hu7a)

keep if _n==1

keep mer ehu067a ehug067a

merge 1:m mer using full.dta
drop _merge

gen ehustd067a=epred_std_hu7a/ehu067a
gen ehugen067a=epred_gen_hu7a/ehug067a

summ ehust* ehuge* jfru06

tsline jfru06 ehustd067a ehugen067a if date >=tm(1994m1), /// 
		lcolor(black red*1.25 midgreen*1.6) lwidth(med med med)  lpattern("_#" solid "-##") name(flows2,replace) /*
		*/tlabel(1998m1 (48) 2019m12,format(%tm) labsize(small)) yscale(range(0 2.75))  ylabel(.5 "0.5" 1 "1.0"  1.5 "1.5"  2 "2.0"  2.5 "2.5", tposition(inside) labsize(small))  /*
		*/ytitle("", size(medium) margin(1 2 1 1) ) xtitle("", size(medium)) ///
		legend(off) ttext(2.5 2018m1 "{it:{stSerif:Std}}", size(2.6) just(right) color(black)) ///
		ttext(1.5 2012m6 "{it:{stSerif:Gen, All}}", size(2.6) just(left) color(black)) 	ttext(.55 2013m6 "{it:{stSerif:Actual}}", size(2.6) just(left) color(black)) 
		graph save "$TeX/Graphs/Figure_D_3.gph",  replace	 
		capture graph export "$TeX/Graphs/Figure_D_3.png",  replace		

gen dev_stdu7a=(jfru06 - ehustd067a)^2
gen dev_genu7a=(jfru06 - ehugen067a)^2
egen std_stdu7a=sum(dev_stdu7a) if Year>2007
egen std_genu7a=sum(dev_genu7a) if Year>2007
gen rmse_stdu7a=(std_stdu7a^0.50)/12

gen rmse_genu7a=(std_genu7a^0.5)/12

summ rmse_stdu7a rmse_genu7a if Year>2007		
	
	
	

		
		log close

