% DATAPREP.M

% Add path of utilities
% -------------------------------------------------------------------------
addpath ../UTILITIES
addpath ./DATA_US/
% Load the data
% -------------------------------------------------------------------------
load dataUS
 

% Create the relevant variables
% -------------------------------------------------------------------------
dY_o  = diff(log(Y));
dP_o  = diff(log(PGDP));
dW_o  = diff(log(WAGE));
R_o   = FF(2:end);
qdate = qdate(2:end);

figure ;plot(qdate,dY_o); title('Growth rate 1 ');grid on;
% Restricts the sample
% -------------------------------------------------------------------------
si    = find(qdate==1985.00);
fi    = find(qdate==2015.75);
smpl  = si:fi;
dY_o  = 100*dY_o(smpl);
dP_o  = 100*dP_o(smpl);
dW_o  = 100*dW_o(smpl);
R_o   = R_o(smpl);
qdate = qdate(smpl);


figure ;plot(qdate,dY_o); title('Growth rate 2 ');grid on;

% Save the data
% -------------------------------------------------------------------------
save('estimationUSData',...
    'dY_o',...
    'dP_o',...
    'dW_o',...
    'R_o',...
    'qdate')


figure ;plot(qdate,R_o); title('Fed Funds rate');grid on;
figure ;plot(qdate,dP_o); title('Inflation');grid on;
figure ;plot(qdate,dW_o); title('Compensation');grid on;
figure ;plot(qdate,dY_o); title('Growth rate');grid on;
