addpath ../../UTILITIES

%  Desired sample for final Dataset
sample_start    =1960.0;
sample_end      =2017.0;
date= (sample_start:0.25:sample_end);

%   GDP  SERIES 
%------------------------------------------------------------------------
[xx,tt]= xlsread('./GDPC1.xls') ;
x_sample_start    =1947.0;          %% A renseigenr manuellement

x_sample_end     =x_sample_start+ (length(xx)-1)/4;
x_date= (x_sample_start:0.25:x_sample_end);
si  = find(x_date==floor(sample_start)) ;
fi  = find(x_date==floor(sample_end  )) ;

%Cylindring to sample_start sample_end
GDP  = xx(si:fi) ;

%Plotting
figure; plot(date,GDP); title('GDP');


%   POP  SERIES  Civilian Noninstitutional Population, Thousands of Persons, Monthly, Not Seasonally Adjusted
%------------------------------------------------------------------------
[xx,tt]= xlsread('./CNP16OV.xls') ;
x_sample_start    =1948.0;          %% A renseigenr manuellement

xx = myconvert(xx,12,4) ;
%Convert to monthly
%freq=4 for quarterly data and freq=12    for monthly.

x_sample_end     =x_sample_start+ (length(xx)-1)/4;
x_date= (x_sample_start:0.25:x_sample_end);
si  = find(x_date==floor(sample_start)) ;
fi  = find(x_date==floor(sample_end  )) ;

%Cylindring to sample_start sample_end
POP  = xx(si:fi) ;

%Plotting
figure; plot(date,POP); title('POP');


% SERIES GDP per capita
Y = GDP./POP;


%------------------------------------------------------------------------
%   GDP  DEFLATOR SERIES 
%------------------------------------------------------------------------
[xx,tt]= xlsread('./GDPDEF.xls') ;
x_sample_start    =1947.0;          %% A renseigenr manuellement

x_sample_end     =x_sample_start+ (length(xx)-1)/4;
x_date= (x_sample_start:0.25:x_sample_end);
si  = find(x_date==floor(sample_start)) ;
fi  = find(x_date==floor(sample_end  )) ;

%Cylindring to sample_start sample_end
PGDP  = xx(si:fi) ;

%Plotting
figure; plot(date(2:end),400*log( PGDP(2:end)./PGDP(1:end-1)  )); title('GDP deflator');grid on;


%------------------------------------------------------------------------
%   WAGE SERIES  Hourly Compensation
%------------------------------------------------------------------------
[xx,tt]= xlsread('./DataFinder-20170517055756.xlsx') ;
x_sample_start    =1947.0;          %% A renseigenr manuellement

x_sample_end     =x_sample_start+ (length(xx)-1)/4;
x_date= (x_sample_start:0.25:x_sample_end);
si  = find(x_date==floor(sample_start)) ;
fi  = find(x_date==floor(sample_end  )) ;

%Cylindring to sample_start sample_end
WAGE  = xx(si:fi) ;

%Plotting
figure; plot(date(2:end),400*log( WAGE(2:end)./WAGE(1:end-1)  )); title('Hourly Compensation');grid on;
figure; plot(date(5:end),100*log( WAGE(5:end)./WAGE(1:end-4)  )); title('Hourly Compensation');grid on;


%------------------------------------------------------------------------
%   FEd Funds Monthly data
%------------------------------------------------------------------------
[xx,tt]= xlsread('./FEDFUNDS.xls') ;
x_sample_start    =1954.50;          %% A renseigenr manuellement

xx = myconvert(xx,12,4) ;
%Convert to monthly
%freq=4 for quarterly data and freq=12    for monthly.

x_sample_end     =x_sample_start+ (length(xx)-1)/4;
x_date= (x_sample_start:0.25:x_sample_end);
si  = find(x_date==floor(sample_start)) ;
fi  = find(x_date==floor(sample_end  )) ;

%Cylindring to sample_start sample_end
FF = xx(si:fi) ;

%Plotting
figure; plot(date,FF); title('Fed Funds rate');


qdate=date;
%%To be saved

save dataUS Y PGDP WAGE FF qdate