% ReadStateData.m
%
%   Reads/merges the state Unemployment data, Google Activity data,
%   and Covid Deaths
%
%   8/29/20: Put cumulative numbers in units of "Percent Years" for
%            easy interpretation

clear all; close all;
diarychad('ReadStateData');

fname='../Data/State_Unemployment_Rates.xls';

% Start in February to match up with deaths
URnames=readmatrix(fname,'Sheet','Monthly','Range','B1:AZ1','OutputType','char');
URdates=readmatrix(fname,'Sheet','Monthly','Range','A3:A9','OutputType','char');
URdata  =readmatrix(fname,'Sheet','Monthly','Range','B3:AZ9'); 

FirstDate=datetime('2020-01','InputFormat','yyyy-MM');
URdates=FirstDate+calmonths(0:(size(URdata,1)-1))';

% Cumulative unemployment-months lost
bb=minus(URdata,URdata(1,:)); % deviation from Feb 2020
%URcumulative=cumsum(bb);     % cumulative unemployment-months lost
URcumulative=cumsum(bb)/12;   % cumulative unemployment percent-years


load CovidData


% Gather the latest deaths per million cumulative
% Deaths from the 15th of each month
MonthDates=datetime({'2020-Feb-15','2020-Mar-15','2020-Apr-15','2020-May-15','2020-Jun-15','2020-Jul-15','2020-Aug-15','2020-Sep-15'});
for t=1:length(MonthDates);
  MonthDates_indx(t)=find(datenum(CovidDates)==datenum(MonthDates(t)));
end;
T=length(MonthDates);

Nstates=length(URnames);
URdeaths=zeros(T,Nstates)*NaN;
URpop=zeros(1,Nstates)*NaN;
for i=1:Nstates;
  URnames{i}=URnames{i}(1:2);
  if exist(URnames{i});
    URdeaths(:,i)=CovidDeathsPerMillion(MonthDates_indx,eval(URnames{i}));
    URdeathsLatest(i)=CovidDeathsPerMillion(end,eval(URnames{i}));
    URpop(i)   =CovidPop(eval(URnames{i}));
  end;
end;

% indx = sort states by population
[~,SortedbyPop]=sort(URpop,'descend');

fmt='%10.1f %10.1f %10.1f %10.1f %10.0f %10.0f %10.0f';
URratio=URdata(end,:)./URdata(1,:)*100;
tle='URFeb URApr URJune Ratio dthFeb dthApr dthJun';
cshow(URnames,[URdata([1 3 5],:)' URratio' URdeaths([1 3 5],:)'],fmt,tle);

clear indx i fmt tle t bb fname;
save StateUnempCovid;

diary off;
