% ReadGoogleCountries.m
%
%  Reads the Google Covid-19 Activity Tracker data from the .csv file


clear all; close all;
diarychad('ReadGoogleCountries');

% Read the csv file
% This doesn't work for some reason.
% Use the "Home -> Import Tool" instead. That works. Then save table.
% Note: be sure to change "sub_region_1" and "sub_region_2" to "text" types
%  -- Keep codes/names as "category"
load GlobalMobilityReport
G=GlobalMobilityReport;
%G=readtable('../Data/Global_Mobility_Report.csv'); %,'Sheet','Data');
summary(G)
varnames=fieldnames(summary(G))


%%% COUNTRY DATA

% Delete the regions
iscountry = G.sub_region_1=="" & G.sub_region_2=="" & G.metro_area=="";
sum(iscountry)
G(~iscountry,:)=[];

% Notice that some countries don't have the maximum data -- omit those!
summary(G)
s=summary(G);
T=max(s.country_region.Counts)
dropcountries= (s.country_region.Counts~=T);
disp 'Dropping these countries -- missing data:'
names2drop=s.country_region.Categories(dropcountries)

for i=1:length(names2drop);
  dropit= G.country_region==names2drop(i);
  G(dropit,:)=[];
end;
summary(G)


% Find the dates of the data
GoogleDates=datetime(G.date);
GoogleDates=GoogleDates(1:T);
NumCtys=length(G.date)/T

% Restructure each variables as a matrix with dimension: NumYears x NumCtys
for i=1:length(varnames);
  eval([varnames{i} '=reshape(G.' varnames{i} ',T,NumCtys);']);
end;

% Assign names and codes to NumCtys x 1 vectors
GoogleNames=cellstr(country_region(1,:)');
GoogleCodes=cellstr(country_region_code(1,:)');
%% for i=1:NumCtys;
%%   GoogleCodes{i}=GoogleCodes{i}(4:5);
%% end;

% Create three-letter codes that point to the appropriate column for
% each country. E.g. gUS=1 and gCA=6, where the g stands for Google
for i=1:length(GoogleCodes);
  eval(['c' GoogleCodes{i} '=i;']);
end;

% Compute monthly averages of the Google Activity Tracker data
for m=2:9; % Months: February to September
  indx=find(GoogleDates.Month==m);
  retail_and_rec(m,:)=mean(retail_and_recreation_percent_change_from_baseline(indx,:));
  grocery(m,:)=mean(grocery_and_pharmacy_percent_change_from_baseline(indx,:));
  parks(m,:)=mean(parks_percent_change_from_baseline(indx,:));
  transit(m,:)=mean(transit_stations_percent_change_from_baseline(indx,:));
  workplace(m,:)=mean(workplaces_percent_change_from_baseline(indx,:));
  residential(m,:)=mean(residential_percent_change_from_baseline(indx,:));
end;

% Average of retail_and_recreation and workplace activity
GoogleCountryActivity=.5*(retail_and_rec+workplace);

disp ' '; disp ' ';
disp 'GoogleActivity measure:'
disp ' -- average of the Retail_and_Recreation and Workplace variables'
tle='Jan Feb Mar Apr May Jun Jul Aug Sep';
cshow(GoogleNames,[GoogleCountryActivity'],'%8.0f %8.1f',tle);



KeepCtys=readmatrix('../Data/GoogleCountrySummary.xlsx','Range','C7:C132');
Country3Codes=readmatrix('../Data/GoogleCountrySummary.xlsx','Range','D7:D132','OutputType','char');

clear i m indx T;
CountryDates=GoogleDates;
save GoogleCountryData;


%cshow(GoogleNames,[KeepCtys GoogleCountryActivity'],'%8.0f %8.1f',tle);

diary off;


