% ReadGoogleCountries.m
%
%  Reads the Google Covid-19 Activity Tracker data from the .csv file


clear all; close all;
diarychad('ReadGoogleCities');

% Read the csv file
% This doesn't work for some reason.
% Use the "Home -> Import Tool" instead. That works. Then save table.
% Note: be sure to change "sub_region_1" and "sub_region_2" to "text" types
%  -- Keep codes/names as "category"
load GlobalMobilityReport
G=GlobalMobilityReport;
%G=readtable('../Data/Global_Mobility_Report.csv'); %,'Sheet','Data');
summary(G)
varnames=fieldnames(summary(G))

%%% KEY GLOBAL CITIES
% NYC (36061), Los Angeles (06037), SF (06075), London, Paris (FR-75),
% Boston (25025), Milan, Madrid (ES-MD), Stockholm (SE-AB).
% Seoul Metropolitan Area, Tokyo (JP-13)

% Create index of key cities
indx=[];
indx=[indx; find(G.census_fips_code=="36061")]; % NYC
TT=length(indx); % Save for Greater London below
indx=[indx; find(G.census_fips_code=="25025")]; % Boston
indx=[indx; find(G.census_fips_code=="06037")]; % Los Angeles
indx=[indx; find(G.census_fips_code=="06075")]; % San Francisco
indx=[indx; find(G.census_fips_code=="12086")]; % Miami
indx=[indx; find(G.census_fips_code=="17031")]; % Chicago (Cook)
indx=[indx; find(G.census_fips_code=="48201")]; % Houston (Harris County)
ii=find(G.sub_region_1=="Greater London"); % London
ii=ii(1:TT); 
indx=[indx; ii]; % London added more sub-regions
indx=[indx; find(G.iso_3166_2_code=="FR-75")]; % Paris, Ile d'France
indx=[indx; find(G.iso_3166_2_code=="IT-25")]; % Lombardy
indx=[indx; find(G.iso_3166_2_code=="ES-MD")]; % Madrid
indx=[indx; find(G.iso_3166_2_code=="SE-AB")]; % Stockholm
indx=[indx; find(G.iso_3166_2_code=="JP-13")]; % Tokyo
indx=[indx; find(G.metro_area=="Seoul Metropolitan Area")]; % Seoul

% Delete the regions
KeepIt=indx;
sum(KeepIt)
NewTab=G(KeepIt,:);
OldTab=G;
G=NewTab;

% Notice that some countries don't have the maximum data -- omit those!
summary(G)
s=summary(G);

T=datenum(max(G.date))-datenum(min(G.date))+1
%dropcountries= (s.country_region.Counts~=T);
%disp 'Dropping these countries -- missing data:'
%names2drop=s.country_region.Categories(dropcountries);
%
%for i=1:length(names2drop);
%  dropit= G.country_region==names2drop(i);
%  G(dropit,:)=[];
%end;
summary(G)


% Find the dates of the data
GoogleDates=datetime(G.date);
GoogleDates=GoogleDates(1:T);
NumCities=length(G.date)/T

% Restructure each variables as a matrix with dimension: NumYears x NumCities
for i=1:length(varnames);
  eval([varnames{i} '=reshape(G.' varnames{i} ',T,NumCities);']);
end;



%% % Assign names and codes to NumCities x 1 vectors
%% GoogleNames=cellstr(country_region(1,:)');
%% GoogleCodes=cellstr(country_region_code(1,:)');
%% for i=1:NumCities;
%%   GoogleCodes{i}=GoogleCodes{i}(4:5);
%% end;


% Compute monthly averages of the Google Activity Tracker data
for m=2:9; % Months: February to September
  indx=find(GoogleDates.Month==m);
  retail_and_rec(m,:)=mean(retail_and_recreation_percent_change_from_baseline(indx,:));
  grocery(m,:)=mean(grocery_and_pharmacy_percent_change_from_baseline(indx,:));
  parks(m,:)=mean(parks_percent_change_from_baseline(indx,:));
  transit(m,:)=mean(transit_stations_percent_change_from_baseline(indx,:));
  workplace(m,:)=mean(workplaces_percent_change_from_baseline(indx,:));
  residential(m,:)=mean(residential_percent_change_from_baseline(indx,:));
end;

% Average of retail_and_recreation and workplace activity
GoogleCityActivity=.5*(retail_and_rec+workplace);

dname='../Data/GoogleCitySummary.xlsx'
GoogleCityCodes=readmatrix(dname,'Range','B9:B22','OutputType','char');
GoogleCityNames=readmatrix(dname,'Range','C9:C22','OutputType','char');

% Create three-letter codes that point to the appropriate column for
% each country. E.g. gUS=1 and gCA=6, where the g stands for Google
for i=1:length(GoogleCityCodes);
  eval(['g' GoogleCityCodes{i} '=i;']);
end;

clear i m indx T;
CityDates=GoogleDates;
save GoogleCityData;

disp ' '; disp ' ';
disp 'GoogleActivity measure:'
disp ' -- average of the Retail_and_Recreation and Workplace variables'
tle='Jan Feb Mar Apr May Jun Jul Aug Sep';
cshow(GoogleCityNames,[GoogleCityActivity'],'%8.1f',tle);

diary off;


