% PlotStates.m
%
%   Plot Unemp loss and Google Activity versus Covid deaths for U.S. states
%
%   8/29/20: Put cumulative numbers in units of "Percent Years" for
%            easy interpretation

clear all; close all;
diarychad('PlotStates');

load StateUnempCovid;
load GoogleStateData;
GoogleCodes=StateCodes;

% The ordering is different in the two data sets
%   - UR is alphabetical by code
%   - Google is alphabetical by name
% So we need to merge on the codes
% [URnames' GoogleNames(2:end)]

Tunemp=cell2table(URnames');
Tunemp.Properties.VariableNames{'Var1'}='Codes';
Tgoogle=table(cellstr(GoogleCodes)); %cell2table(GoogleCodes);
%Tgoogle.Properties.VariableNames{'GoogleCodes'}='Codes';
Tgoogle.Properties.VariableNames{'Var1'}='Codes';
[T,iright]=join(Tunemp,Tgoogle);

% iright now has the indexes to the Google data to put in the unemp order
%    Also 2:end starts in February instead of January to match Unemp
%    And take the negative so that it is a "loss"
GoogleLevel=-GoogleStateActivity(2:end,iright); 
%GoogleCumulative=cumsum(GoogleLevel);
GoogleCumulative=cumsum(GoogleLevel)/12;    % "Percent years" units

% Create State Codes to access this order
for i=1:size(T,1);
  eval([char(T{i,:}) '=i;']);
end;

disp ' ';
disp 'NOTE: TotalA is annualized, so units are Percent-Years';
disp '      i.e. a 5 percent cumulative number is the equivalent of';
disp '      losing 5 percent a one-years GDP.'
disp ' ';


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Graph UnempLoss versus Google Activity. How strongly are they correlated?
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(2); figsetup;
addols=1;
plotnamesym2(GoogleCumulative(end,:)',URcumulative(end,:)',URnames,12,[],.8,.01,[],addols,myblue*1.1);
chadfig2('Google Cumulative Reduced Activity (percent years)',...
	 'Cumulative Excess Unemployment (percent years)',1,0)
makefigwide;
print PlotStatesUnempGoogle.eps

blah1=[GoogleCumulative(end,:)' URcumulative(end,:)'];
blah2=blah1;
blah2(8,:)=[]; % Drop "DC" as an outlier
corr1=corrcoef(blah1);
corr2=corrcoef(blah2);
fprintf('   The correlation for all states is %5.2f\n',corr1(1,2));
fprintf('   The correlation omitting DC    is %5.2f\n',corr2(1,2));



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Key Graphs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Groups of states to plot
Groups.Small = [NY DC CA PA MA NJ WA MI];
%Groups.Big = [FL TX AZ GA VA NC OH KY MT AL SD];
Groups.Big = [FL TX AZ GA MT AL SD];
Groups.Both  = [Groups.Small Groups.Big];

% Unemployment Graphs
MakeKeyPlots(URdata,URdeaths,URcumulative,URdeathsLatest,URnames,Groups,...
	       'Unemployment','PlotStatesUR');  
wait;

% Google Activity Graphs
MakeKeyPlots(GoogleLevel,URdeaths,GoogleCumulative,URdeathsLatest,URnames,Groups,...
	       'Reduced Activity','PlotStatesGoogle');

diary off


