% PlotGoogleStates.m
%
%   US States: Show Google activity data by category over time for special cases

clear all; close all;
diarychad('PlotGoogleStates');

hpparam=400
definecolors
lw=2;

% First plot the countries, to load that data for joint plots
PlotGoogleCountries

% Now plot states
load GoogleStateData;
retrec_st   =retail_and_recreation_percent_change_from_baseline;
groc_st     =grocery_and_pharmacy_percent_change_from_baseline; 
parks_st    =parks_percent_change_from_baseline;                
transit_st  =transit_stations_percent_change_from_baseline;     
work_st     =workplaces_percent_change_from_baseline;           
home_st     =residential_percent_change_from_baseline;          

StateActivity_t = .5*(retrec_st+work_st);


figure(2); figsetup; makefigwide;
for i=2:NumStates;
  plot(StateDates,hpfilter(StateActivity_t(:,i),hpparam),'Color',mygrey,'LineWidth',1);
end;
plot(StateDates,zeros(size(StateDates)),'--','Color','k','LineWidth',1);
plot(StateDates,hpfilter(StateActivity_t(:,sCA),hpparam),'Color',mygreen,'LineWidth',lw);
plot(StateDates,hpfilter(StateActivity_t(:,sNY),hpparam),'Color',myblue,'LineWidth',lw);
plot(StateDates,hpfilter(StateActivity_t(:,sAZ),hpparam),'Color',myred,'LineWidth',lw);
plot(StateDates,hpfilter(StateActivity_t(:,sTX),hpparam),'Color',mypurp,'LineWidth',lw);
plot(StateDates,hpfilter(StateActivity_t(:,sFL),hpparam),'Color',myorng,'LineWidth',lw);
%plot(StateDates,hpfilter(StateActivity_t(:,s),hpparam),'Color',my,'LineWidth',lw);
text(datetime('2020-May-10'),-53,'New York');
text(datetime('2020-Jul-15'),-38,'California');
text(datetime('2020-Jun-01'),-16,'Texas');
text(StateDates(end)+2,-30,'Arizona');
text(StateDates(end)+2,-27,'Florida');
text(StateDates(end)-5,-52,'D.C.','Color',[mygrey 0.75]);
ylabel('Percent change relative to baseline');
print GoogleStates.eps


% Select States and Countries on the same graph
figure(3); figsetup; makefigwide;
plot(CountryDates,zeros(size(CountryDates)),'--','Color','k','LineWidth',1);
plot(StateDates,hpfilter(StateActivity_t(:,sCA),hpparam),'Color',myred,'LineWidth',lw);
plot(StateDates,hpfilter(StateActivity_t(:,sNY),hpparam),'Color',myblue,'LineWidth',lw);
%plot(StateDates,hpfilter(StateActivity_t(:,sAZ),hpparam),'Color',myred,'LineWidth',lw);
%plot(StateDates,hpfilter(StateActivity_t(:,sTX),hpparam),'Color',mypurp,'LineWidth',lw);
plot(StateDates,hpfilter(StateActivity_t(:,sFL),hpparam),'Color',myorng,'LineWidth',lw);
text(datetime('2020-Jun-13'),-37,'New York','FontSize',14);
text(datetime('2020-Aug-02'),-37,'California');
%text(datetime('2020-Jun-01'),-16,'Texas');
%text(StateDates(end)+2,-30,'Arizona');
text(datetime('2020-Jul-15'),-25,'Florida');

plot(CountryDates,hpfilter(CountryActivity_t(:,cIT),hpparam),'Color',mygreen,'LineWidth',lw);
%plot(CountryDates,hpfilter(CountryActivity_t(:,cUS),hpparam),'Color',myblue,'LineWidth',lw);
%plot(CountryDates,hpfilter(CountryActivity_t(:,cES),hpparam),'Color',myred,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cGB),hpparam),'Color',mypurp,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cDE),hpparam),'Color',mypurp,'LineWidth',lw);

%plot(CountryDates,hpfilter(CountryActivity_t(:,c),hpparam),'Color',my,'LineWidth',lw);
text(datetime('2020-Feb-18'),-40,'Italy');
%text(datetime('2020-Apr-01'),-40,'U.S.');
%text(datetime('2020-May-04'),-77,'Spain');
text(datetime('2020-Jun-01'),-60,'U.K.');
text(datetime('2020-Jun-22'),-7,'Germany');
ylabel('Percent change relative to baseline');
print GoogleStatesCountries.eps


diary off
