% PlotGoogleCountries.m
%
%   Show Google activity data by category over time for special cases

clear all; close all;
diarychad('PlotGoogleCountries');

hpparam=400
definecolors
lw=2;

load GoogleCountryData;
retrec_ct   =retail_and_recreation_percent_change_from_baseline;
groc_ct     =grocery_and_pharmacy_percent_change_from_baseline; 
parks_ct    =parks_percent_change_from_baseline;                
transit_ct  =transit_stations_percent_change_from_baseline;     
work_ct     =workplaces_percent_change_from_baseline;           
home_ct     =residential_percent_change_from_baseline;          

CountryActivity_t = .5*(retrec_ct+work_ct);

figure(1); figsetup; makefigwide;
for i=2:NumCtys;
  if KeepCtys(i);
    plot(CountryDates,hpfilter(CountryActivity_t(:,i),hpparam),'Color',[mygrey .7],'LineWidth',1);
  end;
end;
plot(CountryDates,zeros(size(CountryDates)),'--','Color','k','LineWidth',1);
plot(CountryDates,hpfilter(CountryActivity_t(:,cIT),hpparam),'Color',mygreen,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cUS),hpparam),'Color',myblue,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cES),hpparam),'Color',myred,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cGB),hpparam),'Color',mypurp,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cDE),hpparam),'Color',myorng,'LineWidth',lw);

%plot(CountryDates,hpfilter(CountryActivity_t(:,c),hpparam),'Color',my,'LineWidth',lw);
text(datetime('2020-Feb-18'),-40,'Italy');
text(datetime('2020-Apr-01'),-40,'U.S.');
text(datetime('2020-May-04'),-77,'Spain');
text(datetime('2020-Jun-01'),-60,'U.K.');
text(datetime('2020-Jun-22'),-5,'Germany');
%text(datetime('2020-May-'),-75,'');
%text(CountryDates(end)+2,-30,');
%text(CountryDates(end)-5,-52,'','Color',[mygrey 0.75]);
ylabel('Percent change relative to baseline');
print GoogleCountries.eps


figure(2); figsetup; makefigwide;
for i=2:NumCtys;
  if KeepCtys(i);
    plot(CountryDates,hpfilter(CountryActivity_t(:,i),hpparam),'Color',[mygrey .7],'LineWidth',1);
  end;
end;
plot(CountryDates,zeros(size(CountryDates)),'--','Color','k','LineWidth',1);
plot(CountryDates,hpfilter(CountryActivity_t(:,cDK),hpparam),'Color',mygreen,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cNO),hpparam),'Color',myblue,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cSE),hpparam),'Color',myred,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cDE),hpparam),'Color',mypurp,'LineWidth',lw);
plot(CountryDates,hpfilter(CountryActivity_t(:,cUS),hpparam),'Color',myorng,'LineWidth',lw);

%plot(CountryDates,hpfilter(CountryActivity_t(:,c),hpparam),'Color',my,'LineWidth',lw);
text(datetime('2020-Jul-08'),-5,'Denmark');
text(datetime('2020-May-25'),-35,'U.S.');
text(datetime('2020-May-04'),-77,'Spain','Color',[mygrey .8]);
text(datetime('2020-Apr-15'),-15,'Sweden');
text(datetime('2020-Feb-15'),-30,'Norway');
text(datetime('2020-Apr-19'),-52,'Germany');
%text(datetime('2020-May-'),-75,'');
%text(CountryDates(end)+2,-30,');
%text(CountryDates(end)-5,-52,'','Color',[mygrey 0.75]);
ylabel('Percent change relative to baseline');
print GoogleCountriesSWE.eps




diary off
