% PlotGoogleCities.m
%
%   Show Google activity data by category over time for special cases

clear all; close all;
diarychad('PlotGoogleCities');

hpparam=400
definecolors
lw=2;

load GoogleCityData;
retrec_ct   =retail_and_recreation_percent_change_from_baseline;
groc_ct     =grocery_and_pharmacy_percent_change_from_baseline; 
parks_ct    =parks_percent_change_from_baseline;                
transit_ct  =transit_stations_percent_change_from_baseline;     
work_ct     =workplaces_percent_change_from_baseline;           
home_ct     =residential_percent_change_from_baseline;          

CityActivity_t = .5*(retrec_ct+work_ct);

figure(1); figsetup; makefigwide;
for i=1:NumCities;
    plot(CityDates,hpfilter(CityActivity_t(:,i),hpparam),'Color',[mygrey .7],'LineWidth',1);
end;
plot(CityDates,zeros(size(CityDates)),'--','Color','k','LineWidth',1);
plot(CityDates,hpfilter(CityActivity_t(:,gPIF),hpparam),'Color',[mygrey .7],'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gLOM),hpparam),'Color',mygreen,'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gNYC),hpparam),'Color',myblue,'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gMAD),hpparam),'Color',myred,'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gLON),hpparam),'Color',mypurp,'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gTOK),hpparam),'Color',myorng,'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gSTK),hpparam),'Color',.7*myred,'LineWidth',lw);
plot(CityDates,hpfilter(CityActivity_t(:,gSEO),hpparam),'Color',.7*myblue,'LineWidth',lw);

%plot(CityDates,hpfilter(CityActivity_t(:,c),hpparam),'Color',my,'LineWidth',lw);
text(datetime('2020-Feb-07'),-40,'Lombardy');
text(datetime('2020-Jul-15'),-65,'NYC');
text(datetime('2020-May-04'),-80,'Madrid');
text(datetime('2020-Jul-15'),-50,'London');
text(datetime('2020-Jun-11'),-15,'Stockholm');
text(datetime('2020-Aug-01'),-5,'Seoul');
text(datetime('2020-Mar-31'),-20,'Tokyo');
text(datetime('2020-Apr-15'),-90,'Paris');
%text(datetime('2020-May-'),-75,'');
%text(CityDates(end)+2,-30,');
%text(CityDates(end)-5,-52,'','Color',[mygrey 0.75]);
ylabel('Percent change relative to baseline');
print GoogleCities.eps




diary off
