% MakeKeyPlots(FlowEconomy,Deaths,CumulativeEconomy,DeathsLatest,Names,SortOrder,AxisTitle,gname);
%
%   Function called by PlotCountries.m, PlotStates.m, and PlotCities.m
%   to create key graphs.

function []=MakeKeyPlots(FlowEconomy,Deaths,CumulativeEconomy,DeathsLatest,Names,Groups,AxisTitle,gname);

  definecolors
  namethese=[];
  LastMonth=size(FlowEconomy,1);


  % Set distx,disty for name labels in the graphs .8,.01
  if isequal(AxisTitle,'Unemployment');
    distx=200; disty=0.5;
  else;
    distx=[]; disty=[];
  end;

  
  figure(1); figsetup; 
  plotnamesym2(DeathsLatest',FlowEconomy(end,:)',Names,12,[],distx,disty,namethese,0,myblue*1.1);
  chadfig2('COVID deaths per million people',[AxisTitle ' (percent)'],1,0)
  makefigwide;
  %wait
  print('-depsc',[gname 'Basic']);

  % Both Groups, Flow
  figure(2); figsetup; 
  plotnamesym2(DeathsLatest(Groups.Both)',FlowEconomy(end,Groups.Both)',Names(Groups.Both),12,[],distx,disty,namethese,0,myblue*1.1);
  chadfig2('COVID deaths per million people',[AxisTitle ' (percent)'],1,0)
  makefigwide;
  %wait
  print('-depsc',[gname 'Both']);
  pause(.5)


  % Both Groups, Cumulative 
  figure(3); figsetup; 
  plotnamesym2(DeathsLatest(Groups.Both)',CumulativeEconomy(end,Groups.Both)',Names(Groups.Both),12,[],distx,disty,namethese,0,myblue*1.1);
  chadfig2('COVID deaths per million people',['Cumulative ' AxisTitle '(percent years)'],1,0)
  makefigwide;
  %wait
  print('-depsc',[gname 'CumulativeBoth']);
  pause(.5)

  figure(4); figsetup; 
  plotnamesym2(DeathsLatest',CumulativeEconomy(end,:)',Names,12,[],distx,disty,namethese,0,myblue*1.1);
  chadfig2('COVID deaths per million people',['Cumulative Excess ' AxisTitle ' (percent years)'],1,0)
  makefigwide;
  %wait
  print('-depsc',[gname 'CumulativeBasic']);
  pause(.5)
  
  %%%%%%%%%%
  % DYNAMICS
  %%%%%%%%%%

  LW=2;
  Transparency=1;
  mycolors=[myrainbow(1:6,:); 0.9*myrainbow(1:6,:); 0.8*myrainbow(1:6,:); 0.75*myrainbow(1:6,:)];
  mycolors=[mycolors ones(size(mycolors,1),1)*Transparency];
  
  Powersof2=2.^(0:11)';
  StringPowersof2=strmat(' 1 # 2 # 4 # 8 # 16# 32# 64#128#256#512#1024#2048','#');

  months=(1:LastMonth); % Feb Mar Apr May June July August
  figure(4); figsetup;
  ctys=Groups.Both;
  for i=1:length(ctys)
    plot(log(1+Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'-','Color',mycolors(i,:),'LineWidth',LW);
    plot(log(1+Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'o','Color',mycolors(i,:),'LineWidth',LW,'MarkerFaceColor',mycolors(i,1:3));
    plotnamesym2(log(1+Deaths(end,ctys(i))'),FlowEconomy(end,ctys(i)),Names(ctys(i)),12,[],distx,disty,[],0,myblue*1.1);
  end;
  chadfig2('COVID deaths per million people',[AxisTitle ' (percent)'],1,0)
  relabelaxis(log(1+Powersof2),StringPowersof2,'x');
  makefigwide;
  print('-depsc',[gname 'Dynamics1']);
  pause(.5)

  
  % Drop March as it is always at low deaths, low economic activity...
  months=(2:LastMonth); % Mar Apr May June July etc


  % Small Select Group (USA, DEU, ITA, GBR, etc)
  figure(5); figsetup;
  ctys=Groups.Small;
  for i=1:length(ctys)
    plot(log(1+Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'-','Color',mycolors(i,:),'LineWidth',LW);
    plot(log(1+Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'o','Color',mycolors(i,:),'LineWidth',LW,'MarkerFaceColor',mycolors(i,1:3));
    plotnamesym2(log(1+Deaths(end,ctys(i))'),FlowEconomy(end,ctys(i)),Names(ctys(i)),12,[],distx,disty,[],0,myblue*1.1);
  end;
  chadfig2('COVID deaths per million people',[AxisTitle ' (percent)'],1,0)
  makefigwide;
  relabelaxis(log(1+Powersof2),StringPowersof2,'x');
  print('-depsc',[gname 'Dynamics2']);
  pause(.5)


  % Big group of "Middle" countries (JPN, BEL, MEX, KOR,etc)
  figure(6); figsetup;
  ctys=Groups.Big;
  for i=1:length(ctys)  
    plot(log(1+Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'-','Color',mycolors(i,:),'LineWidth',LW);
    plot(log(1+Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'o','Color',mycolors(i,:),'LineWidth',LW,'MarkerFaceColor',mycolors(i,1:3));
    plotnamesym2(log(1+Deaths(end,ctys(i))'),FlowEconomy(end,ctys(i)),Names(ctys(i)),12,[],distx,disty,[],0,myblue*1.1);
  end;
  chadfig2('COVID deaths per million people',[AxisTitle ' (percent)'],1,0)
  makefigwide;
  relabelaxis(log(1+Powersof2),StringPowersof2,'x');
  print('-depsc',[gname 'Dynamics2b']);
  pause(.5)


  % Both Groups
  figure(7); figsetup;
  ctys=Groups.Both;
  for i=1:length(ctys);
    plot((Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'-','Color',mycolors(i,:),'LineWidth',LW);
    plot((Deaths(months,ctys(i))),FlowEconomy(months,ctys(i)),'o','Color',mycolors(i,:),'LineWidth',LW,'MarkerFaceColor',mycolors(i,1:3));
    plotnamesym2((Deaths(end,ctys(i))'),FlowEconomy(end,ctys(i)),Names(ctys(i)),12,[],distx,disty,[],0,myblue*1.1);
  end;
  chadfig2('COVID deaths per million people',[AxisTitle ' (percent)'],1,0)
  makefigwide;
  print('-depsc',[gname 'Dynamics3']);
  pause(.5)


  % Small top 5
  figure(8); figsetup;
  ctys=Groups.Small;
  for i=1:length(ctys)
    plot(log(1+Deaths(months,ctys(i))),CumulativeEconomy(months,ctys(i)),'-','Color',mycolors(i,:),'LineWidth',LW);
    plot(log(1+Deaths(months,ctys(i))),CumulativeEconomy(months,ctys(i)),'o','Color',mycolors(i,:),'LineWidth',LW,'MarkerFaceColor',mycolors(i,1:3));
    plotnamesym2(log(1+Deaths(end,ctys(i))'),CumulativeEconomy(end,ctys(i)),Names(ctys(i)),12,[],distx,disty,[],0,myblue*1.1);
  end;
  chadfig2('COVID deaths per million people',['Cumulative ' AxisTitle '(percent years)'],1,0)
  makefigwide;
  relabelaxis(log(1+Powersof2),StringPowersof2,'x');
  print('-depsc',[gname 'Dynamics2c5']);
  pause(.5)


  
  % Big middle set
  ctys=Groups.Big;
  figure(9); figsetup;
  for i=1:length(ctys)
    plot(log(1+Deaths(months,ctys(i))),CumulativeEconomy(months,ctys(i)),'-','Color',mycolors(i,:),'LineWidth',LW);
    plot(log(1+Deaths(months,ctys(i))),CumulativeEconomy(months,ctys(i)),'o','Color',mycolors(i,:),'LineWidth',LW,'MarkerFaceColor',mycolors(i,1:3));
    plotnamesym2(log(1+Deaths(end,ctys(i))'),CumulativeEconomy(end,ctys(i)),Names(ctys(i)),12,[],distx,disty,[],0,myblue*1.1);
  end;
  chadfig2('COVID deaths per million people',['Cumulative ' AxisTitle '(percent years)'],1,0)
  makefigwide;
  relabelaxis(log(1+Powersof2),StringPowersof2,'x');
  print('-depsc',[gname 'Dynamics2c15']);

  
end

