% BPEAMaster.m
%   Master program to execute all the programs in the BPEA project
%
%    >>ReadCovidData.m  (calls ReadCovidStates.m as well)
%
%    Uses data files:
%    LondonMadridEtc.csv   -- update "by hand"
%    time_series_covid19_deaths_global.csv from https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_covid19_deaths_global.csv
%    time_series_covid19_deaths_US.csv from https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_covid19_deaths_US.csv
%    UID_ISO_FIPS_LookUp_Table.xls -- country codes, lat/long, and populations
% 
%    MakeKeyPlots.m -- function to make some plots

clear all; clear global; close all;

if exist('plotnamesym2')==0;
  disp 'NOTE: You need to download the file ChadMatlab.zip, unzip it, and make';
  disp 'sure those functions are on the matlab path before running BPEAMaster.m';
  disp 'https://web.stanford.edu/~chadj/ChadMatlab.zip';
  disp 'Halting...';
  keyboard
end;

% Read the data for Covid, unemployment, Google
ReadCovidData          % Reads the Covid death data
ReadStateData          % State unemployment rates
ReadGoogleCities       % Google city data 
ReadGoogleCountries    % Google country (and OECD GDP data)
ReadGoogleStates       % Google state data

% Make the basic tradeoff graphs
PlotStylizedTradeoff   % The stylized figures at the start of the paper
PlotCountries          % Country GDP plots
PlotStates             % Country Unemployment and Google data
PlotCities             % City Google data plots

% Olots of Google activity over time
PlotGoogleCountries
PlotGoogleStates
PlotGoogleCities
