********************************************************************************
* Program to generate daily time series figures
********************************************************************************
clear
set more off
* Edit this variable * 
local home = "/Users/sbelz"
cd "`home'/bpea_replication/data/"
set scheme s1color

*==============================================================================* 
* Corporate Bond Spreads
* Note: Spreads are calculated by ICE BofAML; they are the calculated spreads 
* between a computed OAS index of all bonds in a given rating category and a 
* spot Treasury curve
*==============================================================================* 	   
* Data from FRED
use yields, clear
qui merge 1:m daten using covidevents, nogen

foreach var in  DJIA SP5 {
 summarize `var' if daten == date("02jan2020", "DMY")
 replace `var' = 100*`var'/r(mean)
}

gen lines = dumm*3 + 10
keep if daten > date("31dec2019", "DMY")
  
* Macro to place month labels between tick marks
forvalues y = 1/8 {
	local midmonth `midmonth' `=mdy(`y',16,2020)'
	local firstofmonth `firstofmonth' `=mdy(`y',1,2020)'
}
  
* IG
replace lines = dumm/1.7
twoway (line aspr bbbspr daten, lwidth(medthick medthick)) ///
	   (sca lines daten, mc(black) msi(0.25) mlabel(event) mlabsize(2) mlabcolor(black)) ///
	   (bar lines daten, bcolor(gs10) barwidth(0.05) yaxis(2)),	///
	   xlabel(`midmonth', noticks format(%tdm)) xtitle("") ///
	   xticks(`firstofmonth') ///
	   ylabel(0(1)6, angle(horizontal)) ///
	   ylabel(0(1)6, angle(horizontal) axis(2)) ytitle("", axis(2)) ///
	   legend(order(1 "A" 2 "BBB"))
	   
graph export "../output/dailyIGspreads.png", replace

* HY
replace lines = dumm*1.6 + 8
twoway (line bspr cccspr daten, lcolor(navy cranberry) lwidth(medthick medthick)) ///
	   (sca lines daten, mc(black) msi(0.25) mlabel(event) mlabsize(2) mlabcolor(black) yaxis(2)) ///
	   (bar lines daten, bcolor(gs10) barwidth(0.05)),	///
	   xlabel(`midmonth', noticks format(%tdm)) xtitle("") ///
	   xticks(`firstofmonth') ///
	   ylabel(2(2)24, angle(horizontal)) ///
	   ylabel(2(2)24, angle(horizontal) axis(2)) ytitle("", axis(2)) ///
	   legend(order(1 "B" 2 "CCC"))
	   
graph export "../output/dailyHYspreads.png", replace

stop

  

