********************************************************************************
* Program to generate figures of SPF forecast dispersion
********************************************************************************
clear
set more off
local home = "/Users/sbelz"
cd "`home'/bpea_replication/data/"
********************************************************************************
import delimited "raw data/spf_dispersion.csv"
gen yq = quarterly(survey_datet, "YQ")
format yq %tq
drop survey_datet
save "spf_dispersion.dta", replace

* merge with vix data
use yields, clear
gen yq= yq(year(daten), quarter(daten))
format yq %tq
keep yq VIX

* Aggregate to monthly series
collapse (mean) VIX, by(yq)
merge m:m yq using spf_dispersion, nogen
merge m:m yq using fredquarterly, nogen
sort yq

* Recession shading objects
replace USREC = 1 if yq > yq(2020, 1)
replace USREC = . if USREC == 0
gen shade = USREC


local startyr = 1990
keep if yq >= yq(`startyr',1)

* Macros to place year labels between tick marks
forvalues y = `startyr'(6)2020 {
	local midyr `midyr' `=yq(`y',1)'
}
forvalues y = `startyr'(1)2020 {
	local firstofyr `firstofyr' `=yq(`y',1)'
}
* GDP forecast dispersion and volatility
*==============================================================================*
replace shade = USREC*14
twoway (area shade yq, color(gs15) cmissing(n)) ///
	   (line rgdp_d2t yq, lcolor(red)) ///
	   (line VIX yq, yaxis(2) lcolor(ebblue%75)), ///
	   yscale(range(0(2)14) axis(1)) ///
	   ylabel(0(2)14, axis(1)) ///
	   ytitle("GDP Forecast Dispersion", axis(1)) ///
	   ytitle("", axis(2)) ///
	   ytitle("") ///
	   xlabel(`midyr', format(%tqCY)) xtitle("") ///
	   xticks(`firstofyr', tlength(0.5)) ///
	   legend(order(2 "GDP Forecast Dispersion (left)" 3 "VIX (right)"))

graph export "../output/spf_vix.png", replace
