clear all
cap log close
cd "/Users//`=c(username)'/Dropbox/coronavirus/Code/BPEA_replication_code"
log using SEIRD_generate_figs.txt, text replace
************************************************************************************
* SEIRD_generate_figs.do                    JS 7/26/20
*
* Re-Generates figures for final BPEA draft from .dta programs 
*   Note that the figures were generated internally in the programs then the figure data were saved as .dta files
************************************************************************************
* Fan charts: Figures 1, 2, 6, 7, 8, 9, 10
global PIDdate "01Jun2020"

* Unemployment figures
foreach ff in "1L" "2L" "2R" "6L" "6R" "7L" "7R" "8L" "8R" "9L" "9R" "10L" "10R" {
	use "figs/BPEA_figs_final/fig`ff'", clear
	sort date
	format date %tdMonDD
	tsset date
    twoway (rarea dwtot_b3 dwtot_b4 date, fcolor(red%60) lcolor(red%30)) ///
         (rarea dwtot_b2 dwtot_b5 date, fcolor(red%45) lcolor(red%10)) ///
         (rarea dwtot_b1 dwtot_b6 date, fcolor(red%30) lcolor(red%10)) ///
         (tsline wtot_p1 deaths_weekly, lc(cranberry black) lp(l _) ytitle(Thousands)) ///
         (rarea dunrate_mthly_b3 dunrate_mthly_b4 date, fcolor(ebblue%60) lcolor(ebblue%30) yaxis(2) ytitle("Percent", axis(2))) ///
         (rarea dunrate_mthly_b2 dunrate_mthly_b5 date, fcolor(ebblue%45) lcolor(ebblue%10) yaxis(2)) ///
         (rarea dunrate_mthly_b1 dunrate_mthly_b6 date, fcolor(ebblue%30) lcolor(ebblue%10) yaxis(2)) ///
         (tsline unrate_mthly_p1, lc(dknavy) yaxis(2) tline($PIDdate, lc(black) lp(-))), ///
	     title("Figure `ff'") legend(off) xtitle("") 
}

* GDP figure (Figure 1R)
local ff "1R"
 use "figs/BPEA_figs_final/fig`ff'.dta", clear
 sort date
 format date %tdMonDD
 tsset date
	  twoway (rarea dwtot_b3 dwtot_b4 date, fcolor(red%60) lcolor(red%30)) ///
         (rarea dwtot_b2 dwtot_b5 date, fcolor(red%45) lcolor(red%10)) ///
         (rarea dwtot_b1 dwtot_b6 date, fcolor(red%30) lcolor(red%10)) ///
         (tsline wtot_p1 deaths_weekly, lc(cranberry black) lp(l _) ytitle(Thousands)) ///
         (rarea dgdp_qtrly_b3 dgdp_qtrly_b4 date, fcolor(forest_green%60) lcolor(forest_green%30) yaxis(2) ytitle("Fraction of 2019Q4", axis(2))) ///
         (rarea dgdp_qtrly_b2 dgdp_qtrly_b5 date, fcolor(forest_green%45) lcolor(forest_green%10) yaxis(2)) ///
         (rarea dgdp_qtrly_b1 dgdp_qtrly_b6 date, fcolor(forest_green%30) lcolor(forest_green%10) yaxis(2)) ///
         (tsline gdp_qtrly_p1, lc(dknavy) yaxis(2) ysc(r(0.86 1) axis(2)) ylab(0.86(0.02)1, axis(2)) tline($PIDdate, lc(black) lp(-))), ///
	     title("") legend(off) xtitle("") 

* Fig. 3
foreach ff in "3L" "3C" "3R" { 
  use "figs/BPEA_figs_final/fig`ff'", clear
  twoway contour ctotplot contacta contactb in 1/25, heatmap ecolor(cranberry) crule(int) ccuts(0(0.2)9) xtitle("") ytitle("")
}

* Fig. 4
use "figs/BPEA_figs_final/fig4", clear
  local nplag = 14 // plot lag of deaths to account for lag in death reporting + longer non-Markov lags in infections to deaths
  local vv "reff"
  twoway (rarea d`vv'_p1_q05 d`vv'_p1_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p1 , lc(cranberry ) ) ///
         (rarea d`vv'_p2_q05 d`vv'_p2_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p2 , lc(cranberry ) ) ///
         (rarea d`vv'_p3_q05 d`vv'_p3_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p3 , lc(black     ) ) ///
         (rarea d`vv'_p4_q05 d`vv'_p4_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p4 , lc(cranberry ) ) ///
         (rarea d`vv'_p5_q05 d`vv'_p5_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p5 , lc(cranberry ) ) ///
         (rarea d`vv'_p6_q05 d`vv'_p6_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p6 , lc(cranberry ) ) ///
         (rarea d`vv'_p7_q05 d`vv'_p7_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p7 , lc(cranberry ) ) ///
         (rarea d`vv'_p8_q05 d`vv'_p8_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p8 , lc(cranberry ) ) ///
		 (rarea F`nplag'.reffhat_poly_q05 F`nplag'.reffhat_poly_q95 date if tin(08Mar2020,05Jul2020), fcolor(teal%60) lcolor(teal%30)) ///
		 (tsline F`nplag'.reffhat_poly if tin(08Mar2020,05Jul2020), lc(navy) yline(1, lc(black) lp(-)) ), ///
	     title("R-effective: Model and nonparametric estimates") legend(off) xtitle("") tlabel(#10, angle(45))

* Fig. 5
use "figs/BPEA_figs_final/fig5L", clear
 format date %tdMonDD
 tsline D1 D2 D3 D4 D5, tline($PIDdate, lc(black) lp(-)) ttitle("") ytitle(Thousands) ///
		title("Total deaths by age") legend(cols(3)) tlabel(#10, angle(45))
use "figs/BPEA_figs_final/fig5R", clear
 format date %tdMonDD
 tsline Rshr1 Rshr2 Rshr3 Rshr4 Rshr5, tline($PIDdate, lc(black) lp(-)) ttitle("") ytitle(fraction of age group) ///
			title("Share of recovered individuals by age") legend(cols(3)) tlabel(#10, angle(45))
