clear all
cap log close
cd "/Users//`=c(username)'/Dropbox/coronavirus/Code/BPEA_replication_code"
log using SEIRD_estn_v8.txt, text replace
set more off 
set scheme s1color
pause on
************************************************************************************
* SEIRD_estn_v8.do                    JS 4/30 - 7/6/20
*
* Estimate (calibrate) SEIRD model
*   Discrete time, time period = 1 day.
*  5/6: fit to weekly deaths
*   v5: cleaned up for WP version
*   v6: Revamp for daily contact matrices with estimation of TV phi factor
*   v7: version for final BPEA draft (not cleaned)
*   v8: version for final BPEA draft (cleaned)
*   
************************************************************************************
*
global outpath "../../Output/Epidemiology/Sheets"
global figpath "figs/estn"

* --------- Model parameters ------------
* latency and contagious periods
* Base case
global sigma = exp(1/4.87)-1   // Mean of published studies (Adriano memo)
global gamma = exp(1/5)-1     // Kissler et al (Science, April 14 2020)
local initvals "I0 3 phi0 0.01 phi1 0.8 phi2 0.8 beta 0.05"
* sensitivity check - longer periods
*global gamma = exp(1/9)-1     // Sensitivity analysis
*local initvals "I0 9 phi0 0.01 phi1 1.3 phi2 1.5 beta 0.03"

do NLSEIRD_PID_v12  // SEIRD model with time-varying contact matrices and PID controller, for nl estn
do NPI_setup_v5

* disable PID controller for estimation
global PIDdate "18May2021"
gen PID = 0
global ndate_PID = _N+1
local csfx ""
mkmat PID, mat(PID)

* disable derivatives
mat delta_lshare = J(1,68,0)

* disable quarantine options
global nremove = 0
 global tremove = "15Jul2020"
 cap drop e98
 gen e98 = tin(,$tremove)
 qui su e98
  global ndate_remove = r(sum)
gen qrate = 0 // quarantine rate

* Estimation
global edate1 "15Mar2020"
global edate2 "24Jun2020"
 cap drop edates
 gen edates = tin($edate1,$edate2)
 mkmat edates, mat(edates)
 su obsno if tin($edate1,$edate1)
 global nedate1 = int(r(mean)+.000001)
 su obsno if tin($edate2,$edate2)
 global nedate2 = int(r(mean)+.000001)
 global nedate3 = $nedate2
global varout=0
local nage = $nage
* For estimation, end simulation at end of estimation period
gen e99 = tin(,$edate2)
 qui su e99
 global ndate_est = int(r(sum))

*
if $nage==1 {
 preserve
  qui import excel using "maxReval_`scenario'_265_486.xlsx", clear
  mkmat B, mat(maxReval_input)
 restore
}

* -------------- Estimation for multiple initial values, writing output file -------------
global varout=0
local i = 0
 local R0 = round(`R0',.01)
 forvalues delta = .004(.001).0111 {
 *forvalues delta = .006(.001).00601 {
  local delta = round(`delta',.001)
  mat IFR = `delta'*IFR00 
  local i = `i'+1
  dis `i' "   " `R0' "   " `delta' 
  global ndate_END = $ndate_est
  
  nl seird_pid @ deaths_weekly if edates, parameters(I0 phi0 phi1 phi2 beta) initial(`initvals')
   mat bhat = e(b)
   estat vce
   mat V99 = r(V)
   local ssr = e(rss)
   local rmse = e(rmse)
   mat se = sqrt(V99[1,1])
   local nparms = colsof(bhat)
   forvalues j = 2/`nparms' {
   	 mat se = (se,sqrt(V99[`j',`j']))
   }
  * Caluculate IFR and predicted at estimated parameters
  global varout=1
  cap drop x99
  gen x99 = 0
  nlseird_pid x99 if edates, at(bhat)
   cap drop pdeaths
   gen pdeaths = Wtot
   label var pdeaths "Predicted"

  format date %tdmD
  tsline deaths_weekly pdeaths if tin(01Mar2020,$t0_deaths), lc(black black) lp(l _) ///
       tline($edate1 $edate2) tlabel(#10, angle(45)) title("IFR = `delta'") ttitle("")
  graph export "$figpath/estn_`scenario'`csfx'_`nage'_W_act_pred_`fIFRsv'.png", replace
  
   local nparms = colsof(bhat)
   su r0 in 1/10
   local R0 = r(mean)
   mat pouti = (`nparms',bhat,se,$nedate1,$nedate2,`R0',`delta',$gamma,$sigma,$inf_kids2adults,$inf_adults2kids,$o1ns,$hHH,$IFR_sim,`ssr',`rmse')
   mat vouti = vec(V99)'

   if `i'==1 {
   mat pout = pouti
   mat vout = vouti
  }
  else {
   mat pout = pout \ pouti
   mat vout = vout \ vouti
  }
 }
*}
putexcel set "estn\Estd_parms_`nage'", sheet("parms") replace
  putexcel A1 = matrix(pout)
putexcel set "estn\Estd_parms_`nage'", sheet("vcv") modify
  putexcel A1 = matrix(vout)
*--------------------------------------------------------------------------------*
log close

