clear all
cap log close
cd "/Users//`=c(username)'/Dropbox/coronavirus/Code/BPEA_replication_code"
log using SEIRD_control_v9.txt, text replace
set more off 
set scheme s1color
pause on
************************************************************************************
* SEIRD_control_v9.do                    JS 5/2,...7/16/20
*
* Run estimated SEIRD with control
*       Computes spread bands (parameter sensitivity bands)
*  v3:  GDP calculation using Hulten
*  v4:  updated PID controller, version for HELP seminar
*  v5:  version for NBER WP (updated scenarios)
*  v6:  updated for more accurate R0 formula
*       SE bands for projections using est'd parms and delta method
*  v7:  updated for final draft of BPEA paper
*  v8:  final draft of BPEA paper (cleaned)
*  v9:  Uncertainty bands are from IFR (.05 - .09)
************************************************************************************
/* Handy calendar:
      date       obsno
    21feb2020       1  
    01mar2020      10  
    10mar2020      19  
    15mar2020      24  
    01apr2020      41  
    15apr2020      55  
    01may2020      71  
    15may2020      85  
    18may2020      88  
    23may2020      93  
    27may2020      97  
    01jun2020     102  
    08jun2020     109  
    12jun2020     113  
    15jun2020     116  
    01jul2020     132  
    15jul2020     146  
    20jul2020     151  
    01aug2020     163  
    15aug2020     177  
    24aug2020     186  
    01sep2020     194  
    15sep2020     208  
    01oct2020     224  
    15oct2020     238  
    01nov2020     255  
    15nov2020     269  
    01dec2020     285  
    15dec2020     299  
    01jan2021     316  
************************************************************************************/

global outpath "../../Output/Epidemiology/Sheets"
global figpath "figs"

do NLSEIRD_PID_v12  // SEIRD model with time-varying contact matrices, TV phi, and PID controller, for nl estn
do NPI_setup_v5
replace deaths_weekly=. if tin(26Jun2020,) // plot actual deaths through the date of the conference - the vintage of these scenarios

* PID controller - initial specification hits contact matrix
*
global ENDdate "01Jan2021"
global PIDdate "01Jun2020"
global nedate3 = 97 // Wednesday of week after Memorial day
cap drop PID
gen PID = 0
replace PID = 1 if tin($PIDdate,)
 mkmat PID, mat(PID)
 global varout=1
su obsno if tin($PIDdate,$PIDdate)
 global ndate_PID = int(r(mean)+0.00001)
 global ndate_PIDm1 = $ndate_PID-1
su obsno if tin($ENDdate,$ENDdate)
 global ndate_END = int(r(mean)+0.00001)
keep if tin(,$ENDdate)
gen mgfac = .
gen home_fac5 = .

local today = subinstr("$S_DATE"," ","",3)
global resout "out/control_results_`today'.xlsx"
putexcel set $resout, replace
local m = 0

* choose what to plot
global ageplot = 0  // plot total deaths and recovered share by age group
global seplot = 1 // fan chart based on single-IFR confidence bands
global ifrplot = 0 // fan chart based on IFR bands

foreach ss of numlist 2/11 {
foreach gov in "fast" "slow" {

if "`gov'"=="slow" {
 global ku = 20         // weight on unemployment rate (pp)
 global kiu = .02     // cumulative unemployment gap
 global kp = 0.01       // daily deaths
 global kd = .05        // change in daily deaths (7-week change in daily units)
}
if "`gov'"=="fast" {
 global ku = 80         // weight on unemployment rate (pp)
 global kiu = 2     // cumulative unemployment gap
 global kp = 0.01       // daily deaths
 global kd = .05        // change in daily deaths (7-week change in daily units)
}
global dlag = 14

if `ss' == 2 {
* SD3: low SD, Phase I May 18, Phase II June 8, Phase III July 1, Phase IV Sept 15
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 132  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 109, 132 , 208 )
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.75
global k1 = 1 
local case "`gov'-SD3"
}
if `ss' == 3 {
* SD3 but wfh
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  500, 500, 500  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 109, 132 , 208 )
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.75
global k1 = 1 
local case "`gov'-SD3+wfh"
}
if `ss' == 4 {
* SD3 + Require all 65+ to wfh or not at all
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 132  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 109, 132 , 208 )
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\0\0)
replace home_fac5 = 0.75
global k1 = 1 
local case "`gov'-SD3+no65"
}
if `ss' == 5 {
* SD3 with no sectoral prioritization
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 132  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 109, 132 , 208 )
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.75
global k1 = 0 
local case "`gov'-SD3"
}
if `ss' == 6 {
* SD3 with high sectoral prioritization
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 132  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 109, 132 , 208 )
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.75
global k1 = 2 
local case "`gov'-SD3"
}
if `ss' == 7 {
* SD3 but wfh + no age65+ workers at work + extreme sectoral reopening
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  500, 500, 500  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 109, 132 , 208 )
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\0\0)
replace home_fac5 = 0.75
global k1 = 2 
local case "`gov'-SD3+wfh+no65"
}
if `ss' == 8 {
* SD3 but sequester age 75+
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 132  \ 500, 500 , 500 \ 88, 109, 132 \ 88, 109, 132 \ 88, 109, 132 \ 500, 500, 500)
mat npis        =     (   1,   1 ,   1  \   1,   1 ,   1 \  1,   1,   1 \  1,   1,   1 \  1,   1,   1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) 
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.25
global k1 = 1 
local case "`gov'-SD3-75+"
}
if `ss' == 9 {
* SD3 with reversal of non-economic on July 15 (return to Phase I status of May 18)
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 146  \ 500, 500 , 500 \ 88, 109, 146 \ 88, 109, 146 \ 88, 109, 146 \ 109, 132 , 146 )
mat npis        =     (   1,   1,    1  \   1,   1 ,   1 \  1,   1,  -1 \  1,   1,  -1 \  1,   1,  -1 \   1,   1 ,  -1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) - 0.15*(_n>=146)
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.75
global k1 = 1 
local case "`gov'-SD3+rev"
}
if `ss' == 10 {
* SD3 with reversal of non-economic on July 15 (return to Phase I status of May 18) + sequester age 75+
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  109, 132, 146  \ 500, 500 , 500 \ 88, 109, 146 \ 88, 109, 146 \ 88, 109, 146 \ 500, 500 , 500 )
mat npis        =     (   1,  1,   1  \   1,   1 ,   1 \  1,   1,  -1 \  1,   1,  -1 \  1,   1,  -1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) - 0.15*(_n>=146)
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.25
global k1 = 1 
local case "`gov'-SD3+rev+75+"
}
if `ss' == 11 {
* SD3 with reversal of non-economic on July 15 (return to Phase I status of May 18) + sequester age 75+ + wfh
* reopening in stages:      wfh_fac        sdwork_fac       sdhome_fac      sdoth_fac1       sdoth_fac24      sdoth_fac25
mat npip        =     (  500, 500, 500  \ 500, 500 , 500 \ 88, 109, 146 \ 88, 109, 146 \ 88, 109, 146 \ 500, 500 , 500 )
mat npis        =     (   1,  1,   1  \   1,   1 ,   1 \  1,   1,  -1 \  1,   1,  -1 \  1,   1,  -1 \   1,   1 ,   1 )
replace mgfac = 0.25*(_n>=88) + 0.15*(_n>=109) + 0.15*(_n>=132) - 0.15*(_n>=146)
mat selage = (1\1\1\1\1)
replace home_fac5 = 0.25
global k1 = 1 
local case "`gov'-SD3+rev+75+wfh"
}

cap drop wfh_fac sdwork_fac sdhome_fac sdoth_fac*
gen wfh_fac     =       (1/3)*( (_n>=npip[1,1])*npis[1,1]+(_n>=npip[1,2])*npis[1,2]+(_n>=npip[1,3])*npis[1,3] )
gen sdwork_fac  =       (1/3)*( (_n>=npip[2,1])*npis[2,1]+(_n>=npip[2,2])*npis[2,2]+(_n>=npip[2,3])*npis[2,3] )
gen sdhome_fac  = mgfac*(1/3)*( (_n>=npip[3,1])*npis[3,1]+(_n>=npip[3,2])*npis[3,2]+(_n>=npip[3,3])*npis[3,3] )
gen sdoth_fac1  = mgfac*(1/3)*( (_n>=npip[4,1])*npis[4,1]+(_n>=npip[4,2])*npis[4,2]+(_n>=npip[4,3])*npis[4,3] )
gen sdoth_fac24 = mgfac*(1/3)*( (_n>=npip[5,1])*npis[5,1]+(_n>=npip[5,2])*npis[5,2]+(_n>=npip[5,3])*npis[5,3] )
gen sdoth_fac5  = mgfac*(1/3)*( (_n>=npip[6,1])*npis[6,1]+(_n>=npip[6,2])*npis[6,2]+(_n>=npip[6,3])*npis[6,3] )
replace wfh_frac = wfh_frac[$ndate_PIDm1] + wfh_fac*(wfh_frac[11]-wfh_frac[$ndate_PIDm1]) if tin($PIDdate,)
local nage = $nage
 
* Read in estimated parms from file - note code can only handle one set of parameter values at a time
* BPEA conference draft parameter file estn\Estd_parms_5_061820.xlsx
* Updated estimates (main change is adjusted IFRs) Estd_parms_5_062420_Salje_base
local parmfile "estn\Estd_parms_5_070620_BPEA_final_base.xlsx"
*local parmfile "estn\Estd_parms_5_0706620_BPEA_final_gamma9.xlsx"
local ifrbar = 0.007
 
preserve
 qui import excel using `parmfile', sheet(parms) case(lower) clear
 mkmat *, mat(parms_all)
 local nparms = parms_all[1,1]
 local nr1 = rowsof(parms_all)
 forvalues i1 = 1/`nr1' {
    if parms_all[`i1',1+2*`nparms'+4] == `ifrbar' {
     local isel = `i1'
	}
 }
 mat parms = parms_all[`isel',1...]
 qui import excel using `parmfile', sheet(vcv) case(lower) clear
 mkmat *, mat(vecvcv_all)
 mat vecvcv = vecvcv_all[`isel',1...]
restore

*---------- Multiple evaluation loop -------------------
cap drop edates
gen edates=0
local p = 1
 foreach fschool of numlist  0 1 {
  foreach fquar of numlist 5 10 15 {  // units are percentage quarantined
   local m = `m'+1
   local fk100 = round($k1*100,1)
   local fquar = round(`fquar',1)
   local fschool10 = round(`fschool'*10,1)
   local csfx "`case'_`fk100'_s`fschool10'_Q`fquar'"
   replace school_frac = `fschool'*tin(24Aug2020,) if tin($PIDdate,) // fraction of <20 with school open

   cap drop dtot_p* wtot_p* unrate_p* gdp_p*
	local nparms = parms[1,1]
    mat bhat = parms[1,2..`nparms'+1]
	mat vtemp = vecvcv[1,1...]'
    mata: st_matrix("vcv", colshape( st_matrix("vtemp")', 5) )
    mat list vcv
	global nedate1 = round(parms[1,1+2*`nparms'+1],.01)
	global nedate2 = round(parms[1,1+2*`nparms'+2],.01)
	 replace edates = (_n>=$nedate1)*(_n<=$nedate2)
    local R0 = round(parms[1,1+2*`nparms'+3],.01)
    global deltabar = round(parms[1,1+2*`nparms'+4],.001)
    global gamma = parms[1,1+2*`nparms'+5]
    global sigma = parms[1,1+2*`nparms'+6]
	
	local deltabar = $deltabar
    cap drop qrate
	gen qrate = $gamma*(0.05/0.95)*(`fquar'>=5)*tin($PIDdate,)
	if `fquar'>5 {
	 replace qrate = $gamma*(0.1/0.9)*(`fquar'>=10) if tin(15Jul2020,) // 10% quarantine rate initially, if indicated
	}
	if `fquar'>10 {
	 replace qrate = $gamma*(`fquar'/(100-`fquar')) if tin(01Sep2020,) // later, increase quarantine rate to higher value
	}
    mat IFR = `deltabar'*IFR00 
    cap drop x99
    gen x99 = 0
    *============================================*
    nlseird_pid x99 if edates, at(bhat)
    *============================================*
    local fd = round(Dtot[$ndate_END],1)
	keep if tin(,$ENDdate)
	cap drop unrate_mthly gdp_mthly gdp_qtrly
	replace unrate = 3.5+100*unrate
    sort yrmo date
    by yrmo: egen unrate_mthly = mean(unrate)
    by yrmo: egen gdp_mthly = mean(gdp)
	sort yrq date
    by yrq: egen gdp_qtrly = mean(gdp)
	sort date
	 qui replace gdp_qtrly = gdp_qtrly[_n-1] if tin(01Jan2021,)
	 local gdp0 = gdp_qtrly[1]
     qui replace gdp_qtrly = (51*gdp[1] + 40*`gdp0')/91 if tin(,31Mar2020)
 	*list date yrmo gdp gdp_qtrly
	qui replace unrate_mthly = . in l/l
	qui replace gdp_mthly = . in l/l
	qui replace gdp_qtrly = . in l/l

    cap drop r0_p`p' unrate_mthly_p`p' gdp_qtrly_p`p'
	cap drop unrate_p`p' gdp_p`p'
    gen dtot_p`p' = Dtot
    gen wtot_p`p' = Wtot
    gen r0_p`p' = r0
    gen unrate_p`p' = unrate_mthly
    gen gdp_p`p' = gdp_qtrly
    gen unrate_mthly_p`p' = unrate_mthly
    gen gdp_qtrly_p`p' = gdp_qtrly
	*
		*------------- Save output ----------------
	if `m'==1 {
	 mat lshockQ2 = lshock'*Q2avg
	 mat lshockQ3 = lshock'*Q3avg
	 mat lshockQ4 = lshock'*Q4avg
	 svmat lshockQ3, names(lshockQ3)
	 ren lshockQ31 lshockQ3
	}
	cap drop Un Gd
	gen Un = unrate_mthly
	gen Gd = gdp_qtrly
	if (`m'==1) {
	 qui putexcel A2 = "Case"
	 qui putexcel B2 = "k1"
	 qui putexcel C2 = "fschool"
	 qui putexcel D2 = "fquar"
	 qui putexcel AA1 = "Deaths - total (thou)"
	 qui putexcel BA1 = "Weekly deaths (thou)"
	 qui putexcel CA1 = "Unemployment rate"
	 qui putexcel DA1 = "GDP"
	 foreach C in "A" "B" "C" "D" {
 	  qui putexcel `C'A2 = "Mar01"
	  qui putexcel `C'B2 = "Apr01"
	  qui putexcel `C'C2 = "May01"
	  qui putexcel `C'D2 = "Jun01"
	  qui putexcel `C'E2 = "Jul01"
	  qui putexcel `C'F2 = "Aug01"
	  qui putexcel `C'G2 = "Sep01"
	  qui putexcel `C'H2 = "Oct01"
	  qui putexcel `C'I2 = "Nov01"
	  qui putexcel `C'J2 = "Dec01"
	  qui putexcel `C'K2 = "Jan01"
	 }
    }
 	mat Pout = ($k1,`fschool',`fquar',vec(npip)')
 	mat Dout = (Dtot[10],Dtot[41],Dtot[71],Dtot[102],Dtot[132],Dtot[163],Dtot[194],Dtot[224],Dtot[255],Dtot[285],Dtot[316])
	mat Wout = (Wtot[10],Wtot[41],Wtot[71],Wtot[102],Wtot[132],Wtot[163],Wtot[194],Wtot[224],Wtot[255],Wtot[285],Wtot[316])
	mat Uout = (Un[10],Un[41],Un[71],Un[102],Un[132],Un[163],Un[194],Un[224],Un[255],Un[285],Un[316])
	mat Yout = (Gd[10],Gd[41],Gd[71],Gd[102],Gd[132],Gd[163],Gd[194],Gd[224],Gd[255],Gd[285],Gd[316])
	local r = `m'+2
	putexcel A`r' = "`case'"
	putexcel B`r' = matrix(Pout)
    putexcel AA`r' = matrix(Dout)
    putexcel BA`r' = matrix(Wout)
    putexcel CA`r' = matrix(Uout)
    putexcel DA`r' = matrix(Yout)
    * ----------- age profile plot (no SEs) -----------
	if $ageplot==1 {
		local fIFRsv = round(1000*`deltabar',1)
		format date %tdMonDD
		tsline D1 D2 D3 D4 D5, tline($PIDdate, lc(black) lp(-)) ttitle("") ytitle(Thousands) ///
			title("Total deaths by age") legend(cols(3)) tlabel(#10, angle(45))
			graph export "$figpath/age/`csfx'_`fIFRsv'_D-age.png", replace
		preserve 
		 keep date D1 D2 D3 D4 D5
		 save "$figpath/age/`csfx'_`fIFRsv'_D-age", replace
		restore
		tsline Rshr1 Rshr2 Rshr3 Rshr4 Rshr5, tline($PIDdate, lc(black) lp(-)) ttitle("") ytitle(fraction of age group) ///
			title("Share of recovered individuals by age") legend(cols(3)) tlabel(#10, angle(45))
			graph export "$figpath/age/`csfx'_`fIFRsv'_Rshr-age.png", replace
		format date %td
		preserve 
		 keep date Rshr1 Rshr2 Rshr3 Rshr4 Rshr5
		 save "$figpath/age/`csfx'_`fIFRsv'_Rshr-age", replace
		restore
	}
	* --------------- Fan plot --------------------
	if $seplot==1 {
		local pltype "SE"
    * compute derivatives and SEs wrt I0 and beta (not phi)
		global eps = 1e-4
		local npx = `nparms'-1
		forvalues j = 1(`npx')`nparms' {
			mat delbhat = J(1,colsof(bhat),0)
			mat delbhat[1,`j'] = $eps
			mat bhat_eps = bhat + delbhat
			*----------------*
			nlseird_pid x99 if edates, at(bhat_eps)
			*----------------*
			cap drop unrate_mthly gdp_mthly gdp_qtrly
			replace unrate = 3.5+100*unrate
			sort yrmo date
			by yrmo: egen unrate_mthly = mean(unrate)
			by yrmo: egen gdp_mthly = mean(gdp)
			sort yrq date
			by yrq: egen gdp_qtrly = mean(gdp)
			sort date
			qui replace gdp_qtrly = gdp_qtrly[_n-1] if tin(01Jan2021,)
			local gdp0 = gdp_qtrly[1]
			qui replace gdp_qtrly = (51*gdp[1] + 40*`gdp0')/91 if tin(,31Mar2020)
			qui replace unrate_mthly = . in l/l
			qui replace gdp_mthly = . in l/l
			qui replace gdp_qtrly = . in l/l
			cap drop wtot_eps`j' r0_eps`j' unrate_mthly_eps`j' gdp_qtrly_eps`j'
			qui gen wtot_eps`j' = (Wtot-wtot_p`p')/$eps
			qui gen r0_eps`j' = (r0-r0_p`p')/$eps
			qui gen unrate_mthly_eps`j' = (unrate_mthly-unrate_mthly_p`p')/$eps
			qui gen gdp_qtrly_eps`j' = (gdp_qtrly-gdp_qtrly_p`p')/$eps
		}
	}
    foreach vv in "wtot" "r0" "unrate_mthly" "gdp_qtrly" {
     cap drop d`vv'_*
 	 qui gen d`vv'_se = .
	 if $seplot==1 {
		qui replace d`vv'_se = sqrt(`vv'_eps1*`vv'_eps1*vcv[1,1] + `vv'_eps`nparms'*`vv'_eps`nparms'*vcv[`nparms',`nparms'] + 2*`vv'_eps1*`vv'_eps`nparms'*vcv[1,`nparms'])
	 }
	 qui gen d`vv'_b1 = `vv'_p`p' - 1.96*d`vv'_se
	 qui gen d`vv'_b2 = `vv'_p`p' - 1.645*d`vv'_se
	 qui gen d`vv'_b3 = `vv'_p`p' - d`vv'_se
	 qui gen d`vv'_b4 = `vv'_p`p' + d`vv'_se
	 qui gen d`vv'_b5 = `vv'_p`p' + 1.645*d`vv'_se
	 qui gen d`vv'_b6 = `vv'_p`p' + 1.96*d`vv'_se
	}
	if $ifrplot==1 {
		local pltype "IF"
		local ii = 0
		foreach ifri of numlist .004 .005 .006 .008 .009 .01 {
			local ii = `ii'+1
			forvalues i1 = 1/`nr1' {
				if parms_all[`i1',1+2*`nparms'+4] == `ifri' {
					local isel = `i1'
				}
			}
			mat parms = parms_all[`isel',1...]
			mat bhat = parms[1,2..`nparms'+1]
			mat IFR = `ifri'*IFR00 
			cap drop x99
			gen x99 = 0
			*----------------*
			nlseird_pid x99 if edates, at(bhat)
			*----------------*
			cap drop unrate_mthly gdp_mthly gdp_qtrly
			replace unrate = 3.5+100*unrate
			sort yrmo date
			by yrmo: egen unrate_mthly = mean(unrate)
			by yrmo: egen gdp_mthly = mean(gdp)
			sort yrq date
			by yrq: egen gdp_qtrly = mean(gdp)
			sort date
			qui replace gdp_qtrly = gdp_qtrly[_n-1] if tin(01Jan2021,)
			local gdp0 = gdp_qtrly[1]
			qui replace gdp_qtrly = (51*gdp[1] + 40*`gdp0')/91 if tin(,31Mar2020)
			qui replace unrate_mthly = . in l/l
			qui replace gdp_mthly = . in l/l
			qui replace gdp_qtrly = . in l/l
			qui replace dwtot_b`ii' = Wtot
			qui replace dunrate_mthly_b`ii' = unrate_mthly
			qui replace dgdp_qtrly_b`ii' = gdp_qtrly
			list date dwtot_b`ii' dunrate_mthly_b`ii' if day==30
		}
	}
	*------------- Figures ----------------
    local nage = $nage
    format date %tdMonDD
    sort date
    qui tsset date
    local R0100 = round(100*`R0',1) 
    local fIFR = round(100*`deltabar',.001)
    local fIFRsv = round(1000*`deltabar',1)
    * uncertainty fan plots
	  twoway (rarea dwtot_b3 dwtot_b4 date, fcolor(red%60) lcolor(red%30)) ///
         (rarea dwtot_b2 dwtot_b5 date, fcolor(red%45) lcolor(red%10)) ///
         (rarea dwtot_b1 dwtot_b6 date, fcolor(red%30) lcolor(red%10)) ///
         (tsline wtot_p1 deaths_weekly, lc(cranberry black) lp(l _) ytitle(Thousands)) ///
         (rarea dunrate_mthly_b3 dunrate_mthly_b4 date, fcolor(ebblue%60) lcolor(ebblue%30) yaxis(2) ytitle("Percent", axis(2))) ///
         (rarea dunrate_mthly_b2 dunrate_mthly_b5 date, fcolor(ebblue%45) lcolor(ebblue%10) yaxis(2)) ///
         (rarea dunrate_mthly_b1 dunrate_mthly_b6 date, fcolor(ebblue%30) lcolor(ebblue%10) yaxis(2)) ///
         (tsline unrate_mthly_p1, lc(dknavy) yaxis(2) tline($PIDdate, lc(black) lp(-))), ///
	     title("") legend(off) xtitle("") ///
	     note("Base IFR = `deltabar', Quarantine rate = `fquar'%. Total deaths by Jan. 1, 2021 = `fd',000") tlabel(#10, angle(45))
         graph export "$figpath/fan/`csfx'_`fIFRsv'_W_unrate_fan_`pltype'.png", replace
	  preserve
		keep date dwtot_b1-dwtot_b6 wtot_p1 deaths_weekly dunrate_mthly_b1-dunrate_mthly_b6 unrate_mthly_p1
		save "$figpath/fan/`csfx'_`fIFRsv'_W_unrate_fan_`pltype'.dta", replace
	  restore
	  * 
	  twoway (rarea dwtot_b3 dwtot_b4 date, fcolor(red%60) lcolor(red%30)) ///
         (rarea dwtot_b2 dwtot_b5 date, fcolor(red%45) lcolor(red%10)) ///
         (rarea dwtot_b1 dwtot_b6 date, fcolor(red%30) lcolor(red%10)) ///
         (tsline wtot_p1 deaths_weekly, lc(cranberry black) lp(l _) ytitle(Thousands)) ///
         (rarea dgdp_qtrly_b3 dgdp_qtrly_b4 date, fcolor(forest_green%60) lcolor(forest_green%30) yaxis(2) ytitle("Fraction of 2019Q4", axis(2))) ///
         (rarea dgdp_qtrly_b2 dgdp_qtrly_b5 date, fcolor(forest_green%45) lcolor(forest_green%10) yaxis(2)) ///
         (rarea dgdp_qtrly_b1 dgdp_qtrly_b6 date, fcolor(forest_green%30) lcolor(forest_green%10) yaxis(2)) ///
         (tsline gdp_qtrly_p1, lc(dknavy) yaxis(2) ysc(r(0.86 1) axis(2)) ylab(0.86(0.02)1, axis(2)) tline($PIDdate, lc(black) lp(-))), ///
	     title("") legend(off) xtitle("") ///
	     note("Base IFR = `deltabar', Quarantine rate = `fquar'%. Total deaths by Jan. 1, 2021 = `fd',000") tlabel(#10, angle(45))
         graph export "$figpath/fan/`csfx'_`fIFRsv'_W_GDP_fan_`pltype'.png", replace
	  preserve
		keep date dwtot_b1-dwtot_b6 wtot_p1 deaths_weekly dgdp_qtrly_b1-dgdp_qtrly_b6 gdp_qtrly_p1
		save "$figpath/fan/`csfx'_`fIFRsv'_W_GDP_fan_`pltype'.dta", replace
	  restore
	 format date %td
	 dis ""
	 dis "--------------------------------------------------------------------------------------"
	 dis "           Case: `case'   k1 = " `k1'  "  fschool = " `fschool'   " fquar = " `fquar'
	 list date dtot_p1 wtot_p1 unrate_p1 gdp_p1 if day==1
	 dis "--------------------------------------------------------------------------------------"
    }
   }
 }
}
*
* Labor shock for calculation of GDP effect in nonlinear IO model (Beyond Hutlen)
if "`csfx'_`fIFRsv'" == "slow_SD3_100_s10_Q5_7_lshockQ3" {
 preserve
  keep iocode lshockQ3
  export excel using "out\slow_SD3_100_s10_Q5_7_lshockQ3" in 1/66, replace
 restore
}
