clear all
cap log close
cd "/Users//`=c(username)'/Dropbox/coronavirus/Code/BPEA_replication_code"
log using SEIRD_SEs_v2.txt, text replace
set more off 
set scheme s1color
pause on
************************************************************************************
* SEIRD_SEs_v3.do                    JS 6/15 - 7/26/20
*
* SEs for (calibrate) SEIRD model - R0, predicted deaths
*   v1: SEs by delta method
*   v2: plots for different assumed IFRs
*   v3: clean version for BPEA final draft
************************************************************************************
*
global outpath "../../Output/Epidemiology/Sheets"
global figpath "figs/estn"

* --------- Model parameters ------------
* latency and contagious periods
global sigma = exp(1/4.86)-1   // Mean of published studies (Adriano memo)
global gamma = exp(1/5)-1     // Kissler et al (Science, April 14 2020)

do NLSEIRD_PID_v12  // SEIRD model with time-varying contact matrices and PID controller, for nl estn
do NPI_setup_v5

* disable PID controller for estimation
global PIDdate "18May2021"
gen PID = 0
global ndate_PID = _N+1
local csfx ""
mkmat PID, mat(PID)

* disable derivatives
*mat delta_lshare = J(1,68,0)

* disable quarantine options
*global nremove = 0
* global tremove = "15Jul2021"
* cap drop e98
* gen e98 = tin(,$tremove)
* qui su e98
*  global ndate_remove = r(sum)
*gen qrate = 0 // quarantine rate

* Read in estimated parms from file
local parmfile "estn\Estd_parms_5_070620_BPEA_final_base.xlsx"
preserve
 qui import excel using `parmfile', sheet(parms) case(lower) clear
 mkmat *, mat(parms_all)
 mat parms = parms_all
 qui import excel using `parmfile', sheet(vcv) case(lower) clear
 mkmat *, mat(vecvcv_all)
 mat vecvcv = vecvcv_all
restore
*
* Evaluate derivatives over estimation period

global varout = 1
local np = rowsof(parms)
gen edates = 0
forvalues p = 1/`np' {
   cap drop dtot_p* wtot_p* 
	local nparms = parms[1,1]
    mat bhat = parms[`p',2..`nparms'+1]
	mat vtemp = vecvcv[`p',1...]'
    mata: st_matrix("vcv", colshape( st_matrix("vtemp")', 5) )
    mat list vcv
	*mat vcv = 9*vcv // test code
		
	global nedate1 = round(parms[`p',1+2*`nparms'+1],.01)
	global nedate2 = round(parms[`p',1+2*`nparms'+2],.01)
	global edate2 = date[$nedate2]
	global nedate3 = $nedate2
	global ndate_END = $nedate2
	
	 qui replace edates = (_n>=$nedate1)*(_n<=$nedate2)
    local R0 = round(parms[`p',1+2*`nparms'+3],.01)
    global deltabar = round(parms[`p',1+2*`nparms'+4],.001)
    global gamma = parms[`p',1+2*`nparms'+5]
    global sigma = parms[`p',1+2*`nparms'+6]
	local deltabar = $deltabar
    cap drop qrate
    gen qrate = 0 // quarantine rate - not used in estimation but needs to be defined
    * qui replace qrate = $gamma*`fquar'/100 if tin(01Jul2020,)
	
    *local beta = $gamma*`R0'/$maxReval0
    mat IFR = `deltabar'*IFR00 
    cap drop x99
    gen x99 = 0
	dis "here1"
    *============================================*
    nlseird_pid x99 if edates, at(bhat)
    *============================================*
	keep if tin(,$ENDdate)

    cap drop r0_p`p' 
    gen dtot_p`p' = Dtot
    gen wtot_p`p' = Wtot
    gen r0_p`p' = r0
    gen reff_p`p' = reff
	gen phifac_p`p' = phifac
	
    * compute derivatives and SEs wrt I0 and beta (not phi)
	global eps = 1e-2
	forvalues j = 1/`nparms' {
	 mat delbhat = J(1,colsof(bhat),0)
	 mat delbhat[1,`j'] = $eps
 	 mat bhat_eps = bhat + delbhat
     nlseird_pid x99 if edates, at(bhat_eps)
	 
	  cap drop wtot_eps`j' r0_eps`j' reff_eps`j' 
 	  qui gen wtot_eps`j' = (Wtot-wtot_p`p')/$eps
 	  qui gen r0_eps`j' = (r0-r0_p`p')/$eps
 	  qui gen reff_eps`j' = (reff-reff_p`p')/$eps
	}
    foreach vv in "wtot" "r0" "reff" {
     cap drop d`vv'_p`p'_*
 	 qui gen d`vv'_p`p'_se = 0
  	 forvalues j = 1/`nparms' {
	 	forvalues k = 1/`nparms' {
			qui replace d`vv'_p`p'_se = d`vv'_p`p'_se  + `vv'_eps`j'*`vv'_eps`k'*vcv[`j',`k']
		}
	 }
	 qui replace d`vv'_p`p'_se = sqrt(d`vv'_p`p'_se)
	 qui gen d`vv'_p`p'_q05 = `vv'_p`p' - 1.96*d`vv'_p`p'_se
	 qui gen d`vv'_p`p'_q10 = `vv'_p`p' - 1.28*d`vv'_p`p'_se
	 qui gen d`vv'_p`p'_q33 = `vv'_p`p' - d`vv'_p`p'_se
	 qui gen d`vv'_p`p'_q67 = `vv'_p`p' + d`vv'_p`p'_se
	 qui gen d`vv'_p`p'_q90 = `vv'_p`p' + 1.28*d`vv'_p`p'_se
	 qui gen d`vv'_p`p'_q95 = `vv'_p`p' + 1.96*d`vv'_p`p'_se
	}
}	
keep if tin(01Mar2020,$t0_deaths)
format date %tdmD
/*  twoway (rarea dwtot_q33 dwtot_q67 date, fcolor(red%60) lcolor(red%30)) ///
         (rarea dwtot_q10 dwtot_q90 date, fcolor(red%45) lcolor(red%10)) ///
         (rarea dwtot_q05 dwtot_q95 date, fcolor(red%30) lcolor(red%10)) ///
         (tsline wtot_p1 deaths_weekly, lc(cranberry black) lp(l _) ytitle(Thousands)), ///
	     title("Weekly deaths, predicted and actual") legend(off) xtitle("") ///
	     note("67%, 90%, 95% confidence bands. Actual weekly deaths shown in black dashed") tlabel(#10, angle(45))
         *graph export "estn/wtot_SE.png", replace
*/
cap drop reffhat*
*gen reffhat = 1 + (1/(1/7 + .0007))*((deaths_daily-L7.deaths_daily)/7)/(deaths_weekly/7) 
gen reffhat = 1 + (1/(1/9.86 + .0007))*((deaths_daily-L7.deaths_daily)/7)/(deaths_weekly/7) // 9.86 = latency period + infectious period in the SIEQRD model
lpoly reffhat obsno, bw(14) at(obsno) gen(reffhat_poly) se(reffhat_poly_se) degree(2)
gen reffhat_poly_q05 = reffhat_poly - 1.96*reffhat_poly_se
gen reffhat_poly_q95 = reffhat_poly + 1.96*reffhat_poly_se

  loca nplag = 14 // plot lag of deaths to account for lag in death reporting + longer non-Markov lags in infections to deaths
  local vv "reff"
  twoway (rarea d`vv'_p1_q05 d`vv'_p1_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p1 , lc(cranberry ) ) ///
         (rarea d`vv'_p2_q05 d`vv'_p2_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p2 , lc(cranberry ) ) ///
         (rarea d`vv'_p3_q05 d`vv'_p3_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p3 , lc(black     ) ) ///
         (rarea d`vv'_p4_q05 d`vv'_p4_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p4 , lc(cranberry ) ) ///
         (rarea d`vv'_p5_q05 d`vv'_p5_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p5 , lc(cranberry ) ) ///
         (rarea d`vv'_p6_q05 d`vv'_p6_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p6 , lc(cranberry ) ) ///
         (rarea d`vv'_p7_q05 d`vv'_p7_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p7 , lc(cranberry ) ) ///
         (rarea d`vv'_p8_q05 d`vv'_p8_q95 date, fcolor(red%45) lcolor(red%30)) (tsline `vv'_p8 , lc(cranberry ) ) ///
		 (rarea F`nplag'.reffhat_poly_q05 F`nplag'.reffhat_poly_q95 date if tin(08Mar2020,05Jul2020), fcolor(teal%60) lcolor(teal%30)) ///
		 (tsline F`nplag'.reffhat_poly if tin(08Mar2020,05Jul2020), lc(navy) yline(1, lc(black) lp(-)) ), ///
	     title("R-effective: Model and nonparametric estimates") legend(off) xtitle("") ///
	     note("95% confidence bands. Nonparametric estimate is estimated directly from growth rate of daily" ///
		     "deaths, smoothed using a local quadratic regression smoother (`nplag' day lag).") tlabel(#10, angle(45))
          graph export "figs/estn/Reff_SE.png", replace
*/
keep dreff_p1_q05 dreff_p1_q95 reff_p1 ///
	 dreff_p2_q05 dreff_p2_q95 reff_p2 ///
	 dreff_p3_q05 dreff_p3_q95 reff_p3 ///
	 dreff_p4_q05 dreff_p4_q95 reff_p4 ///
	 dreff_p5_q05 dreff_p5_q95 reff_p5 ///
	 dreff_p6_q05 dreff_p6_q95 reff_p6 ///
	 dreff_p7_q05 dreff_p7_q95 reff_p7 ///
	 dreff_p8_q05 dreff_p8_q95 reff_p8 ///
	 reffhat_poly reffhat_poly_q05 reffhat_poly_q95 date 
save "figs/estn/Reff_SE", replace

log close

