* Program NLSEIRD_PID
*  SEIRD simulation with:
*       time-varying contact matrices
*       parameter estimation (command nl) over edates
*       PID controller
*       Estimation of intensity parameter (phi) for active NPI dates
*       First date is Feb 21, 2020
*  v12: Clean version for BPEA final draft
*
cap program drop nlseird_pid
program nlseird_pid
 version 16
 syntax varlist(min=1 max=1) if, at(name)
 local dout: word 1 of `varlist'
 tempname I0 phi0 phi1 phi2 beta
 scalar `I0' = 1000*`at'[1,1]
 scalar `phi0' = `at'[1,2]
 scalar `phi1' = `at'[1,3]
 scalar `phi2' = `at'[1,4]
 scalar `beta' = `at'[1,5]
 mat list `at'
 cap drop phifac et
 gen phifac = 1
 local tt = $nedate2 - 19
 global tt = `tt'
 gen et = _n-19
  replace phifac = `phi0' + `phi1'*cos(_pi*(et+0.5)/`tt') + `phi2'*cos(_pi*2*(et+0.5)/`tt') in 19/$nedate2 // introduce measures on March 10 (obs 19)
  replace phifac = normprob(phifac) in 19/$nedate2
   qui su phifac in $nedate3/$nedate3 
    qui replace phifac = r(mean) in $nedate3/l
 *
 local ndates $ndate_END
 local nage = $nage
 local gamma = $gamma
 local sigma = $sigma
 mat delta = J(`nage',1,0)
 forvalues i = 1/`nage' {
  mat delta[`i',1] = `gamma'*IFR[`i',1]/(1-IFR[`i',1])
 }
 local stepsperday = 10

 local DELTA = 1/`stepsperday'
 mat S = J(`ndates',`nage',0)
 mat E = S
 mat I = S
 mat R = S
 mat D = S
 mat Q = S
 mat Dtot = J(`ndates',1,0)
 mat In1 = `I0'*I00
 mat En1 = 4*In1
 mat Sn1 = Nvec - In1 - En1
 mat Rn1 = J(`nage',1,0)
 mat Dn1 = J(`nage',1,0)
 mat Qn1 = J(`nage',1,0)
 mat r0 = J(`ndates',1,0)
 mat r0_approx = J(`ndates',1,0)
 mat cfacc = J(`ndates',1,1)
 mat maxReval = maxReval_input
 mat lshock = lshock_npi
 *mat lshare = lshare_npi
 mat gdp = lshock[1...,1..66]*psi
 mat emp0 = J(1,rowsof(emp_count_tot),1)*emp_count_tot
  global emp0 = emp0[1,1]
 mat unrate = J(`ndates',1,1) - lshock[1..`ndates',1...]*emp_count_tot/$emp0
 mat g = J(68,1,0)
 local ndate_PIDm1 = $nedate3
 local ndate_PIDmin = 52 // set worst-case hours to be hours in April Establishment Survey (obs 52 = 12Apr2020)
 forvalues d = 1/`ndates' {
  if $nage==1 {
   mat cmat = maxReval[`d'] // for 1-age model, sequence of NPIs is reduced to scalar
   if npimat[`d',1]<1 {
     mat cmat = `phi0'*cmat
   }
  }
  if $nage>1 {
   if PID[`d',1]==0 {
   * Historical component (for estimation) before controller
   * today's contact matrix
    mat cwork = J(5,5,0)
    mat cother = J(5,5,0)
    mat chome = J(5,5,0)
    forvalues a = 1/5 {
     mat cwork[`a',1]  = cmwx`a'[`d']*cnwork_mean[`a',1...] 
	 mat cother[`a',1] = cmox`a'[`d']*cother_mean[`a',1...]
     mat chome[`a',1]  = cmhx`a'[`d']*chome_mean[`a',1...]
    }
    mat cmat = ($hHH + (1-$hHH)*phifac[`d'])*chome + phifac[`d']*(cother + cwork)
   }
  }
  if PID[`d',1]==1 {
   * State variables for controller 
   mat unratem1 = J(1,$dlag,1)*unrate[`d'-$dlag..`d'-1,1]/$dlag // avge unemployment rate over last $dlag days
   mat unratecum = J(1,`d'-1,1)*unrate[1..`d'-1,1] // cumulative unemployment rate (units: pp-days)
   mat dDtot = (Dtot[`d'-1,1]-Dtot[`d'-3,1])/2 // average daily deaths, last 2 days
   mat ddDtot = ( dDtot  - (Dtot[`d'-$dlag-1,1]-Dtot[`d'-$dlag-3,1])/2 )/$dlag
   * Controller
   mat cfacc[`d',1] = $ku*unratem1 + $kiu*unratecum - $kp*dDtot - $kd*ddDtot
   if `d'==$ndate_PID {
   * compute intercept so employment(t) = employment(t-1) for t first date of controller
	mat dL   = (lshock[`ndate_PIDm1',1...] - lshock[`ndate_PIDmin',1...])*emp_count_tot
	mat alphabar = cfacc[`d',1] + $k1*(theta_gdp'*J(68,1,1)/68)
	mat xbar = (lshockmax' - lshock[`ndate_PIDmin',1...])*emp_count_tot
	local mu0 = normprob(dL[1,1]/xbar[1,1]) - alphabar[1,1]
	* iterate on intercept using Taylor series first order condition 
	forvalues kk = 1/5 {
		local dx0 = 0
		local dx1 = 0
		forvalues i = 1/68 {
			local xi = (lshockmax[`i',1]-lshock[`ndate_PIDmin',`i'])*emp_count_tot[`i',1]
			local dx0 = `dx0' +  normprob(cfacc[`d',1] + $k1*theta_gdp[`i'] + `mu0')*`xi'
			local dx1 = `dx1' + normalden(cfacc[`d',1] + $k1*theta_gdp[`i'] + `mu0')*`xi'
		}
		local mu0 = `mu0' + (dL[1,1] - `dx0')/`dx1' // shift in controller by sector to equate initial value of controller to final value of historical on average
	}
	local mu = `mu0'
	}
	mat dlshock = ( (Q[`d'-1,1...]-Q[`d'-2,1...]) + (D[`d'-1,1...]-D[`d'-2,1...]) )*Lvec/N // prior-day net worker flows into being unable to work = Q + D, proportional to epop
	forvalues i = 1/68 {
	 mat g[`i',1] = normprob( cfacc[`d',1] + $k1*theta_gdp[`i'] + `mu' )
     local lsmaxi = 1
	 forvalues a = 1/5 {
 	  local lsmaxi = `lsmaxi' - (1-wfh_share[`i'])*(1-selage[`a',1])*emp_count`a'[`i']/emp_count_tot[`i']
     }
	 local lsmaxi = min(`lsmaxi',lshockmax[`i',1]) // Age-restricted workers work from home in proportion to sector's ability, possibly restricting sectoral employment
	 mat lshock[`d',`i'] = lshock[`ndate_PIDmin',`i'] + g[`i',1]*(`lsmaxi'-lshock[`ndate_PIDmin',`i'] ) // asymptote to lshock_max employment by sector (taste shift)
	 mat lshock[`d',`i'] = lshock[`d',`i'] - (dlshock[1,1]/$Ltot)*epop[`i',1]*(N/$Ltot)
	 if `d'>=186 {  // School opens (or not) on Aug 24
	  mat lshock[`d',`i'] = min(lshock[`d',`i'],1 - 0.067*(1-school_frac[`d'])) // 6.7% of workers have childcare obligations Dingel-Patterson-Vavra (April 2020 Table 1)
	 }
	}
    mat unrate[`d',1] = 1 - lshock[`d',1...]*emp_count_tot/$emp0
	mat gdp[`d',1] = lshock[`d',1..66]*psi
    * Construct contact matrices
    mat cwork=J(5,5,0)
    forvalues a = 1/5 {
     sca scmwx`a' = 0
     forvalues i = 1/68 {
      sca scmwx`a' = scmwx`a' + lshock[`d',`i']*(1-wfh_frac[`d']*wfh_share[`i'])*epop`a'[`i']*pp_rel`a'[`i']
     }
     mat cwork[`a',1] = (phifac[`ndate_PIDm1']+sdwork_fac[`d']*(1-phifac[`ndate_PIDm1']))*selage[`a',1]*scmwx`a'*cnwork_mean[`a',1...] 
    }
	* Other contacts: 20+ reengage in shopping in proportion to production (supply = demand), with protections that can be relaxed
	mat cother_1  =  (phifac[`ndate_PIDm1'] + sdoth_fac1[`d']*(1-phifac[`ndate_PIDm1'])) * ($o1ns + school_frac[`d']*(1-$o1ns)) * cother_mean1
	mat cother_24 =  (phifac[`ndate_PIDm1'] + sdoth_fac24[`d']*(1-phifac[`ndate_PIDm1'])) ///
				   * (gmio[`ndate_PIDm1'] + ((gdp[`d',1]-gdp[`ndate_PIDm1',1])/gdp[1,1])*(gmio[1]-gmio[`ndate_PIDm1'])) * cother_mean24 
	mat cother_5  =  (phifac[`ndate_PIDm1'] + sdoth_fac5[`d']*(1-phifac[`ndate_PIDm1'])) ///
				   * (gmio[`ndate_PIDm1'] + ((gdp[`d',1]-gdp[`ndate_PIDm1',1])/gdp[1,1])*(gmio[1]-gmio[`ndate_PIDm1'])) * cother_mean5
	mat cother = cother_1 + cother_24 + cother_5
    mat chome = ( $hHH + (1-$hHH)*(phifac[`ndate_PIDm1']+sdhome_fac[`d']*(1-phifac[`ndate_PIDm1'])) )*chome_mean 
	mat chome[5,1] = home_fac5[`d']*chome[5,1...]
    mat cmat = chome + cother + cwork
  }
  if `d'==163 {
  	mat ctot_Aug1 = cmat
  }
  if `d'==238 {
  	mat ctot_Oct15 = cmat
  }
  mat cmat = hadamard(cmat_adjust_kids,cmat) // adjust for reduced transmission rates to/from/between kids
  mat cnormalized = hadamard(cmat,Nvecinv*Nvec')
  mat eigenvalues r c = cnormalized
  mat maxReval[`d',1] = r[1,1]
  mat r0_approx[`d',1] = `beta'*maxReval[`d',1]/`gamma' // version used through v8
  mat cnormBetaGamma = J(5,5,0)
  forvalues i = 1/5 {
   forvalues j = 1/5 {
    mat cnormBetaGamma[`i',`j'] = `beta'*cnormalized[`i',`j']/(`gamma' + delta[`j',1])
   }
  }
  mat eigenvalues r c = cnormBetaGamma
  mat r0[`d',1] = r[1,1] // correct with age-based delta and beta
  forvalues i = 1/`stepsperday' {
   mat dQshock = J(`nage',1,0)
   * Simulate removal of 1000 infected
   if (`d'==$ndate_remove)*(`i'==`stepsperday') {
    mat dQshock = $nremove*Nvec/N
   }
   mat dS = -`DELTA'*`beta'*hadamard(Sn1,cmat*hadamard(In1,Nvecinv))
   mat dE = -dS - `DELTA'*`sigma'*En1
   mat dQ = -`DELTA'*`gamma'*Qn1 - `DELTA'*hadamard(delta,Qn1) + `DELTA'*qrate[`d']*In1 + dQshock
   mat dR = `DELTA'*`gamma'*In1 + `DELTA'*`gamma'*Qn1
   mat dD = `DELTA'*hadamard(delta,In1) + `DELTA'*hadamard(delta,Qn1)
   mat dI = `DELTA'*`sigma'*En1 - `DELTA'*`gamma'*In1 - `DELTA'*hadamard(delta,In1) - `DELTA'*qrate[`d']*In1 - dQshock
   mat Sn = Sn1 + dS
   mat En = En1 + dE
   mat In = In1 + dI
   mat Qn = Qn1 + dQ
   mat Rn = Rn1 + dR
   mat Dn = Dn1 + dD
   mat Sn1 = Sn
   mat En1 = En
   mat In1 = In
   mat Qn1 = Qn
   mat Rn1 = Rn
   mat Dn1 = Dn
  }
  mat S[`d',1] = Sn'
  mat E[`d',1] = En'
  mat I[`d',1] = In'
  mat Q[`d',1] = Qn'
  mat R[`d',1] = Rn' 
  mat D[`d',1] = Dn'
  mat Dtot[`d',1] = D[`d',1...]*J(5,1,1)
 }
 foreach m in "S" "E" "I" "Q" "R" "D" {
  mat `m'tot = `m'*J(`nage',1,1)
 }
 mat rr = r0
 mat lIdot = 0*r0
 forvalues d = 4/`ndates' {
  mat rr[`d',1] = 1 + (1/`gamma')*( (Itot[`d',1]-2*Itot[`d'-1,1]+Itot[`d'-1,1])/(Itot[`d',1]-Itot[`d'-2,1]) )
 }
 * create useful matrices
 local nm7 = rowsof(D)-7
 mat W = D - (J(7,colsof(D),0)\D[1..`nm7',1...]) 
 mat reff = hadamard(r0,Stot/N)
 mat rreff = hadamard(rr,Stot/N)
 mat Dtot = D*J(colsof(D),1,1)
 mat Wtot = W*J(colsof(D),1,1)
 mat Rtot = R*J(colsof(D),1,1)
 global IFR_sim = Dtot[rowsof(Dtot),1]/Rtot[rowsof(Dtot),1]
 cap drop Dtot Dtot1
 svmat Dtot, names(Dtot)
 qui replace Dtot = Dtot1/1000    // all counts in thousands
 cap drop Wtot Wtot1
 svmat Wtot, names(Wtot)
 qui replace Wtot = Wtot1/1000    // all counts in thousands
 qui replace `dout' = Wtot `if'  // estimate using weekly deaths
 mat gdp = gdp/gdp[1,1]
 *
if $varout==1 {
  * optionally, turn model output matrices into Stata variables
 foreach v in "S" "E" "I" "Q" "R" "D" "W" {
   cap drop `v'*
   svmat `v', names(`v')
   qui gen `v'tot = 0
   forvalue i = 1/`nage' {
    qui replace `v'`i' = `v'`i'/1000  // save in thousands
    qui gen `v'shr`i' = `v'`i'/(Nvec[`i',1]/1000)
    qui replace `v'tot = `v'tot + `v'`i'
   }
   qui gen `v'shrtot = `v'tot/(N/1000)
   if `nage'==5 {
    foreach w in "" "shr" {
     label var `v'`w'1 "<20"
     label var `v'`w'2 "20-44"
     label var `v'`w'3 "45-64"
     label var `v'`w'4 "65-74"
     label var `v'`w'5 "75+"
     label var `v'`w'tot "All ages"
    }
   }
  }
  foreach r in "rr" "r0" "reff" "rreff" "unrate" "gdp" {
   cap drop `r'
   svmat `r', names(`r')
   qui rename `r'1 `r'
  }
  mat list IFR
  dis "gamma " `gamma'
  dis "beta " `beta'
  dis "sigma " `sigma'
  dis "IFR_sim " $IFR_sim
 }
end
