
global files "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\Paper\Replicate"


/*-----------------
Figure 1: Risk Factors
------------------*/
loc run = 1
if `run' == 1{

use "$files\covid_0715.dta", clear

gen tests_pth = exp(ln_tests)

gen inc = .
replace inc = 1 if incomelevel=="LIC"
replace inc = 2 if incomelevel=="LMC"
replace inc = 3 if incomelevel=="UMC"
replace inc = 4 if incomelevel=="HIC"

lab def income 1 "Low-income" 2 "Lower-middle income" 3 "Upper-middle income" 4 "High income"
lab val inc income

graph bar (mean)  mr_test_positive , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ytitle("") ///
  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 20) lstyle(none))   ///
title("") subtitle("Positive test ratio (%)")

graph save "test_positive.gph", replace
//graph export "test_positive.pdf", replace

graph bar (mean)  over70 , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ytitle("") ///
bar(1, color(cranberry))  bar(2, color(cranberry))  bar(3, color(cranberry))  bar(4, color(cranberry)) ///
  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 20) lstyle(none))   ///
title("") subtitle("Population over age 70 (%)")

graph save "over70.gph", replace
//graph export "over65.eps", replace

graph bar (mean)  obesity1 , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ytitle("") ///
bar(1, color(cranberry))  bar(2, color(cranberry))  bar(3, color(cranberry))  bar(4, color(cranberry)) ///
  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 30) lstyle(none))   ///
title("") subtitle("Obesity prevalence (% of adults)")

graph save "obesity.gph", replace
//graph export "obesity.eps", replace

graph bar (mean)  dayslockdown  , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
ytitle("")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 65) lstyle(none))   ///
title("") subtitle("Days before first death that action is taken")

graph save "lockdown.gph", replace
//graph export "lockdown.eps", replace

graph bar (mean)  tests_pth  , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
ytitle("")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 32) lstyle(none))   ///
title("") subtitle("COVID-19 tests per thousand people")

graph save "tests.gph", replace
//graph export "tests.pdf", replace

graph combine "over70.gph" "obesity.gph"  , rows(1) scale(.81) graphregion(color(white)) xsize(12) ysize(6) subtitle("average by income group") title("Risk Factors for Severe COVID-19 Illness", color(black) )
graph save "comb1.gph", replace
graph combine  "lockdown.gph" "test_positive.gph" , rows(1) scale(.81) graphregion(color(white)) xsize(12) ysize(6) subtitle("average by income group") title("Public Health Response", color(black) )
graph save "comb2.gph", replace

graph combine "comb1.gph" "comb2.gph" , col(1) graphregion(color(white)) xsize(12) ysize(12) 

graph export "$files\summary.png", replace
graph export "$files\summary.eps", replace
}

/*EX China
loc run = 0
if `run' == 1{

use "$files\covid_0715.dta", clear
drop if countrycode=="CHN"

gen tests_pth = exp(ln_tests)

gen inc = .
replace inc = 1 if incomelevel=="LIC"
replace inc = 2 if incomelevel=="LMC"
replace inc = 3 if incomelevel=="UMC"
replace inc = 4 if incomelevel=="HIC"

lab def income 1 "Low-income" 2 "Lower-middle income" 3 "Upper-middle income" 4 "High income"
lab val inc income

graph bar (mean)  mr_test_positive , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ytitle("") ///
  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 20) lstyle(none))   ///
title("") subtitle("Positive test ratio (%)")

graph save "test_positive.gph", replace
graph export "test_positive.pdf", replace

graph bar (mean)  over70 , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ytitle("") ///
bar(1, color(cranberry))  bar(2, color(cranberry))  bar(3, color(cranberry))  bar(4, color(cranberry)) ///
  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 20) lstyle(none))   ///
title("") subtitle("Population over age 70 (%)")

graph save "over70.gph", replace
//graph export "over65.eps", replace

graph bar (mean)  obesity1 , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ytitle("") ///
bar(1, color(cranberry))  bar(2, color(cranberry))  bar(3, color(cranberry))  bar(4, color(cranberry)) ///
  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 30) lstyle(none))   ///
title("") subtitle("Obesity prevalence (% of adults)")

graph save "obesity.gph", replace
//graph export "obesity.eps", replace

graph bar (mean)  dayslockdown  , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
ytitle("")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 65) lstyle(none))   ///
title("") subtitle("Days before first death that action is taken")

graph save "lockdown.gph", replace
//graph export "lockdown.eps", replace

graph bar (mean)  tests_pth  , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
ytitle("")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 32) lstyle(none))   ///
title("") subtitle("COVID-19 tests per thousand people")

graph save "tests.gph", replace
//graph export "tests.pdf", replace

graph combine "over70.gph" "obesity.gph"  , rows(1) scale(.81) graphregion(color(white)) xsize(12) ysize(6) subtitle("average by income group") title("Risk Factors for Severe COVID-19 Illness", color(black) )
graph save "comb1.gph", replace
graph combine  "lockdown.gph" "test_positive.gph" , rows(1) scale(.81) graphregion(color(white)) xsize(12) ysize(6) subtitle("average by income group") title("Public Health Response", color(black) )
graph save "comb2.gph", replace

graph combine "comb1.gph" "comb2.gph" , col(1) graphregion(color(white)) xsize(12) ysize(12) 

graph export "$files\summary_exCHN.png", replace
graph export "$files\summary_exCHN.pdf", replace
}*/



/*-------------------------------------
Figure 2: Cumulative Deaths Graph


loc run = 0
if `run' == 1{

wbopendata, indicator(SP.POP.TOTL) clear
keep countrycode incomelevel* lendingtype* region*
duplicates drop
sort countrycode
tempfile groups
save `groups'

import delimited "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\raw\owid-covid-data_0715.csv", varnames(1) clear

gen date2 = date(date,"MDY",2050)
drop date
rename date2 date

rename iso_code countrycode
sort countrycode date
merge m:1 countrycode using `groups'
drop if _m==2
drop _m

save "$files\deaths_chart.dta", replace
}
---------------------------------------*/

loc run = 1
if `run' == 1{

use "$files\deaths_chart.dta", clear

replace incomelevel = "CHN" if countrycode=="CHN"
replace incomelevel = "UMCexCHN" if incomelevel=="UMC"

//replace incomelevel = "USA" if countrycode=="USA"
//replace incomelevel = "HICexUSA" if incomelevel=="HIC"

//replace incomelevel = "IND" if countrycode=="IND"
//replace incomelevel = "LMCexIND" if incomelevel=="LMC"

collapse (sum) total_deaths population, by(incomelevel date)
gen dpm = (total_deaths/population)*1000000

drop if incomelevel==""
keep dpm incomelevel date
reshape wide dpm, i(date) j(incomelevel) string

tsset date
format date %td
drop if date<21946 //Start in Feb
//drop if date == 22086 
replace dpmHIC = 274.92108 if date==22110 //Data gap

tsline dpmHIC dpmUMCexCHN dpmLMC dpmLIC dpmCHN, color(cranberry maroon lavender navy dkorange forest_green) ///
title("") ytitle("") xtitle("") tlabel( 1feb2020 1mar2020 1apr2020 1may2020 1jun2020 1jul2020) title("Total COVID-19 deaths per milllion people", color(black)) scale(0.8) graphregion( color(white)) bgcolor(white) ///
legend( rows(3) label( 1 "High income countries") label(2 "Upper-middle income countries (ex-China)")   ///
        position(12)  label( 3 "Lower-middle income countries") label( 4 "Low-income countries")   ///
		label( 5 "China" )  ) ///

graph export "$files\cumulative_death.png", replace
graph export "$files\cumulative_death.eps", replace

}

/*-------------------------
Figure 3: Death Scatter
-------------------------*/

loc run = 1
if `run' == 1{

use "$files\covid_0715.dta", clear

levelsof ln_deaths if countrycode=="USA"
gen ln_deaths_v_US = ln_deaths - `r(levels)'

levelsof mr_ln_gdppc if countrycode=="USA"
gen ln_gdppc_v_US = mr_ln_gdppc - `r(levels)'

twoway  ///
(scatter ln_deaths_v_US ln_gdppc_v_US, mcolor(black) ) (lfit ln_deaths_v_US ln_gdppc_v_US, lcolor(black) lpattern(shortdash) ),  graphregion(color(white)) ///
xtitle("GDP per capita (USA = 1) ")  ytitle("COVID-19 deaths per million people (USA = 1)") ///
legend(off) ///
ylabel(-9.7040605 "0" -8.3177662 "1/4096" -6.9314718 "1/1024" -5.5451774 "1/256"  -4.1588831 "1/64"  -2.7725887 "1/16"  -1.3862944 "1/4"  0 "1" 1.3862944 "4", angle(horizontal)) ///
xlabel( -5.5451774 "1/256" -4.1588831 "1/64" -2.7725887 "1/16" -1.3862944 "1/4" 0 "1" 1.3862944 "4")
graph export "$files\scatter.pdf", replace
graph export "$files\scatter.png", replace

}

