
global files "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\Paper\Replicate"


import excel "$files\daily_em_portfolio_flows_database 0714.xlsx", sheet("Weekly Portfolio Flows Data") cellrange(A4:AE815) firstrow clear

rename A date
rename WeeklyTotal flows

//Malaysia Argentina Egypt Nigeria 
egen flows_subset = rsum(Brazil China India Indonesia  Mexico SaudiArabia SouthAfrica Ukraine )

gen month = month(date)
gen year = year(date)

drop date
gen date = ym(year,month)

keep date flows*

collapse (sum) flows flows_subset, by(date)
replace flows_subset= flows_subset/1000
format date %tm

keep if date>=600

drop if date==.

format flows %12.0f
twoway (bar flows date, color(cranberry) ) , ///
  xtitle(" ") ytitle("US$ billions") title("Non-resident purchases (sales) of EM stocks and bonds", color(black)) ///
  graphregion(color(white)) bgcolor(white) /// 
  legend( off ) text(-65 709 "March 2020 →") ///
  scale(0.9)
 
  graph export "$files\portfolio.png", replace
  graph export "$files\portfolio.eps", replace
  
 /* twoway (bar flows_subset date, color(cranberry) ) , ///
  xtitle(" ") ytitle("US$ billions") title("Net non-resident purchases (sales) of EM stocks and bonds", color(black)) ///
  graphregion(color(white)) bgcolor(white) /// 
  legend( off ) text(-30 709 "March 2020 →") ///
  scale(0.9)
 
  graph export "$files\portfolio2.png", replace*/
