
/*--------------------------------
GDP Charts using Haver Data
---------------------------------*/

global files "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\Paper\Replicate"


//First Case Date
preserve
use "$files\first_case_date.dta", clear
keep countryname countrycode first_case_date_p0
drop if countryname==""
sort countryname
tempfile first
save `first'
restore

import excel "$files\Q1 macro data for Covid paper_05082020.xlsx", sheet("GDP Growth TX") firstrow clear

split Country, parse(":") limit(1)
rename Country1 countryname
keep countryname Q*
drop Q Q42018
keep if Q12020!=.

reshape long Q, i(countryname) j(quarter)

tostring quarter, replace
gen q = substr(quarter,1,1)
gen y = substr(quarter,2,4)
destring q, replace
destring y, replace
gen qtr = yq(y,q)
format qtr %tq

replace countryname = "United States" if countryname=="U.S."
replace countryname = "Korea, Rep." if countryname=="South Korea"

keep countryname Q qtr 
rename Q GDP
sort countryname
merge m:1 countryname using `first'

replace countrycode="EU27" if countryname=="EU 27"

drop if _m==2 & countrycode!="EU27"
drop _m

gen early = (first_case_date_p0<date("February 15, 2020","MDY")) | countrycode=="EU27"
drop if first_case_date_p0==. & countrycode!="EU27"

//Early Chart
preserve
keep if early==1
keep GDP qtr countrycode
reshape wide GDP, i(qtr) j(countrycode) string

lab var GDPPHL "Philippines"
lab var GDPCHN "China"
lab var GDPKOR "South Korea"
lab var GDPUSA "United States"
lab var GDPITA "Italy"

tsset qtr

* get positions for explanatory text from latest value
loc textdate = 240+0.05

foreach v of varlist GDPCHN GDPKOR GDPUSA GDPPHL GDPITA { 
     su `v' if qtr == 240, meanonly 
	 local name: variable label `v'	
	 if "`v'" == "GDPPHL" {
	     loc m = `r(mean)'-.0015
		local call `call' text(`m' `textdate' "`name'",  place(r))
     }
	 else if "`v'" == "GDPUSA" {
	     loc m = `r(mean)'+.0015
		local call `call' text(`m' `textdate' "`name'",  place(r))
     }
	 else{
		local call `call' text(`r(mean)' `textdate' "`name'",  place(r))
	 }
     
} 

tsline  GDPCHN GDPKOR GDPUSA GDPPHL GDPITA, `call' lpattern(solid dash vshortdash longdash_dot dot) lcolor(black black black black black) ///
title("") ttitle("") ytitle("") scale(0.9) title("Countries with first case before February 15", color(black)) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(236 241.25))

graph save "$files\early_gdp.gph", replace
restore

//Late Chart
preserve
keep if early==0
keep GDP qtr countrycode
reshape wide GDP, i(qtr) j(countrycode) string


lab var GDPIDN "Indonesia"
lab var GDPMAR "Morocco"
lab var GDPMEX "Mexico"
lab var GDPVNM "Vietnam"

tsset qtr

* get positions for explanatory text from latest value
loc textdate = 240+0.05

loc call 
foreach v of varlist GDPIDN GDPMAR GDPMEX GDPVNM { 
     su `v' if qtr == 240, meanonly 
	 local name: variable label `v'	
	/* if "`v'" == "GDPPHL" {
	     loc m = `r(mean)'-.0015
		local call `call' text(`m' `textdate' "`name'",  place(r))
     }
	 else if "`v'" == "GDPUSA" {
	     loc m = `r(mean)'+.0015
		local call `call' text(`m' `textdate' "`name'",  place(r))
     }
	 else{*/
		local call `call' text(`r(mean)' `textdate' "`name'",  place(r))
// }
     
} 

tsline  GDPIDN GDPMAR GDPMEX GDPVNM , `call' lpattern(dash_dot  shortdash_dot longdash tight_dot) lcolor(black black black black ) ///
title("") ttitle("") ytitle("") scale(0.9) title("Countries with first case after February 15", color(black) ) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(236 241))

graph save "$files\late_gdp.gph", replace
restore
 
cd "$files"
graph combine "early_gdp.gph" "late_gdp.gph", title("", color(black))  ycommon row(1) xsize(16) ysize(9) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white)) ///
title("Real Gross Domestic Product")

graph export "$files\gdp.png", replace
graph export "$files\gdp.eps", replace
