/*-------------------------
Macro Figures
--------------------------*/

global files "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\Paper\Replicate"

loc firstdate = 21946 //February 1
local lastdate = 22109 // July 13

//Strip Spreads
loc run = 1
if `run' == 1{

//Corporates
import delimited "$files\cembi_0714.csv", clear 
gen date2 = date(date,"MDY",2050)
drop date
rename date2 date
format date %td
drop if date<`firstdate'
drop if date>`lastdate'

loc countries brazil china india indonesia mexico nigeria philippines 

lab var brazil "Brazil"
lab var china "China"
lab var indonesia "Indonesia"
lab var india "India"
lab var mexico "Mexico"
lab var nigeria "Nigeria"
lab var philippines "Philippines"
lab var russia "Russia"

tsset date

* get positions for explanatory text from latest value
loc textdate = `lastdate'+1

loc call
foreach v of varlist `countries' { 
     su `v' if date == `lastdate' , meanonly 
	 local name: variable label `v'
	 if "`v'" == "nigeria" {
	    loc m = `r(mean)'+12
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "indonesia" {
	    loc m = `r(mean)'+10
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "india" {
	    loc m = `r(mean)'+20
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "mexico" {
	    loc m = `r(mean)'-13
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "china" {
	    loc m = `r(mean)' -28
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else{
	    local call `call' text(`r(mean)' `textdate' "`name'",  place(r)) 
 	 }
} 

tsline `countries' , `call' color(navy cranberry maroon  teal dkorange forest_green  lavender ) ///
title("") ytitle("") xtitle("") title("Corporates", color(black)) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(1feb2020 15aug2020)) ///
tline(23mar2020, lcolor(gs8) lpattern(longdash))  ///ttext(0 10feb2020 "G20 Conference Call") ttext(0 10mar2020 "G20 Debt Forgiveness") 
tline(15apr2020, lcolor(gs8) lpattern(longdash))  

graph save "$files\spreads1.gph", replace 

//Sovereign Bonds
import delimited "$files\embig_0714.csv", clear 
gen date2 = date(date,"MDY",2050)
drop date
rename date2 date
format date %td
drop if date<`firstdate' 

loc countries brazil china ethiopia india indonesia  mexico nigeria pakistan philippines  

lab var brazil "Brazil"
lab var china "China"
lab var ethiopia "Ethiopia"
lab var indonesia "Indonesia"
lab var india "India"
lab var mexico "Mexico"
lab var nigeria "Nigeria"
lab var pakistan "Pakistan"
lab var philippines "Philippines"
lab var russia "Russia"

tsset date

* get positions for explanatory text from latest value
loc textdate = `lastdate'+1

loc call 
foreach v in `countries' { 
     su `v' if date == `lastdate' , meanonly 
	 local name: variable label `v'
	 if `v' == indonesia{
	    loc m = `r(mean)'+15
		local call `call' text(`m' `textdate' "`name'",  place(r))
		}
	 else if `v' == india{
	    loc m = `r(mean)'-5
		local call `call' text(`m' `textdate' "`name'",  place(r))
		}	
	 else if `v' == ethiopia{
	    loc m = `r(mean)'
		local call `call' text(`m' `textdate' "`name'",  place(r))
		}
	 else if `v' == pakistan{
	    loc m = `r(mean)'
		local call `call' text(`m' `textdate' "`name'",  place(r))
		}
	 else if `v' == china{
	    loc m = `r(mean)'-10
		local call `call' text(`m' `textdate' "`name'",  place(r))
		}	
	 else if `v' == philippines{
	    loc m = `r(mean)'
		local call `call' text(`m' `textdate' "`name'",  place(r))
		}
	 else{
		local call `call' text(`r(mean)' `textdate' "`name'",  place(r))  	 
	 }
} 

tsline `countries' , `call' color(navy cranberry sienna maroon teal  dkorange forest_green khaki lavender ) ///
title("") ytitle("") xtitle("") title("Sovereigns", color(black)) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(1feb2020 15aug2020)) ///
tline(23mar2020, lcolor(gs8) lpattern(longdash))  ttext(1400 25feb2020 "G20 conference call") ///
tline(15apr2020, lcolor(gs8) lpattern(longdash))  ttext(1400 30may2020 "G20 announces debt forbearance")  
graph save "$files\spreads2.gph", replace

cd "$files\"
graph combine "spreads2.gph" "spreads1.gph", ysize(9) scale(0.8) ycommon xsize(16) row(1) ///
title("Hard Currency Bond Spreads in Emerging Markets (bps)", color(black)) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

graph export "$files\spreads_long.png", replace
graph export "$files\\spreads_long.eps", replace
}

/*-------------------------------
Cumulative Capital Inflows
----------------------------------*/

loc run = 1
if `run' == 1{

//Left Hand Side Chart (Billions)

import excel "$files\monthly_net_capital_flows_database june.xlsx", sheet("net capital flows") cellrange(A7:Y132) firstrow clear
rename B date
drop A
drop if date==. | date==22036 //Dropping May

destring Turkey Chile SaudiArabia Poland Ukraine, replace

keep date Argentina Brazil Chile China Egypt India Indonesia Malaysia Mexico Nigeria Poland SaudiArabia SouthAfrica Turkey Ukraine

preserve
gen year = year(date)
egen net_flow = rsum(Argentina - Ukraine)
collapse (sum) Argentina Brazil Chile China Egypt India Indonesia Malaysia Mexico Nigeria Poland SaudiArabia SouthAfrica Turkey Ukraine net_flow, by(year)
sort year
save "$files\bop_sum.dta", replace
restore

sort date
merge 1:1 date using "$files\CMO.dta"
drop if _m==2
drop _m
format CRUDE_BRENT %12.1f
levelsof CRUDE_BRENT if date==18263
replace CRUDE_BRENT = (CRUDE_BRENT/`r(levels)')

gen year = year(date)
gen month = month(date)
drop date
gen date = ym(year,month) 
format date %tm

egen net_flow = rsum(Argentina - Ukraine)

twoway (bar net_flow date, yaxis(1) color(emidblue) ) (line CRUDE_BRENT date, yaxis(2) color(black) ), ///
  xtitle(" ") ytitle("US$ billions", axis(1) ) ytitle("", axis(2) ) ///
  graphregion(color(white)) bgcolor(white) ///
  yscale( range(-.5 2) axis(2)) ylabel(0(.5)2, axis(2))  ///
  legend( position(12) label(1 "Monthly net capital flows to major EMDEs (left axis)") label( 2 "Brent crude oil price (right axis)") rows(2) ) ///
  scale(0.9)

graph save "$files\cap_flows1.gph", replace


/*egen net_flow = rsum(Argentina - Ukraine)
 tostring date, gen(date2) usedisplayformat force
 replace date2 = substr(date2,3,.)
 
graph bar net_flow , over( date2 , sort(date) label(angle(90))) bargap(-400) ytitle("") subtitle("US$ billions")   /// 
graphregion(color(white)) bgcolor(white) legend( off) scale(0.9)*/

//Right Hand Side Chart (Vs. GDP)

preserve
import delimited "$files\iif_gdp_2019.csv",  clear
rename v7 gdp
keep gdp country
tempfile gdp
replace country="SouthAfrica" if country=="South Africa"
replace country="SaudiArabia" if country=="Saudi Arabia"
sort country
save `gdp'
restore
import excel "$files\monthly_net_capital_flows_database june.xlsx", sheet("net capital flows") cellrange(A7:Y131) firstrow clear
loc countries Brazil China India Indonesia Mexico Nigeria SaudiArabia 
rename B date
drop A
tsset date

keep if date>=21640
drop if date==.

//Argentina-Ukraine
foreach v of varlist `countries' {
    replace `v' = 0 if date==21640
	gen cum_`v' = sum(`v')
	rename `v' lev_`v'
	}
	
keep date cum_* lev_*
reshape long cum_ lev_, i(date) j(country) string

sort country
merge m:1 country using `gdp'
drop if _m==2
drop _m

gen cap = cum_/gdp
gen lev = lev_/gdp
drop cum_ lev_ gdp

reshape wide cap lev, i(date) j(country) string

lab var capBrazil "Brazil"
lab var capChina "China"
//lab var capEgypt "Egypt"
lab var capIndonesia "Indonesia"
lab var capIndia "India"
lab var capMexico "Mexico"
lab var capNigeria "Nigeria"
//lab var capSouthAfrica "South Africa"
lab var capSaudiArabia "Saudi Arabia"
//lab var capThailand "Thailand"
//lab var capTurkey "Turkey"

tsset date

* get positions for explanatory text from latest value
loc textdate = 22006 + 1

foreach v of varlist cap* { 
     su `v' if date == 22006 , meanonly 
	 local name: variable label `v'
	 if "`v'" == "capIndonesia"{
	    loc m = `r(mean)'
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }	
	 else if "`v'" == "capNigeria"{
	    loc m = `r(mean)' + 0.001
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }	
	 else if "`v'" == "capIndia"{
	    loc m = `r(mean)'-.001
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }	
	 else {	
	 local call `call' text(`r(mean)' `textdate' "`name'",  place(r))  	 
     }  
} 

tsline cap* , `call' color(navy maroon cranberry  dkorange teal forest_green black  ) ///
ttitle("")  ytitle("Multiple of GDP") subtitle("Accumulated net flows over most recent year") scale(0.9) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(1mar2019 1jun2020)) tline(11mar2020, lcolor(gs8) lpattern(longdash))  ttext(-0.1 18dec2019  "WHO declares pandemic") 

graph save "$files\cap_flows2.gph", replace

cd "$files"
graph combine "cap_flows1.gph" "cap_flows2.gph", ysize(9) xsize(16) row(1) ///
title("Overall Net Capital Flows to Emerging Markets", color(black)) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

graph export "cap_flows.png", replace
graph export "cap_flows.eps", replace

}

/*---------------------
Commodities 
----------------------*/

loc run = 1
if `run' == 1{

//Metals and Energy
import delimited "$files\commoditites_energymetal_0714.csv", clear varnames(1)
gen date2 = date(date,"MDY",2050)
drop date
rename date2 date
format date %td
drop if date<21731 //July 1 2019
drop if date>`lastdate'

lab var jpmccinatural "Natural Gas"
lab var jpmccibrent "Crude Oil"
lab var jpmccialum "Alumininum"
lab var jpmccicomex "Copper"
lab var jpmccitin "Tin"
lab var jpmccigold "Gold"

sort date
foreach var of varlist jpmcc*{
	destring `var', replace
    loc base = `var'[1]
	replace `var' = `var'/`base'
}

tsset date

loc call 
loc textdate = `lastdate'
foreach v of varlist jpmcci* { 
     su `v' if date == `lastdate' , meanonly 
	 local name: variable label `v'
	 if "`v'" == "jpmccicomexcopperpriceindex"{
	    loc m = `r(mean)' 
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }	
	 else if "`v'" == "jpmccinaturalgaspriceindex"{
	    loc m = `r(mean)'+0.04
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "jpmccialuminiumpriceindex"{
	    loc m = `r(mean)' 
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }	
	 else if "`v'" == "jpmccitinpriceindex"{
	    loc m = `r(mean)' -0.03
	    local call `call' text(`m' `textdate' "`name'",  place(r))
	 }	
	 else{
		local call `call' text(`r(mean)' `textdate' "`name'",  place(r))
 	 }
} 

tsline jpmcci* , `call' color(navy black maroon forest_green dkorange teal) ///
 xtitle("")  title("Energy and Metals", color(black) ) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(01jul2019 20aug2020))  /// 
ttext(.45 20dec2019 "WHO declares pandemic")  tline(11mar2020, lcolor(gs8) lpattern(longdash))
 
graph save "$files\commodities_enmet.gph", replace

//Agriculture
import delimited "$files\commoditites_ag_0714.csv", clear varnames(1)
gen date2 = date(date,"MDY",2050)
drop date
rename date2 date
format date %td
drop if date<21731 //July 1 2019
drop if date>`lastdate'


lab var jpmccicocoa "Cocoa"
lab var jpmccicoffee "Coffee"
lab var jpmccicotton "Cotton"
lab var jpmccisugar "Sugar"
lab var jpmcciroughrice "Rice"

loc ags jpmccicocoa jpmccicoffee jpmccicotton jpmccisugar jpmcciroughrice

sort date
foreach var of varlist `ags'{
    destring `var', replace
    loc base = `var'[1]
	replace `var' = `var'/`base'
}

tsset date
loc call 
loc textdate = `lastdate'
foreach v of varlist `ags'{ 
     su `v' if date == `lastdate', meanonly 
	 local name: variable label `v'
	 if "`v'" == "jpmccicottonpriceindex"{
	    loc m = `r(mean)' +0.02
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "jpmccisugarpriceindex"{
	    loc m = `r(mean)' +0.01
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "jpmccicoffeepriceindex"{
	    loc m = `r(mean)' -0.01
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else if "`v'" == "jpmccicocoapriceindex"{
	    loc m = `r(mean)' -0.04
		local call `call' text(`m' `textdate' "`name'",  place(r))
	 }
	 else{
		local call `call' text(`r(mean)' `textdate' "`name'",  place(r))
	 }
} 


tsline `ags', `call' color(navy maroon forest_green dkorange teal) ///
  xtitle("") title("Agricultural Products", color(black) ) graphregion( color(white)) bgcolor(white) ///
legend( off) tscale( range(1jul2019 20aug2020))  /// 
  tline(11mar2020, lcolor(gs8) lpattern(longdash))
 
graph save "$files\commodities_ag.gph", replace

cd "$files"
graph combine "commodities_enmet.gph" "commodities_ag", ysize(9) xsize(16) row(1) ///
title("Commodity Prices", color(black)) ycommon scale(0.9) imargin(vlarge) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

graph export "$files\commodities.png", replace
graph export "$files\commodities.eps", replace

}

//External Recession Risk Factors
/*
loc run = 0
if `run' == 1{

wbopendata, long clear indicator(EG.IMP.CONS.ZS; SP.POP.TOTL; ST.INT.RCPT.CD; NY.GDP.MKTP.CD; NY.GDP.TOTL.RT.ZS; BX.TRF.PWKR.CD.DT; TX.VAL.AGRI.ZS.UN; TX.VAL.MRCH.CD.WT)

gen pop = sp_pop_totl
gen energy_imp = eg_imp_cons_zs
gen resources = ny_gdp_totl_rt_zs
gen agric = ((( tx_val_agri_zs_un/100)*tx_val_mrch_cd_wt)/ny_gdp_mktp_cd)*100
gen tourism = st_int_rcpt_cd/ny_gdp_mktp_cd*100
gen remit = bx_trf_pwkr_cd_dt/ny_gdp_mktp_cd*100

drop if ny_gdp_mktp_cd==.

gen inc = .
replace inc = 1 if incomelevel=="LIC"
replace inc = 2 if incomelevel=="LMC"
replace inc = 3 if incomelevel=="UMC"
replace inc = 4 if incomelevel=="HIC"

lab def income 1 "Low income" 2 "Lower-middle income" 3 "Upper-middle income" 4 "High income"
lab val inc income

keep inc countrycode countryname tourism remit year resources agric energy_imp pop
drop if inc==.

foreach var of varlist energy_imp resources agric tourism remit pop {
		gen temp_year = year if `var'!=.
		bys countrycode: egen mr_year_`var' = max(temp_year)
		gen temp_mr_`var' = `var' if year == mr_year_`var'
		bys countrycode: egen mr_`var' = min(temp_mr_`var')
		drop temp_year temp_mr_`var'
} 

keep inc mr_* countryname countrycode
duplicates drop

save "$files\tour_remit.dta", replace
}
*/

loc run = 1
if `run' == 1{

use "$files\tour_remit.dta", clear
cd "$files"

graph bar (mean) mr_tourism , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income" "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("% of GDP")  blabel(bar, format(%4.1f) size(medsmall) ) ylabel(none) yscale(range(0 12) lstyle(none)) ///
subtitle("International tourism receipts", color(black) ) 

graph save "tourism.gph", replace

graph bar (mean) mr_remit , over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("% of GDP")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 9) lstyle(none))   ///
subtitle("Personal remittances recieved", color(black) ) 

graph save "remit.gph", replace

/*graph combine "tourism.gph" "remit.gph" , ycommon row(1) ///
title("", color(black))  xsize(16) ysize(9) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

graph export "risk2.eps", replace
graph export "risk2.pdf", replace*/

graph bar (mean) mr_agric, over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("% of GDP")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 9) lstyle(none))   ///
subtitle("Agricultural raw materials exports", color(black) ) 

graph save "agric.gph", replace

graph bar (mean) mr_resources, over(inc, relabel(1 `" "Low-income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("% of GDP")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 9) lstyle(none))   ///
subtitle("Natural resource rents", color(black) ) 

graph save "resources.gph", replace

graph combine  "agric.gph" "tourism.gph" "resources.gph" "remit.gph" , ycommon row(2) ///
title("Risk Factors for Exposure to External Recession", color(black)) subtitle("average by income group", color(black)) scale(.81) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

graph export "risk.png", replace
graph export "risk.eps", replace

/*
graph save "risk1.gph", replace

graph bar (mean) mr_energy_imp, over(inc, relabel(1 `" "Low income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 9) lstyle(none))   ///
subtitle("Net energy Imports (% of energy use)", color(black) ) 

graph save "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\out\energy_imp.gph", replace

replace mr_pop = mr_pop/1000000

graph bar (mean) mr_pop, over(inc, relabel(1 `" "Low income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income"  "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("")  blabel(bar, format(%4.1f)  size(medsmall)) ylabel(none) yscale(range(0 9) lstyle(none))   ///
subtitle("Population (millions)", color(black) ) 

graph save "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\out\pop.gph", replace

graph combine  "energy_imp.gph" "pop.gph", row(1)  scale(.81) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

graph save "risk2.gph", replace

graph combine  "risk1.gph" "risk2.gph", col(1) scale(.81) ///
graphregion(lcolor(white) ilcolor(white) fcolor(white) ifcolor(white)) plotregion(lcolor(white) ilcolor(white) style(white))

/*
graph bar (mean) mr_energy_imp, over(inc, relabel(1 `" "Low income" "countries" "' ///
2 `" "Lower-middle" "income" "countries" "' ///
3`" "Upper-middle" "income" "countries" "'  /// 
4 `" "High income" "countries" "'))  bargap(-15) graphregion(color(white)) ///
bar(1, color(emerald))  bar(2, color(emerald)) bar(3, color(emerald))  bar(4, color(emerald))  ///
ytitle("")  blabel(bar, format(%4.1f) size(medsmall) ) ylabel(none) yscale(range(0 12) lstyle(none)) ///
subtitle("Energy Imports (% of Energy Use)", color(black) ) 

graph save "C:\Users\wb326023\OneDrive - WBG\Covid BPEA\out\energy.gph", replace*/
*/
}
