cap log close
clear
set more off

global projdir <The Replication Packet Directory>
global initial_microdatadir <Where The Initial Micro Data Are Stored. Not Included with Replication Packet>
global resultsdir "$projdir/Results/Regressions"

file close _all
program drop _all
log using "$projdir/Logs/employment_regressions.log", replace

program main
	regs // Run Regressions for Figure A4
	plots // Make Figure A4
end

program regs
	use "$initial_microdatadir/regression_data", clear

	* Run regressions
	#delimit ;
	fvset base 5 wage_quintile;
	fvset base 2 month;
	eststo nocont: 			 reg employed i.month##i.wage_quintile, 
							 vce(cluster naics3xSize);
	estadd ysumm;
	fvset base 5 wage_quintile;
	fvset base 2 month;
	eststo ind: 			 areg employed i.month##i.wage_quintile 
							 i.month#i.indnum, 
							 vce(cluster naics3xSize) absorb(indnum);
	estadd ysumm;
	fvset base 5 wage_quintile;
	fvset base 2 month;
	eststo indSize: 		 reghdfe employed i.month##i.wage_quintile 
							 i.month#i.indnum i.month#i.size_SUSB, 
							 absorb(indnum size_SUSB) vce(cluster naics3xSize);
	estadd ysumm;
	fvset base 5 wage_quintile;
	fvset base 2 month;
	eststo indSizeDemo: 	 reghdfe employed i.month##i.wage_quintile 
							 i.month#i.indnum i.month#i.size_SUSB
							 female c.female#i.month i.age_group i.age_group#i.month, 
							 absorb(indnum size_SUSB) vce(cluster naics3xSize);
	estadd ysumm;
	fvset base 5 wage_quintile;
	fvset base 2 month;
	eststo indSizeDemoState: reghdfe employed i.month##i.wage_quintile 
							 i.month#i.indnum i.month#i.size_SUSB 
							 female c.female#i.month i.age_group i.age_group#i.month 
							 i.month#i.statenum, 
							 absorb(indnum size_SUSB statenum) vce(cluster naics3xSize);
	estadd ysumm;
	estwrite * using "$resultsdir/employed_regs.sters", replace;
	
	
	** Sex Regressions;
	fvset base 0 female;
	fvset base 2 month;
	eststo nocont: 			 reg employed i.month##c.female, 
							 vce(cluster naics3xSize);
	estadd ysumm;
	fvset base 0 female;
	fvset base 2 month;
	eststo ind: 			 areg employed i.month##c.female
							 i.month#i.indnum, 
							 vce(cluster naics3xSize) absorb(indnum);
	estadd ysumm;
	fvset base 0 female;
	fvset base 2 month;
	eststo indSize: 		 reghdfe employed i.month##c.female
							 i.month#i.indnum i.month#i.size_SUSB, 
							 absorb(indnum size_SUSB) vce(cluster naics3xSize);
	estadd ysumm;
	fvset base 0 female;
	fvset base 2 month;
	eststo indSizeDemo: 	 reghdfe employed i.month##c.female
							 i.month#i.indnum i.month#i.size_SUSB
							 i.age_group i.age_group#i.month, 
							 absorb(indnum size_SUSB) vce(cluster naics3xSize);
	estadd ysumm;
	fvset base 0 female;
	fvset base 2 month;
	eststo indSizeDemoState: reghdfe employed i.month##c.female
							 i.month#i.indnum i.month#i.size_SUSB 
							 i.age_group i.age_group#i.month 
							 i.month#i.statenum, 
							 absorb(indnum size_SUSB statenum) vce(cluster naics3xSize);
	estadd ysumm;
	estwrite * using "$resultsdir/employed_regs_sex.sters", replace;
	#delimit cr
end

program plots
	#delimit ;
	estread * using "$resultsdir/employed_regs.sters";
	
	coefplot (nocont, ciopts(recast(rcap) lc(black) lp(solid)) mc(black) msymbol(circle))
			 (indSize, ciopts(recast(rcap) lc(gs12) lp(solid)) mc(gs12) msymbol(triangle)) 
			 (indSizeDemo, ciopts(recast(rcap) lc(blue) lp(dash_dot)) mc(blue) msymbol(square))
			 (indSizeDemoState, ciopts(recast(rcap) lc(red) lp(solid)) mc(red) msymbol(diamond)), 
			 keep(5.month#*.wage_quintile) vertical yline(0) graphregion(color(white))
			 coeflabels(5.month#1.wage_quintile = "1st"
						5.month#2.wage_quintile = "2nd"
						5.month#3.wage_quintile = "3rd"
						5.month#4.wage_quintile = "4th")
			 xtitle("Wage Quintile")
			 ytitle("Employment Probability in May," "Relative to Top Quintile")
			 legend(label(2 "No Controls") label(4 "Add Ind and Size FE")
					label(6 "Add Demographic Cont.") label(8 "Add State FE") row(2));
	graph export "$resultsdir/employed_quintile_coefplot_May.pdf", replace;
	
	coefplot (nocont, ciopts(recast(rcap) lc(black) lp(solid)) mc(black) msymbol(circle))
			 (indSize, ciopts(recast(rcap) lc(gs12) lp(solid)) mc(gs12) msymbol(triangle)) 
			 (indSizeDemo, ciopts(recast(rcap) lc(blue) lp(dash_dot)) mc(blue) msymbol(square))
			 (indSizeDemoState, ciopts(recast(rcap) lc(red) lp(solid)) mc(red) msymbol(diamond)), 
			 keep(4.month#*.wage_quintile) vertical yline(0) graphregion(color(white))
			 coeflabels(4.month#1.wage_quintile = "1st"
						4.month#2.wage_quintile = "2nd"
						4.month#3.wage_quintile = "3rd"
						4.month#4.wage_quintile = "4th")
			 xtitle("Wage Quintile")
			 ytitle("Employment Probability in April," "Relative to Top Quintile")
			 legend(label(2 "No Controls") label(4 "Add Ind and Size FE")
					label(6 "Add Demographic Cont.") label(8 "Add State FE") row(2));
	graph export "$resultsdir/employed_quintile_coefplot_April.pdf", replace;
	
	coefplot (nocont, ciopts(recast(rcap) lc(black) lp(solid)) mc(black) msymbol(circle))
			 (indSize, ciopts(recast(rcap) lc(gs12) lp(solid)) mc(gs12) msymbol(triangle)) 
			 (indSizeDemo, ciopts(recast(rcap) lc(blue) lp(dash_dot)) mc(blue) msymbol(square))
			 (indSizeDemoState, ciopts(recast(rcap) lc(red) lp(solid)) mc(red) msymbol(diamond)), 
			 keep(3.month#*.wage_quintile) vertical yline(0) graphregion(color(white))
			 coeflabels(3.month#1.wage_quintile = "1st"
						3.month#2.wage_quintile = "2nd"
						3.month#3.wage_quintile = "3rd"
						3.month#4.wage_quintile = "4th")
			 xtitle("Wage Quintile")
			 ytitle("Employment Probability in March," "Relative to Top Quintile")
			 legend(label(2 "No Controls") label(4 "Add Ind and Size FE")
					label(6 "Add Demographic Cont.") label(8 "Add State FE") row(2));
	graph export "$resultsdir/employed_quintile_coefplot_March.pdf", replace;
	
	#delimit ;
	estread * using "$resultsdir/employed_regs_sex.sters";
	
	coefplot (nocont, ciopts(recast(rcap) lc(black) lp(solid)) mc(black) msymbol(circle))
			 (indSize, ciopts(recast(rcap) lc(gs12) lp(solid)) mc(gs12) msymbol(triangle)) 
			 (indSizeDemo, ciopts(recast(rcap) lc(blue) lp(dash_dot)) mc(blue) msymbol(square))
			 (indSizeDemoState, ciopts(recast(rcap) lc(red) lp(solid)) mc(red) msymbol(diamond)), 
			 keep(4.month#c.female 5.month#c.female) vertical yline(0) graphregion(color(white))
			 coeflabels(2.month#c.female = "February"
						3.month#c.female = "March"
						4.month#c.female = "April"
						5.month#c.female = "May")
			 xtitle("")
			 ytitle("Female Employment Probability," "Relative to Men")
			 legend(label(2 "No Controls") label(4 "Add Ind and Size FE")
					label(6 "Add Demographic Cont.") label(8 "Add State FE") row(2));
	graph export "$resultsdir/employed_sex_coefplot.pdf", replace;
	#delimit cr
end

main
log close
