// Requires weightfilex_tot_[EMP|ACT]${stub} created by cleaned_panel.do

clear all

set more off
global rpath   = "path/results"
global sspath  = "path/stata_small"
global logpath = "path/log_files"
global blspath = "path/BLS_data"

set more off
local ent = ""
local ent = "_noent"

global stub = "`ent'_susb_bcont"
	
		
// Vintage
local dlistcut="18jul2020"

// Base date for employment comparisons
local startdate = td(15feb2020)

// Percentile growth between startdate and this date
local dlist="20jun2020"
//local dlist="25apr2020"

local count=1

// ADP VINTAGE
if 1 {
	// Vintage dates: the final grid_date
	foreach d of local dlistcut {
		// End points
		foreach refdate of local dlist {
			
			local vintagedate = td(`d')
			local enddate = td(`refdate')
			
			use $spath/master_grid_y2020_update, clear
		
			// drop enterprise
			cap gen ent = 1 if file_name != "" 
			if "`ent'" == "_noent" {
				capture drop if ent == 1
			}
			
			// Assign Vintage Date
			gen vin_year=year(`vintagedate')
			gen vin_month=month(`vintagedate')
			gen vin_day=day(`vintagedate')
			gen vin_date=`vintagedate'
			format vin_date %td
			
			// recode to naics sectors
			replace indcodenum=31 if indcodenum==30 | indcodenum==31 | indcodenum==32 | indcodenum==33
			replace indcodenum=44 if indcodenum==43 | indcodenum==44 | indcodenum==45 
			replace indcodenum=48 if indcodenum==47 | indcodenum==48 | indcodenum==49 
			
			// step3 size_code definition:
			//egen size_code = cut(step_act), at(0, 5, 10, 20, 50, 100, 250, 500, 1000, 1000000000) icodes 
			//replace size_code=size_code+1 // Size codes 1-9, 1 is under 5 emp, 2 is 5-9, etc.					
					
			egen detailed_size_code_act = cut(step_act), at(0, 50, 500, 1000000000) icodes 
			replace detailed_size_code_act=detailed_size_code_act+1 	
			egen detailed_size_code_emp = cut(step_emp), at(0, 50, 500, 1000000000) icodes 
			replace detailed_size_code_emp=detailed_size_code_emp+1 		

			drop size_code
			egen size_code = cut(step_act), at(0, 20, 50, 100, 300, 500, 1000000000) icodes 
			replace size_code=size_code+1 // Size codes 1-9, 1 is under 5 emp, 2 is 5-9, etc.							
			
			// Important that we cut by lead_last_paid, not grid_date
			keep if lead_last_paid<=`vintagedate'
				
			quietly: sum grid_date
			local max_grid=r(max)
			drop if freq=="M"

			// if they had valid paycheck data and too big of a gap, drop
			gen dd = (last_paid~=.) & (lead_last_paid~=.) 
			drop if  dd==1 & ( (lead_last_paid-last_paid)>=25 )

			if `enddate'<=`max_grid' {
				gen flag = 0
				replace flag = 1 if grid_date == `startdate'
				replace flag = 1 if grid_date == `enddate'
				
				keep if flag == 1

				keep pac id vin_* freq step_act step_emp grid_date last_paid lead_last_paid best_* indcodenum size_code detailed_size_code* big_gap 

				gen time = 1 
				replace time = 2 if grid_date > `startdate'
				tsset id time
		
				gen paycheck_diff = d.lead_last_paid 
				gen grid_date_diff = d.grid_date
				drop if paycheck_diff == 0 & grid_date_diff>20 // drop weirdos

				// if they had valid paycheck data and too big of a gap, drop
				gen dd = (last_paid~=.) & (lead_last_paid~=.) 
				drop if  dd==1 & ( (lead_last_paid-last_paid)>=25 )
				
				gen d_step_act = d.step_act
				gen d_step_emp = d.step_emp
				gen l_step_act = l.step_act
				gen l_step_emp = l.step_emp
			  
				// Initial Size 
				gen initial_detailed_size_code_act = l.detailed_size_code_act
				gen initial_detailed_size_code_emp = l.detailed_size_code_emp

				gen initial_size_code=l.size_code
				drop if initial_size_code==. // Drop births
	
				drop if time == 1
				drop if initial_detailed_size_code_emp == .

				drop size_code 
				rename initial_size_code size_code
			
				merge m:1 vin_date indcodenum size_code using $spath/weightfilex_tot_emp${stub}, keep(3) nogen
				merge m:1 vin_date indcodenum size_code using $spath/weightfilex_tot_act${stub}, keep(3) nogen

				gen empwt = l_step_emp * wvar_tot_emp
				gen growth_emp = d_step_emp / l_step_emp

				gen actwt = l_step_act * wvar_tot_act
				gen growth_act = d_step_act / l_step_act

				save $spath/temp, replace

				collapse /// 
				 (p10) p10_emp= growth_emp ///
				 (p20) p20_emp= growth_emp ///
				 (p30) p30_emp= growth_emp ///
				 (p40) p40_emp= growth_emp ///
				 (p50) p50_emp= growth_emp ///
				 (p60) p60_emp= growth_emp ///
				 (p70) p70_emp= growth_emp ///
				 (p80) p80_emp= growth_emp ///
				 (p90) p90_emp= growth_emp ///
				   [pw=empwt], by(initial_detailed_size_code_emp)
				   
				   rename p* p*_szemp
				   rename *size_code* initial_detailed_size_code
				   
				  save $spath/ptile$stub, replace
				
				use $spath/temp, clear
   				
				collapse /// 
				 (p10) p10_emp= growth_emp ///
				 (p20) p20_emp= growth_emp ///
				 (p30) p30_emp= growth_emp ///
				 (p40) p40_emp= growth_emp ///
				 (p50) p50_emp= growth_emp ///
				 (p60) p60_emp= growth_emp ///
				 (p70) p70_emp= growth_emp ///
				 (p80) p80_emp= growth_emp ///
				 (p90) p90_emp= growth_emp ///
				   [pw=empwt], by(initial_detailed_size_code_act)
				   
				   rename p* p*_szact
				   rename *size_code* initial_detailed_size_code

				 merge 1:1 initial_detailed_size_code using $spath/ptile$stub, nogen
				 save $spath/ptile$stub, replace
				 
				use $spath/temp, clear

   				 collapse /// 
				 (p10) p10_act= growth_act ///
				 (p20) p20_act= growth_act ///
				 (p30) p30_act= growth_act ///
				 (p40) p40_act= growth_act ///
				 (p50) p50_act= growth_act ///
				 (p60) p60_act= growth_act ///
				 (p70) p70_act= growth_act ///
				 (p80) p80_act= growth_act ///
				 (p90) p90_act= growth_act ///
				   [pw=actwt], by(initial_detailed_size_code_emp)
 				   rename p* p*_szemp
				   rename *size_code* initial_detailed_size_code

				 merge 1:1 initial_detailed_size_code using $spath/ptile$stub, nogen
				 save $spath/ptile$stub, replace
			
			   use $spath/temp, clear

   				 collapse /// 
				 (p10) p10_act= growth_act ///
				 (p20) p20_act= growth_act ///
				 (p30) p30_act= growth_act ///
				 (p40) p40_act= growth_act ///
				 (p50) p50_act= growth_act ///
				 (p60) p60_act= growth_act ///
				 (p70) p70_act= growth_act ///
				 (p80) p80_act= growth_act ///
				 (p90) p90_act= growth_act ///
				   [pw=actwt], by(initial_detailed_size_code_act)
 				   rename p* p*_szact
				   rename *size_code* initial_detailed_size_code

				 merge 1:1 initial_detailed_size_code using $spath/ptile$stub, nogen
				 			
			gen vin_date=td(`d')
			format vin_date %td
			order vin_date

			 save $spath/ptile$stub, replace
  			}	
		}
	}
}

// EXPORT
use $spath/ptile$stub, clear
sort initial_detailed_size_code
export excel using $rpath/ptile${stub}_`dlist'.xlsx, replace firstrow(variables)
